/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.enums;

import org.springframework.core.enums.LabeledEnum;
import org.springframework.util.Assert;

public abstract class AbstractLabeledEnum
implements LabeledEnum {
    protected AbstractLabeledEnum() {
    }

    public Class getType() {
        return this.getClass();
    }

    public abstract Comparable getCode();

    public abstract String getLabel();

    public int compareTo(Object obj) {
        Assert.isTrue(obj instanceof AbstractLabeledEnum, "You may only compare LabeledEnums");
        LabeledEnum other = (LabeledEnum)obj;
        Assert.isTrue(this.getType().equals(other.getType()), "You may only compare LabeledEnums of the same type");
        return this.getCode().compareTo(other.getCode());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof LabeledEnum)) {
            return false;
        }
        LabeledEnum other = (LabeledEnum)obj;
        return this.getType().equals(other.getType()) && this.getCode().equals(other.getCode());
    }

    public int hashCode() {
        return this.getType().hashCode() * 29 * this.getCode().hashCode();
    }

    public String toString() {
        String enumStr = this.getLabel() != null ? this.getLabel() + " (" + this.getCode() + ")" : String.valueOf(this.getCode());
        return "[" + this.getType() + "." + enumStr + "]";
    }
}

