/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.jasperserver.irplugin.gui;

import com.jaspersoft.jasperserver.irplugin.IRPlugin;
import it.businesslogic.ireport.util.I18n;
import it.businesslogic.ireport.util.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.text.JTextComponent;

public class JRPluginConfigurationDialog
extends JDialog {
    private JButton jButton1;
    private JButton jButton2;
    private JCheckBox jCheckBox1;
    private JCheckBox jCheckBoxEnableAuth;
    private JCheckBox jCheckBoxEnableProxy;
    private JLabel jLabelPassword;
    private JLabel jLabelProxy;
    private JLabel jLabelProxy1;
    private JLabel jLabelProxyURL;
    private JLabel jLabelUsername;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JPasswordField jPasswordField1;
    private JSeparator jSeparator1;
    private JTextField jTextFieldURL;
    private JTextField jTextFieldUsername;

    public JRPluginConfigurationDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.applyI18n();
        Properties props = IRPlugin.getMainInstance().getProperties();
        this.jCheckBox1.setSelected(props.getProperty("PROPERTY_CHECK_FOR_UPDATE", "true").equals("true"));
        this.jCheckBoxEnableProxy.setSelected(props.getProperty("PROPERTY_USE_PROXY", "false").equals("true"));
        this.jTextFieldURL.setText(props.getProperty("PROPERTY_PROXY_URL", ""));
        this.jCheckBoxEnableAuth.setSelected(props.getProperty("PROPERTY_PROXY_USE_AUTH", "false").equals("true"));
        this.jTextFieldUsername.setText(props.getProperty("PROPERTY_PROXY_USERNAME", ""));
        ((JTextComponent)this.jPasswordField1).setText(props.getProperty("PROPERTY_PROXY_PASSWORD", ""));
        this.updateProxyUse();
        Misc.centerFrame((Component)this);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRPluginConfigurationDialog.this.jButton2ActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, "ESCAPE");
        this.getRootPane().getActionMap().put("ESCAPE", escapeAction);
        this.getRootPane().setDefaultButton(this.jButton1);
        this.pack();
    }

    private void initComponents() {
        this.jCheckBox1 = new JCheckBox();
        this.jPanel3 = new JPanel();
        this.jLabelProxy = new JLabel();
        this.jCheckBoxEnableProxy = new JCheckBox();
        this.jLabelProxyURL = new JLabel();
        this.jTextFieldURL = new JTextField();
        this.jCheckBoxEnableAuth = new JCheckBox();
        this.jLabelUsername = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabelPassword = new JLabel();
        this.jPasswordField1 = new JPasswordField();
        this.jLabelProxy1 = new JLabel();
        this.jSeparator1 = new JSeparator();
        this.jPanel1 = new JPanel();
        this.jPanel2 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.addWindowListener(new WindowAdapter(){

            public void windowOpened(WindowEvent evt) {
                JRPluginConfigurationDialog.this.formWindowOpened(evt);
            }
        });
        this.getContentPane().setLayout(new GridBagLayout());
        this.jCheckBox1.setText("Check for update on iReport startup");
        this.jCheckBox1.setMinimumSize(new Dimension(350, 50));
        this.jCheckBox1.setPreferredSize(new Dimension(350, 24));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.getContentPane().add((Component)this.jCheckBox1, gridBagConstraints);
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Proxy configuration"));
        this.jPanel3.setPreferredSize(new Dimension(404, 220));
        this.jPanel3.setLayout(new GridBagLayout());
        this.jLabelProxy.setText("<html>If you need a HTTP proxy, enter it here in the format HOST:PORT<br>e.g. squid.mysite.com:3128");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelProxy, gridBagConstraints);
        this.jCheckBoxEnableProxy.setText("Enable HTTP Proxy");
        this.jCheckBoxEnableProxy.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxEnableProxy.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxEnableProxy.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPluginConfigurationDialog.this.jCheckBoxEnableProxyActionPerformed(evt);
            }
        });
        this.jCheckBoxEnableProxy.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JRPluginConfigurationDialog.this.jCheckBoxEnableProxyStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jCheckBoxEnableProxy, gridBagConstraints);
        this.jLabelProxyURL.setText("Proxy address");
        this.jLabelProxyURL.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelProxyURL, gridBagConstraints);
        this.jTextFieldURL.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextFieldURL, gridBagConstraints);
        this.jCheckBoxEnableAuth.setText("Use Authentication");
        this.jCheckBoxEnableAuth.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jCheckBoxEnableAuth.setEnabled(false);
        this.jCheckBoxEnableAuth.setMargin(new Insets(0, 0, 0, 0));
        this.jCheckBoxEnableAuth.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                JRPluginConfigurationDialog.this.jCheckBoxEnableAuthStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jCheckBoxEnableAuth, gridBagConstraints);
        this.jLabelUsername.setText("Username");
        this.jLabelUsername.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelUsername, gridBagConstraints);
        this.jTextFieldUsername.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jTextFieldUsername, gridBagConstraints);
        this.jLabelPassword.setText("Password");
        this.jLabelPassword.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelPassword, gridBagConstraints);
        ((JTextComponent)this.jPasswordField1).setText("jPasswordField1");
        this.jPasswordField1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.jPanel3.add((Component)this.jPasswordField1, gridBagConstraints);
        this.jLabelProxy1.setText("<html><b>You must restart the application in order for the proxy changes to take effect.");
        this.jLabelProxy1.setPreferredSize(new Dimension(380, 28));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanel3.add((Component)this.jLabelProxy1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(0, 4));
        this.jSeparator1.setPreferredSize(new Dimension(0, 4));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        this.getContentPane().add((Component)this.jSeparator1, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.jPanel1.add((Component)this.jPanel2, gridBagConstraints);
        this.jButton1.setText("Save");
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPluginConfigurationDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText("Cancel");
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRPluginConfigurationDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(4, 0, 4, 10);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jCheckBoxEnableAuthStateChanged(ChangeEvent evt) {
        this.updateAuthUse();
    }

    private void jCheckBoxEnableProxyStateChanged(ChangeEvent evt) {
        this.updateProxyUse();
    }

    private void jCheckBoxEnableProxyActionPerformed(ActionEvent evt) {
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        ((Component)this).setVisible(false);
        this.dispose();
    }

    private void formWindowOpened(WindowEvent evt) {
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.jCheckBoxEnableProxy.isSelected()) {
            String urlStr = this.jTextFieldURL.getText();
            if (urlStr.length() == 0) {
                JOptionPane.showMessageDialog(this, "Invalid proxy url", "", 0);
                return;
            }
            if (!IRPlugin.isValidUrl(this.jTextFieldURL.getText())) {
                JOptionPane.showMessageDialog(this, I18n.getString((String)"checkUpdateDialog.message.invalidUrl", (String)"Invalid proxy url"), "", 0);
                return;
            }
            if (this.jCheckBoxEnableAuth.isSelected() && this.jTextFieldUsername.getText().length() == 0) {
                JOptionPane.showMessageDialog(this, I18n.getString((String)"checkUpdateDialog.message.invalidUsername", (String)"Invalid username"), "", 0);
                return;
            }
        }
        Properties props = IRPlugin.getMainInstance().getProperties();
        props.setProperty("PROPERTY_CHECK_FOR_UPDATE", "" + this.jCheckBox1.isSelected());
        props.setProperty("PROPERTY_USE_PROXY", "" + this.jCheckBoxEnableProxy.isSelected());
        props.setProperty("PROPERTY_PROXY_URL", "" + this.jTextFieldURL.getText());
        props.setProperty("PROPERTY_PROXY_USE_AUTH", "" + this.jCheckBoxEnableAuth.isSelected());
        props.setProperty("PROPERTY_PROXY_USERNAME", "" + this.jTextFieldUsername.getText());
        props.setProperty("PROPERTY_PROXY_PASSWORD", "" + new String(this.jPasswordField1.getPassword()));
        IRPlugin.getMainInstance().saveConfiguration();
        ((Component)this).setVisible(false);
        this.dispose();
    }

    public void applyI18n() {
        this.jCheckBox1.setText(IRPlugin.getString("checkUpdateDialog.checkbox1", "Check for updates when the plugin starts"));
        this.jButton1.setText(I18n.getString((String)"checkUpdateDialog.button1", (String)"Save"));
        this.jButton2.setText(I18n.getString((String)"checkUpdateDialog.button2", (String)"Cancel"));
        this.jCheckBoxEnableProxy.setText(I18n.getString((String)"checkUpdateDialog.enableProxy", (String)"Enable HTTP Proxy"));
        this.jCheckBoxEnableAuth.setText(I18n.getString((String)"checkUpdateDialog.useAuthentication", (String)"Use Authentication"));
        this.jLabelProxyURL.setText(I18n.getString((String)"checkUpdateDialog.jLabelProxyURL", (String)"Proxy address"));
        this.jLabelUsername.setText(I18n.getString((String)"checkUpdateDialog.jLabelUsername", (String)"Username"));
        this.jLabelPassword.setText(I18n.getString((String)"checkUpdateDialog.jLabelPassword", (String)"Password"));
        this.jLabelProxy.setText("<html>" + I18n.getString((String)"checkUpdateDialog.jLabelProxy", (String)"If you need a HTTP proxy, enter it here in the format HOST:PORT<br>e.g. squid.mysite.com:3128"));
        this.jButton1.setMnemonic(I18n.getString((String)"checkUpdateDialog.button1Mnemonic", (String)"s").charAt(0));
        this.jButton2.setMnemonic(I18n.getString((String)"checkUpdateDialog.button2Mnemonic", (String)"c").charAt(0));
    }

    private void updateProxyUse() {
        boolean enabled = this.jCheckBoxEnableProxy.isSelected();
        this.jTextFieldURL.setEnabled(enabled);
        this.jLabelProxyURL.setEnabled(enabled);
        this.jCheckBoxEnableAuth.setEnabled(enabled);
        this.updateAuthUse();
    }

    private void updateAuthUse() {
        boolean authEnabled = this.jCheckBoxEnableProxy.isSelected() && this.jCheckBoxEnableAuth.isSelected();
        this.jLabelUsername.setEnabled(authEnabled);
        this.jLabelPassword.setEnabled(authEnabled);
        this.jTextFieldUsername.setEnabled(authEnabled);
        this.jPasswordField1.setEnabled(authEnabled);
    }
}

