/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3;

import flash.util.FileUtils;
import flex2.compiler.CompilationUnit;
import flex2.compiler.as3.Extension;
import flex2.compiler.as3.SignatureAssertionRuntimeException;
import flex2.compiler.as3.SignatureEvaluator;
import flex2.compiler.as3.reflect.NodeMagic;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.common.CompilerConfiguration;
import flex2.compiler.util.CompilerMessage;
import flex2.compiler.util.MimeMappings;
import flex2.compiler.util.ThreadLocalToolkit;
import java.io.File;
import java.io.IOException;
import java.util.zip.Adler32;
import macromedia.asc.parser.Evaluator;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.PackageDefinitionNode;
import macromedia.asc.parser.ProgramNode;
import macromedia.asc.util.Context;

public final class SignatureExtension
implements Extension {
    public static final boolean debug = false;
    public static final String DEFAULT_SIG_DIR = "generated-signatures";
    public static final String WARNING_ATTRIBUTE = "SignatureExtension.warning";
    public static String signatureDirectory;
    private static SignatureExtension _instance;
    static final /* synthetic */ boolean $assertionsDisabled;

    private SignatureExtension() {
    }

    public static SignatureExtension getInstance() {
        if (_instance == null) {
            _instance = new SignatureExtension();
        }
        return _instance;
    }

    public static void init(CompilerConfiguration compilerConfig) {
        String tmp;
        if (!$assertionsDisabled && compilerConfig == null) {
            throw new AssertionError();
        }
        signatureDirectory = compilerConfig.getKeepGeneratedSignatures() ? ((tmp = compilerConfig.getSignatureDirectory()) == null ? DEFAULT_SIG_DIR : tmp) : null;
    }

    private void setWarning(CompilationUnit unit, CompilerMessage.CompilerWarning warning) {
        unit.getContext().setAttribute(WARNING_ATTRIBUTE, warning);
    }

    private CompilerMessage.CompilerWarning getWarning(CompilationUnit unit) {
        return (CompilerMessage.CompilerWarning)unit.getContext().getAttribute(WARNING_ATTRIBUTE);
    }

    public void parse1(CompilationUnit unit, TypeTable typeTable) {
        this.doSignatureGeneration(unit);
    }

    public void parse2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze1(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze2(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze3(CompilationUnit unit, TypeTable typeTable) {
    }

    public void analyze4(CompilationUnit unit, TypeTable typeTable) {
    }

    public void generate(CompilationUnit unit, TypeTable typeTable) {
    }

    private void doSignatureGeneration(CompilationUnit unit) {
        String sigString = SignatureExtension.generateSignature(unit);
        Long checksum = SignatureExtension.computeChecksum(unit, sigString);
        if (!$assertionsDisabled && unit.hasSignatureChecksum()) {
            throw new AssertionError((Object)("SignatureExtension is overwriting an existing checksum of " + unit.getSignatureChecksum() + " with " + checksum + ". Please email the Flex SDK team."));
        }
        unit.setSignatureChecksum(checksum);
        if (sigString != null && signatureDirectory != null) {
            ProgramNode pNode = (ProgramNode)unit.getSyntaxTree();
            PackageDefinitionNode pdn = (PackageDefinitionNode)pNode.pkgdefs.first();
            String pkgName = NodeMagic.getPackageName(pdn).replace('.', '_');
            String fileName = new File(unit.getSource().getNameForReporting()).getName();
            String srcName = fileName.substring(0, fileName.length() - MimeMappings.getExtension(unit.getSource().getMimeType()).length());
            String sigName = pkgName.concat(pkgName.equals("") ? "" : "_").concat(srcName).concat(".sig");
            try {
                FileUtils.writeClassToFile((String)signatureDirectory, (String)"", (String)sigName, (String)sigString);
            }
            catch (IOException ioe) {
                KeepGeneratedSignatureFileWritingFailed warning = new KeepGeneratedSignatureFileWritingFailed(sigName);
                warning.setPath(unit.getSource().getNameForReporting());
                this.setWarning(unit, warning);
            }
        }
    }

    private static String generateSignature(CompilationUnit unit) {
        Context cx = (Context)unit.getContext().getAttribute("cx");
        String sigString = null;
        int powerOfTwoBufferSize = (int)Math.pow(2.0, Math.round(Math.log(unit.getSource().size()) / Math.log(2.0)));
        SignatureEvaluator evaluator = new SignatureEvaluator(powerOfTwoBufferSize);
        evaluator.setLocalizationManager(ThreadLocalToolkit.getLocalizationManager());
        try {
            ((ProgramNode)unit.getSyntaxTree()).evaluate(cx, (Evaluator)evaluator);
            sigString = evaluator.getSignature();
        }
        catch (SignatureAssertionRuntimeException e) {
            String message = e.getMessage();
            StackTraceElement[] stack = e.getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement ste = stack[i];
                if (!ste.getClassName().endsWith("SignatureEvaluator") || !ste.getMethodName().equals("evaluate")) continue;
                message = message + ":" + ste.getLineNumber();
            }
            SignatureGenerationFailed warning = new SignatureGenerationFailed(e.node, message);
            warning.setPath(unit.getSource().getNameForReporting());
            warning.setLine(cx.input.getLnNum(e.node.pos()));
            warning.setColumn(cx.input.getColPos(e.node.pos()));
            unit.getContext().setAttribute(WARNING_ATTRIBUTE, warning);
        }
        return sigString;
    }

    private static Long computeChecksum(CompilationUnit unit, String sigString) {
        Long chksum = null;
        if (sigString != null) {
            byte[] bytes = sigString.getBytes();
            Adler32 checksum = new Adler32();
            checksum.update(bytes, 0, bytes.length);
            chksum = new Long(checksum.getValue());
        }
        return chksum;
    }

    static {
        $assertionsDisabled = !SignatureExtension.class.desiredAssertionStatus();
    }

    public static class SignatureGenerationFailed
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = 7217554980556429606L;
        public Node node;
        public String cause;

        public SignatureGenerationFailed(Node node, String cause) {
            this.node = node;
            this.cause = cause;
        }
    }

    public static class KeepGeneratedSignatureFileWritingFailed
    extends CompilerMessage.CompilerWarning {
        private static final long serialVersionUID = -2077778266808945113L;
        public String toFile;

        public KeepGeneratedSignatureFileWritingFailed(String toFile) {
            this.toFile = toFile;
        }
    }
}

