/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.as3.reflect;

import flex2.compiler.abc.Method;
import flex2.compiler.abc.Namespace;
import flex2.compiler.abc.Variable;
import flex2.compiler.as3.reflect.Attributes;
import flex2.compiler.as3.reflect.MetaData;
import flex2.compiler.as3.reflect.TypeTable;
import flex2.compiler.util.QName;
import flex2.compiler.util.QNameMap;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import macromedia.asc.parser.BinaryClassDefNode;
import macromedia.asc.parser.BinaryInterfaceDefinitionNode;
import macromedia.asc.parser.ClassDefinitionNode;
import macromedia.asc.parser.DefinitionNode;
import macromedia.asc.parser.FunctionCommonNode;
import macromedia.asc.parser.FunctionDefinitionNode;
import macromedia.asc.parser.InterfaceDefinitionNode;
import macromedia.asc.parser.NamespaceDefinitionNode;
import macromedia.asc.parser.Node;
import macromedia.asc.parser.VariableDefinitionNode;
import macromedia.asc.semantics.ReferenceValue;
import macromedia.asc.semantics.TypeValue;
import macromedia.asc.util.ObjectList;

public final class Class
implements flex2.compiler.abc.Class {
    private String name;
    private String superTypeName;
    private String[] interfaceNames;
    private QNameMap variables;
    private QNameMap methods;
    private QNameMap getters;
    private QNameMap setters;
    private Attributes attributes;
    private List metadata;
    private TypeTable typeTable;
    private boolean isInterface;
    static final /* synthetic */ boolean $assertionsDisabled;

    Class(ClassDefinitionNode clsdef, TypeTable typeTable) {
        int size;
        this.name = TypeTable.convertName(clsdef.cframe.builder.classname.toString());
        if (clsdef instanceof BinaryClassDefNode) {
            String choice1 = null;
            String choice2 = null;
            if (clsdef.baseref != null) {
                choice1 = TypeTable.convertName(clsdef.baseref);
            }
            if (clsdef.cframe.baseclass != null) {
                choice2 = TypeTable.convertName(clsdef.cframe.baseclass.builder.classname.toString());
            }
            if (choice1 == null || choice1.equals(choice2)) {
                this.superTypeName = choice2;
            } else if (choice2 == null) {
                this.superTypeName = choice1;
            } else if (!$assertionsDisabled) {
                throw new AssertionError((Object)(this.name + " extends " + choice1 + " _or_ " + choice2 + "??"));
            }
            this.isInterface = clsdef instanceof BinaryInterfaceDefinitionNode;
        } else {
            if (clsdef.cframe.baseclass != null) {
                this.superTypeName = TypeTable.convertName(clsdef.cframe.baseclass.builder.classname.toString());
            }
            this.isInterface = clsdef instanceof InterfaceDefinitionNode;
        }
        if (this.superTypeName == null) {
            String string = this.superTypeName = "Object".equals(this.name) ? null : "Object";
        }
        if (clsdef.attrs != null) {
            this.attributes = new Attributes(clsdef.attrs);
        }
        int n = size = clsdef.interfaces == null ? 0 : clsdef.interfaces.values.size();
        if (size != 0) {
            this.interfaceNames = new String[size];
            for (int i = 0; i < size; ++i) {
                ReferenceValue referenceValue = (ReferenceValue)clsdef.interfaces.values.get(i);
                if (referenceValue == null || referenceValue.slot == null) continue;
                TypeValue typeValue = (TypeValue)referenceValue.slot.getValue();
                if (typeValue != null) {
                    this.interfaceNames[i] = TypeTable.convertName(typeValue.name.toString());
                    continue;
                }
                if (!$assertionsDisabled) {
                    throw new AssertionError((Object)"There is an interface without a TypeValue...");
                }
            }
        }
        this.metadata = TypeTable.createMetaData((DefinitionNode)clsdef);
        this.typeTable = typeTable;
        this.processDefinitions(clsdef.statements.items);
        this.processDefinitions(clsdef.staticfexprs);
        this.processDefinitions(clsdef.instanceinits);
    }

    private void processDefinitions(ObjectList items) {
        int length;
        int n = length = items == null ? 0 : items.size();
        for (int i = 0; i < length; ++i) {
            Node stmt = (Node)items.get(i);
            if (stmt instanceof VariableDefinitionNode) {
                VariableDefinitionNode var = (VariableDefinitionNode)stmt;
                if (this.variables == null) {
                    this.variables = new QNameMap();
                }
                TypeTable.createVariable(var, this.variables, this);
                continue;
            }
            if (stmt instanceof FunctionDefinitionNode || stmt instanceof FunctionCommonNode) {
                FunctionDefinitionNode f;
                FunctionDefinitionNode functionDefinitionNode = f = stmt instanceof FunctionCommonNode ? ((FunctionCommonNode)stmt).def : (FunctionDefinitionNode)stmt;
                if (f == null) continue;
                switch (f.name.kind) {
                    case -78: {
                        if (this.getters == null) {
                            this.getters = new QNameMap();
                        }
                        TypeTable.createMethod(f, this.getters, this);
                        break;
                    }
                    case -98: {
                        if (this.setters == null) {
                            this.setters = new QNameMap();
                        }
                        TypeTable.createMethod(f, this.setters, this);
                        break;
                    }
                    default: {
                        if (f.ref != null && "$construct".equals(f.ref.name)) break;
                        if (this.methods == null) {
                            this.methods = new QNameMap();
                        }
                        TypeTable.createMethod(f, this.methods, this);
                        break;
                    }
                }
                continue;
            }
            if (!(stmt instanceof NamespaceDefinitionNode)) continue;
        }
    }

    public Variable getVariable(String[] namespaces, String name, boolean inherited) {
        flex2.compiler.abc.Class superType;
        Variable variable = null;
        for (int i = 0; i < namespaces.length && (this.variables == null || (variable = (Variable)this.variables.get(namespaces[i], name)) == null); ++i) {
        }
        if (variable == null && inherited && (superType = this.typeTable.getClass(this.superTypeName)) != null) {
            variable = superType.getVariable(namespaces, name, true);
        }
        return variable;
    }

    public QName[] getVariableNames() {
        return this.getQNameArray(this.variables);
    }

    public Method getMethod(String[] namespaces, String name, boolean inherited) {
        flex2.compiler.abc.Class superType;
        Method method = null;
        for (int i = 0; i < namespaces.length && (this.methods == null || (method = (Method)this.methods.get(namespaces[i], name)) == null); ++i) {
        }
        if (method == null && inherited && (superType = this.typeTable.getClass(this.superTypeName)) != null) {
            method = superType.getMethod(namespaces, name, true);
        }
        return method;
    }

    public QName[] getMethodNames() {
        return this.getQNameArray(this.methods);
    }

    public Method getGetter(String[] namespaces, String name, boolean inherited) {
        flex2.compiler.abc.Class superType;
        Method getter = null;
        for (int i = 0; i < namespaces.length && (this.getters == null || (getter = (Method)this.getters.get(namespaces[i], name)) == null); ++i) {
        }
        if (getter == null && inherited && (superType = this.typeTable.getClass(this.superTypeName)) != null) {
            getter = superType.getGetter(namespaces, name, true);
        }
        return getter;
    }

    public QName[] getGetterNames() {
        return this.getQNameArray(this.getters);
    }

    public Method getSetter(String[] namespaces, String name, boolean inherited) {
        flex2.compiler.abc.Class superType;
        Method setter = null;
        for (int i = 0; i < namespaces.length && (this.setters == null || (setter = (Method)this.setters.get(namespaces[i], name)) == null); ++i) {
        }
        if (setter == null && inherited && (superType = this.typeTable.getClass(this.superTypeName)) != null) {
            setter = superType.getSetter(namespaces, name, true);
        }
        return setter;
    }

    public QName[] getSetterNames() {
        return this.getQNameArray(this.setters);
    }

    public Namespace getNamespace(String nsName) {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public String getSuperTypeName() {
        return this.superTypeName;
    }

    public String[] getInterfaceNames() {
        return this.interfaceNames;
    }

    public flex2.compiler.abc.Attributes getAttributes() {
        return this.attributes;
    }

    public List getMetaData(String id, boolean inherited) {
        return this.getMetaData(id, inherited, new ArrayList(inherited ? 10 : (this.metadata != null ? this.metadata.size() : 1)));
    }

    private List getMetaData(String id, boolean inherited, List list) {
        flex2.compiler.abc.Class superType;
        if (this.metadata != null) {
            int length = this.metadata.size();
            for (int i = 0; i < length; ++i) {
                if (!id.equals(((MetaData)this.metadata.get(i)).getID())) continue;
                list.add(this.metadata.get(i));
            }
        }
        if (inherited && (superType = this.typeTable.getClass(this.superTypeName)) != null) {
            if (superType instanceof Class) {
                ((Class)superType).getMetaData(id, true, list);
            } else {
                list.addAll(superType.getMetaData(id, true));
            }
        }
        return list;
    }

    public boolean implementsInterface(String interfaceName) {
        flex2.compiler.abc.Class superType;
        boolean result = false;
        if (this.interfaceNames != null) {
            int size = this.interfaceNames.length;
            for (int i = 0; i < size; ++i) {
                if (interfaceName.equals(this.interfaceNames[i])) {
                    result = true;
                    continue;
                }
                Class interfaceType = (Class)this.typeTable.getClass(this.interfaceNames[i]);
                if (!interfaceType.isAssignableTo(interfaceName)) continue;
                result = true;
            }
        }
        if (!result && (superType = this.typeTable.getClass(this.superTypeName)) != null) {
            result = superType.implementsInterface(interfaceName);
        }
        return result;
    }

    public boolean isSubclassOf(String baseName) {
        if ("*".equals(baseName)) {
            return false;
        }
        return this.isAssignableTo(baseName);
    }

    public boolean isInterface() {
        return this.isInterface;
    }

    public boolean isAssignableTo(String baseName) {
        Class superType;
        int i;
        int length;
        if ("*".equals(baseName) || this.getName().equals(baseName)) {
            return true;
        }
        String superTypeName = this.getSuperTypeName();
        if (superTypeName != null && superTypeName.equals(baseName)) {
            return true;
        }
        String[] interfaceNames = this.getInterfaceNames();
        int n = length = interfaceNames == null ? 0 : interfaceNames.length;
        for (i = 0; i < length; ++i) {
            if (baseName == null || !baseName.equals(interfaceNames[i])) continue;
            return true;
        }
        if (superTypeName != null && (superType = (Class)this.typeTable.getClass(superTypeName)).isAssignableTo(baseName)) {
            return true;
        }
        int n2 = length = interfaceNames == null ? 0 : interfaceNames.length;
        for (i = 0; i < length; ++i) {
            Class interfaceType;
            if (interfaceNames[i] == null || !(interfaceType = (Class)this.typeTable.getClass(interfaceNames[i])).isAssignableTo(baseName)) continue;
            return true;
        }
        return false;
    }

    private QName[] getQNameArray(Map m) {
        if (m != null) {
            QName[] qNames = new QName[m.size()];
            int index = 0;
            Iterator i = m.keySet().iterator();
            while (i.hasNext()) {
                qNames[index] = (QName)i.next();
                ++index;
            }
            return qNames;
        }
        return null;
    }

    public void setTypeTable(Object typeTable) {
        this.typeTable = (TypeTable)typeTable;
    }

    static {
        $assertionsDisabled = !Class.class.desiredAssertionStatus();
    }
}

