/*
 * Decompiled with CFR 0.152.
 */
package flex2.compiler.mxml.builder;

import flex2.compiler.CompilationUnit;
import flex2.compiler.mxml.Configuration;
import flex2.compiler.mxml.builder.Builder;
import flex2.compiler.mxml.builder.ComponentBuilder;
import flex2.compiler.mxml.builder.InlineComponentBuilder;
import flex2.compiler.mxml.builder.PrimitiveBuilder;
import flex2.compiler.mxml.dom.ArrayNode;
import flex2.compiler.mxml.dom.CDATANode;
import flex2.compiler.mxml.dom.InlineComponentNode;
import flex2.compiler.mxml.dom.ModelNode;
import flex2.compiler.mxml.dom.Node;
import flex2.compiler.mxml.dom.PrimitiveNode;
import flex2.compiler.mxml.dom.XMLListNode;
import flex2.compiler.mxml.dom.XMLNode;
import flex2.compiler.mxml.lang.BindingHandler;
import flex2.compiler.mxml.lang.ValueNodeHandler;
import flex2.compiler.mxml.reflect.Type;
import flex2.compiler.mxml.reflect.TypeTable;
import flex2.compiler.mxml.rep.Array;
import flex2.compiler.mxml.rep.BindingExpression;
import flex2.compiler.mxml.rep.Model;
import flex2.compiler.mxml.rep.MxmlDocument;
import flex2.compiler.util.CompilerMessage;
import java.util.Collection;
import java.util.Iterator;

class ArrayBuilder
extends Builder {
    private ElementNodeHandler elementNodeHandler = new ElementNodeHandler();
    private ElementBindingHandler elementBindingHandler = new ElementBindingHandler();
    private Type elementType;
    private Model parent;
    private String name;
    private boolean allowBinding;
    Array array;
    static final /* synthetic */ boolean $assertionsDisabled;

    ArrayBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document) {
        this(unit, typeTable, configuration, document, null, null, true, typeTable.objectType);
    }

    ArrayBuilder(CompilationUnit unit, TypeTable typeTable, Configuration configuration, MxmlDocument document, Model parent, String name, boolean allowBinding, Type elementType) {
        super(unit, typeTable, configuration, document);
        this.elementType = elementType;
        this.parent = parent;
        this.name = name;
        this.allowBinding = allowBinding;
    }

    public void analyze(ArrayNode node) {
        this.createArrayModel((String)node.getAttribute("id"), node.beginLine);
        this.processChildren(node.getChildren());
    }

    public void createArrayModel(String id, int line) {
        this.array = new Array(this.document, this.elementType, this.parent, line);
        this.array.setParentIndex(this.name);
        this.registerModel(id, (Model)this.array, this.parent == null);
    }

    void createSyntheticArrayModel(int line) {
        this.createArrayModel(null, line);
    }

    void processChildren(Collection nodes) {
        CDATANode cdata = this.getTextContent(nodes, true);
        if (cdata != null) {
            this.processTextInitializer(cdata.image, this.typeTable.objectType, cdata.inCDATA, cdata.beginLine);
        } else {
            Iterator iter = nodes.iterator();
            while (iter.hasNext()) {
                this.elementNodeHandler.invoke((Node)iter.next());
            }
        }
    }

    public void processTextInitializer(String text, Type arrayElementType, boolean cdata, int line) {
        int flags = cdata ? 1 : 0;
        Object result = this.textParser.parseValue(text, this.typeTable.arrayType, arrayElementType, flags, line, this.typeTable.arrayType.getName());
        if (result != null) {
            if (result instanceof BindingExpression) {
                if (this.allowBinding) {
                    BindingExpression bindingExpression = (BindingExpression)result;
                    if (this.parent != null) {
                        bindingExpression.setDestination(this.parent);
                    } else {
                        bindingExpression.setDestination(this.array);
                    }
                    bindingExpression.setDestinationLValue(this.name);
                    bindingExpression.setDestinationProperty(this.name);
                } else {
                    this.log(line, (CompilerMessage)new Builder.BindingNotAllowed());
                }
            } else {
                if (!$assertionsDisabled && !(result instanceof Array)) {
                    throw new AssertionError();
                }
                this.array.setEntries(((Array)result).getEntries());
            }
        }
    }

    static {
        $assertionsDisabled = !ArrayBuilder.class.desiredAssertionStatus();
    }

    public static class UnknownNode
    extends CompilerMessage.CompilerError {
        public String image;

        public UnknownNode(String image) {
            this.image = image;
        }
    }

    public static class ElementNotSupported
    extends CompilerMessage.CompilerError {
        public String image;

        public ElementNotSupported(String image) {
            this.image = image;
        }
    }

    protected class ElementBindingHandler
    implements BindingHandler {
        protected ElementBindingHandler() {
        }

        public BindingExpression invoke(BindingExpression bindingExpression, Model dest) {
            bindingExpression.setDestination(ArrayBuilder.this.array);
            bindingExpression.setDestinationLValue(Integer.toString(ArrayBuilder.this.array.size()));
            bindingExpression.setDestinationProperty(ArrayBuilder.this.array.size());
            return bindingExpression;
        }
    }

    protected class ElementNodeHandler
    extends ValueNodeHandler {
        protected ElementNodeHandler() {
        }

        protected void componentNode(Node node) {
            ComponentBuilder builder = new ComponentBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.configuration, ArrayBuilder.this.document, ArrayBuilder.this.array, false, ArrayBuilder.this.elementBindingHandler);
            node.analyze(builder);
            builder.component.setParentIndex(ArrayBuilder.this.array.size());
            ArrayBuilder.this.array.addEntry(builder.component);
        }

        protected void arrayNode(ArrayNode node) {
            ArrayBuilder builder = new ArrayBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.configuration, ArrayBuilder.this.document, ArrayBuilder.this.array, null, ArrayBuilder.this.allowBinding, ArrayBuilder.this.typeTable.objectType);
            node.analyze(builder);
            builder.array.setParentIndex(ArrayBuilder.this.array.size());
            ArrayBuilder.this.array.addEntry(builder.array);
        }

        protected void primitiveNode(PrimitiveNode node) {
            PrimitiveBuilder builder = new PrimitiveBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.configuration, ArrayBuilder.this.document, false, ArrayBuilder.this.elementBindingHandler);
            node.analyze(builder);
            ArrayBuilder.this.array.addEntry(builder.value);
        }

        protected void xmlNode(XMLNode node) {
            ArrayBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void xmlListNode(XMLListNode node) {
            ArrayBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void modelNode(ModelNode node) {
            ArrayBuilder.this.log(node, (CompilerMessage)new ElementNotSupported(node.image));
        }

        protected void inlineComponentNode(InlineComponentNode node) {
            InlineComponentBuilder builder = new InlineComponentBuilder(ArrayBuilder.this.unit, ArrayBuilder.this.typeTable, ArrayBuilder.this.configuration, ArrayBuilder.this.document, false);
            node.analyze(builder);
            ArrayBuilder.this.array.addEntry(builder.getRValue());
        }

        protected void unknown(Node node) {
            ArrayBuilder.this.log(node, new UnknownNode(node.image));
        }
    }
}

