/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hssf.record;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.DefaultEscherRecordFactory;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.NullEscherSerializationListener;
import org.apache.poi.hssf.record.Record;
import org.apache.poi.hssf.record.RecordFormatException;
import org.apache.poi.hssf.record.RecordInputStream;
import org.apache.poi.util.LittleEndian;

public abstract class AbstractEscherHolderRecord
extends Record {
    private static final boolean DESERIALISE = System.getProperty("poi.deserialize.escher") != null;
    private List escherRecords;
    private byte[] rawData;

    public AbstractEscherHolderRecord() {
        this.escherRecords = new ArrayList();
    }

    public AbstractEscherHolderRecord(RecordInputStream in) {
        super(in);
    }

    protected void validateSid(short id) {
        if (id != this.getSid()) {
            throw new RecordFormatException("Not an escher record");
        }
    }

    protected void fillFields(RecordInputStream in) {
        this.escherRecords = new ArrayList();
        if (!DESERIALISE) {
            this.rawData = in.readRemainder();
        } else {
            byte[] data = in.readAllContinuedRemainder();
            this.convertToEscherRecords(0, data.length, data);
        }
    }

    private void convertToEscherRecords(int offset, int size, byte[] data) {
        int bytesRead;
        DefaultEscherRecordFactory recordFactory = new DefaultEscherRecordFactory();
        for (int pos = offset; pos < offset + size; pos += bytesRead) {
            EscherRecord r = recordFactory.createRecord(data, pos);
            bytesRead = r.fillFields(data, pos, recordFactory);
            this.escherRecords.add(r);
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        String nl = System.getProperty("line.separator");
        buffer.append('[' + this.getRecordName() + ']' + nl);
        if (this.escherRecords.size() == 0) {
            buffer.append("No Escher Records Decoded" + nl);
        }
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            buffer.append(r.toString());
        }
        buffer.append("[/" + this.getRecordName() + ']' + nl);
        return buffer.toString();
    }

    protected abstract String getRecordName();

    public int serialize(int offset, byte[] data) {
        LittleEndian.putShort(data, 0 + offset, this.getSid());
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            LittleEndian.putShort(data, 0 + offset, this.getSid());
            LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
            System.arraycopy(this.rawData, 0, data, 4 + offset, this.rawData.length);
            return this.rawData.length + 4;
        }
        LittleEndian.putShort(data, 0 + offset, this.getSid());
        LittleEndian.putShort(data, 2 + offset, (short)(this.getRecordSize() - 4));
        int pos = offset + 4;
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            pos += r.serialize(pos, data, new NullEscherSerializationListener());
        }
        return this.getRecordSize();
    }

    public int getRecordSize() {
        if (this.escherRecords.size() == 0 && this.rawData != null) {
            return this.rawData.length + 4;
        }
        int size = 4;
        Iterator iterator = this.escherRecords.iterator();
        while (iterator.hasNext()) {
            EscherRecord r = (EscherRecord)iterator.next();
            size += r.getRecordSize();
        }
        return size;
    }

    public abstract short getSid();

    public Object clone() {
        throw new IllegalStateException("Not implemented yet.");
    }

    public void addEscherRecord(int index, EscherRecord element) {
        this.escherRecords.add(index, element);
    }

    public boolean addEscherRecord(EscherRecord element) {
        return this.escherRecords.add(element);
    }

    public List getEscherRecords() {
        return this.escherRecords;
    }

    public void clearEscherRecords() {
        this.escherRecords.clear();
    }

    public EscherRecord getEscherRecord(int index) {
        return (EscherRecord)this.escherRecords.get(index);
    }

    public void join(AbstractEscherHolderRecord record) {
        int length = this.rawData.length + record.getRawData().length;
        byte[] data = new byte[length];
        System.arraycopy(this.rawData, 0, data, 0, this.rawData.length);
        System.arraycopy(record.getRawData(), 0, data, this.rawData.length, record.getRawData().length);
        this.rawData = data;
    }

    public void processContinueRecord(byte[] record) {
        int length = this.rawData.length + record.length;
        byte[] data = new byte[length];
        System.arraycopy(this.rawData, 0, data, 0, this.rawData.length);
        System.arraycopy(record, 0, data, this.rawData.length, record.length);
        this.rawData = data;
    }

    public byte[] getRawData() {
        return this.rawData;
    }

    public void setRawData(byte[] rawData) {
        this.rawData = rawData;
    }

    public void decode() {
        this.convertToEscherRecords(0, this.rawData.length, this.rawData);
    }
}

