/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRPropertiesHolder;

public class JRPropertiesMap
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 10200L;
    private Map propertiesMap = new HashMap();
    private List propertiesList = new ArrayList();

    public JRPropertiesMap() {
    }

    public JRPropertiesMap(JRPropertiesMap propertiesMap) {
        this();
        String[] propertyNames = propertiesMap.getPropertyNames();
        if (propertyNames != null && propertyNames.length > 0) {
            for (int i = 0; i < propertyNames.length; ++i) {
                this.setProperty(propertyNames[i], propertiesMap.getProperty(propertyNames[i]));
            }
        }
    }

    public String[] getPropertyNames() {
        return this.propertiesList.toArray(new String[this.propertiesList.size()]);
    }

    public String getProperty(String propName) {
        return (String)this.propertiesMap.get(propName);
    }

    public boolean containsProperty(String propName) {
        return this.propertiesMap.containsKey(propName);
    }

    public void setProperty(String propName, String value) {
        if (!this.propertiesMap.containsKey(propName)) {
            this.propertiesList.add(propName);
        }
        this.propertiesMap.put(propName, value);
    }

    public void removeProperty(String propName) {
        if (this.propertiesMap.containsKey(propName)) {
            this.propertiesList.remove(propName);
            this.propertiesMap.remove(propName);
        }
    }

    public JRPropertiesMap cloneProperties() {
        return new JRPropertiesMap(this);
    }

    public Object clone() {
        return this.cloneProperties();
    }

    public String toString() {
        return this.propertiesMap.toString();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.propertiesList == null) {
            this.propertiesList = new ArrayList(this.propertiesMap.keySet());
            this.propertiesMap = new HashMap(this.propertiesMap);
        }
    }

    public boolean hasProperties() {
        return !this.propertiesList.isEmpty();
    }

    public static JRPropertiesMap getPropertiesClone(JRPropertiesHolder propertiesHolder) {
        JRPropertiesMap clone = propertiesHolder.hasProperties() ? propertiesHolder.getPropertiesMap().cloneProperties() : null;
        return clone;
    }
}

