/*
 * Decompiled with CFR 0.152.
 */
package nickyb.sqleonardo.environment.ctrl.content;

import java.awt.Component;
import nickyb.sqleonardo.common.gui.AbstractDialogWizard;
import nickyb.sqleonardo.common.gui.AbstractMaskChooser;
import nickyb.sqleonardo.environment.Application;
import nickyb.sqleonardo.environment.ctrl.content.AbstractMaskPerform;
import nickyb.sqleonardo.environment.ctrl.content.ContentView;
import nickyb.sqleonardo.environment.ctrl.content.MaskExport;
import nickyb.sqleonardo.environment.ctrl.content.MaskImport;
import nickyb.sqleonardo.environment.mdi.DefaultMaskChooser;

public class DialogStream
extends AbstractDialogWizard {
    private String tname = null;
    private ContentView view;
    private AbstractMaskPerform mkp;
    private AbstractMaskChooser mkc;
    private TaskOwner task;

    private DialogStream(String title, ContentView view, String tname) {
        super((Component)Application.window, title);
        this.tname = tname;
        this.view = view;
    }

    public static void showExport(ContentView view, String tname) {
        new DialogStream("export", view, tname).show();
    }

    public static void showImport(ContentView view, String tname) {
        new DialogStream("import", view, tname).show();
    }

    protected boolean onNext() {
        if (this.getStep() == 0) {
            if (this.mkc.getSelectedFile() != null) {
                this.mkp.setType(this.mkc.getPerformType(), this.tname, this.mkc.getSelectedFile().toString());
                return true;
            }
        } else {
            this.task = new TaskOwner();
            new Thread(this.task).start();
        }
        return false;
    }

    protected void onOpen() {
        if (this.getTitle().equals("export")) {
            this.mkp = new MaskExport();
            this.mkc = new DefaultMaskChooser(1, 0, false);
            this.mkc.addChoosableFileFilter(new SQLFilter());
            this.mkc.addChoosableFileFilter(new WebFilter());
        } else if (this.getTitle().equals("import")) {
            this.mkp = new MaskImport();
            this.mkc = new DefaultMaskChooser(0, 0, false);
        }
        this.mkc.addChoosableFileFilter(new TXTFilter());
        this.addStep(this.mkc);
        this.addStep(this.mkp);
        this.getContentPane().validate();
    }

    private static class WebFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        WebFilter() {
            super("web pages", new String[]{".htm", ".html"});
        }

        public short getPerformType() {
            return 2;
        }
    }

    private static class TXTFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        TXTFilter() {
            super("text files", new String[]{".txt"});
        }

        public short getPerformType() {
            return 1;
        }
    }

    private static class SQLFilter
    extends AbstractMaskChooser.AbstractFileFilter {
        SQLFilter() {
            super("insert statements", new String[]{".sql"});
        }

        public short getPerformType() {
            return 0;
        }
    }

    private class TaskOwner
    implements Runnable {
        private TaskOwner() {
        }

        public void run() {
            DialogStream.this.setBarEnabled(false);
            DialogStream.this.mkp.setEnabled(false);
            DialogStream.this.mkp.init(DialogStream.this.view);
            while (DialogStream.this.task != null && !DialogStream.this.mkp.aborted() && !DialogStream.this.mkp.finished()) {
                DialogStream.this.mkp.next();
            }
            DialogStream.this.mkp.setEnabled(true);
            DialogStream.this.setBarEnabled(true);
        }
    }
}

