/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.chartthemes.spring;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Paint;
import java.awt.Stroke;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.Locale;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.chartthemes.spring.ChartThemesConstants;
import net.sf.jasperreports.chartthemes.spring.ChartThemesUtilities;
import net.sf.jasperreports.chartthemes.spring.GenericChartTheme;
import net.sf.jasperreports.chartthemes.spring.ScaledDialPointer;
import net.sf.jasperreports.chartthemes.spring.ScaledDialRange;
import net.sf.jasperreports.chartthemes.spring.ScaledDialScale;
import net.sf.jasperreports.chartthemes.spring.ScaledDialValueIndicator;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAnchor;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.labels.PieSectionLabelGenerator;
import org.jfree.chart.labels.StandardPieSectionLabelGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PiePlot;
import org.jfree.chart.plot.PiePlot3D;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.ThermometerPlot;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.plot.dial.DialBackground;
import org.jfree.chart.plot.dial.DialCap;
import org.jfree.chart.plot.dial.DialFrame;
import org.jfree.chart.plot.dial.DialLayer;
import org.jfree.chart.plot.dial.DialPlot;
import org.jfree.chart.plot.dial.DialScale;
import org.jfree.chart.plot.dial.DialTextAnnotation;
import org.jfree.chart.plot.dial.StandardDialFrame;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.chart.renderer.category.BarRenderer3D;
import org.jfree.chart.renderer.category.CategoryItemRenderer;
import org.jfree.chart.renderer.xy.CandlestickRenderer;
import org.jfree.chart.renderer.xy.XYBubbleRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.chart.title.TextTitle;
import org.jfree.data.Range;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.general.PieDataset;
import org.jfree.data.general.ValueDataset;
import org.jfree.data.xy.DefaultHighLowDataset;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.RectangleInsets;
import org.jfree.ui.TextAnchor;

public class AegeanChartTheme
extends GenericChartTheme {
    public static final Color THERMOMETER_COLOR = Color.BLACK;

    protected void configureChart(JFreeChart jfreeChart, JRChartPlot jrPlot) throws JRException {
        super.configureChart(jfreeChart, jrPlot);
        TextTitle title = jfreeChart.getTitle();
        if (title != null) {
            RectangleInsets padding = title.getPadding();
            double bottomPadding = Math.max(padding.getBottom(), 15.0);
            title.setPadding(padding.getTop(), padding.getLeft(), bottomPadding, padding.getRight());
        }
    }

    protected void configurePlot(Plot plot, JRChartPlot jrPlot) {
        super.configurePlot(plot, jrPlot);
        if (plot instanceof CategoryPlot) {
            CategoryPlot categoryPlot = (CategoryPlot)plot;
            CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
            CategoryDataset categoryDataset = categoryPlot.getDataset();
            for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
                categoryRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
            }
            categoryPlot.setRangeGridlinePaint(ChartThemesConstants.GRAY_PAINT_217);
            categoryPlot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f));
            categoryPlot.setDomainGridlinesVisible(false);
            categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.UP_45);
        } else if (plot instanceof XYPlot) {
            XYPlot xyPlot = (XYPlot)plot;
            XYDataset xyDataset = xyPlot.getDataset();
            XYItemRenderer xyItemRenderer = xyPlot.getRenderer();
            for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
                xyItemRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
            }
            xyPlot.setRangeGridlinePaint(ChartThemesConstants.GRAY_PAINT_217);
            xyPlot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f));
            xyPlot.setDomainGridlinesVisible(false);
            xyPlot.setRangeZeroBaselineVisible(true);
        }
    }

    protected JFreeChart createScatterChart() throws JRException {
        JFreeChart jfreeChart = super.createScatterChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        xyPlot.setDomainGridlinesVisible(false);
        XYLineAndShapeRenderer plotRenderer = (XYLineAndShapeRenderer)((XYPlot)jfreeChart.getPlot()).getRenderer();
        plotRenderer.setBaseShapesFilled(false);
        plotRenderer.setBaseStroke((Stroke)new BasicStroke(1.0f));
        return jfreeChart;
    }

    protected JFreeChart createPieChart() throws JRException {
        JFreeChart jfreeChart = super.createPieChart();
        PiePlot piePlot = (PiePlot)jfreeChart.getPlot();
        piePlot.setLabelBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        piePlot.setLabelShadowPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        piePlot.setLabelOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
        piePlot.setShadowXOffset(0.0);
        piePlot.setShadowYOffset(0.0);
        PieDataset pieDataset = piePlot.getDataset();
        for (int i = 0; i < pieDataset.getItemCount(); ++i) {
            piePlot.setSectionOutlinePaint(pieDataset.getKey(i), (Paint)Color.BLACK);
        }
        if (this.getLabelGenerator() == null && ((JRPiePlot)this.getPlot()).getLabelFormat() == null) {
            piePlot.setLabelGenerator(null);
        }
        if (((JRPiePlot)this.getPlot()).getLegendLabelFormat() == null) {
            piePlot.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}"));
        }
        piePlot.setCircular(true);
        return jfreeChart;
    }

    protected JFreeChart createPie3DChart() throws JRException {
        JFreeChart jfreeChart = super.createPie3DChart();
        PiePlot3D piePlot3D = (PiePlot3D)jfreeChart.getPlot();
        piePlot3D.setLabelBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        piePlot3D.setLabelShadowPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        piePlot3D.setLabelOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
        piePlot3D.setDarkerSides(true);
        piePlot3D.setDepthFactor(0.07);
        PieDataset pieDataset = piePlot3D.getDataset();
        for (int i = 0; i < pieDataset.getItemCount(); ++i) {
            piePlot3D.setSectionOutlinePaint(pieDataset.getKey(i), ChartThemesConstants.TRANSPARENT_PAINT);
        }
        if (this.getLabelGenerator() == null && ((JRPie3DPlot)this.getPlot()).getLabelFormat() == null) {
            piePlot3D.setLabelGenerator(null);
        }
        if (((JRPie3DPlot)this.getPlot()).getLegendLabelFormat() == null) {
            piePlot3D.setLegendLabelGenerator((PieSectionLabelGenerator)new StandardPieSectionLabelGenerator("{0}"));
        }
        piePlot3D.setCircular(true);
        return jfreeChart;
    }

    protected JFreeChart createBar3DChart() throws JRException {
        JFreeChart jfreeChart = super.createBar3DChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D.setItemMargin(0.0);
        barRenderer3D.setWallPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            barRenderer3D.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
        }
        return jfreeChart;
    }

    protected JFreeChart createStackedBar3DChart() throws JRException {
        JFreeChart jfreeChart = super.createStackedBar3DChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        BarRenderer3D barRenderer3D = (BarRenderer3D)categoryPlot.getRenderer();
        barRenderer3D.setWallPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        barRenderer3D.setItemMargin(0.0);
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            barRenderer3D.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
        }
        return jfreeChart;
    }

    protected JFreeChart createBubbleChart() throws JRException {
        JFreeChart jfreeChart = super.createBubbleChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        XYDataset xyDataset = xyPlot.getDataset();
        XYBubbleRenderer bubbleRenderer = (XYBubbleRenderer)xyPlot.getRenderer();
        for (int i = 0; i < xyDataset.getSeriesCount(); ++i) {
            bubbleRenderer.setSeriesOutlinePaint(i, ChartThemesConstants.TRANSPARENT_PAINT);
        }
        return jfreeChart;
    }

    protected JFreeChart createGanttChart() throws JRException {
        JFreeChart jfreeChart = super.createGanttChart();
        CategoryPlot categoryPlot = (CategoryPlot)jfreeChart.getPlot();
        categoryPlot.getDomainAxis().setCategoryLabelPositions(CategoryLabelPositions.STANDARD);
        categoryPlot.setDomainGridlinesVisible(true);
        categoryPlot.setDomainGridlinePosition(CategoryAnchor.END);
        categoryPlot.setDomainGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 0, 50.0f, new float[]{1.0f}, 0.0f));
        categoryPlot.setDomainGridlinePaint(ChartThemesConstants.GRAY_PAINT_217);
        categoryPlot.setRangeGridlinesVisible(true);
        categoryPlot.setRangeGridlineStroke((Stroke)new BasicStroke(0.5f, 0, 0, 50.0f, new float[]{1.0f}, 0.0f));
        categoryPlot.setRangeGridlinePaint(ChartThemesConstants.GRAY_PAINT_217);
        CategoryDataset categoryDataset = categoryPlot.getDataset();
        CategoryItemRenderer categoryRenderer = categoryPlot.getRenderer();
        categoryRenderer.setBaseItemLabelsVisible(true);
        BarRenderer barRenderer = (BarRenderer)categoryRenderer;
        List seriesPaints = (List)this.getDefaultValue(this.defaultChartPropertiesMap, "seriesColors");
        barRenderer.setSeriesPaint(0, (Paint)seriesPaints.get(3));
        barRenderer.setSeriesPaint(1, (Paint)seriesPaints.get(0));
        for (int i = 0; i < categoryDataset.getRowCount(); ++i) {
            barRenderer.setSeriesItemLabelFont(i, categoryPlot.getDomainAxis().getTickLabelFont());
            barRenderer.setSeriesItemLabelsVisible(i, true);
        }
        categoryPlot.setOutlinePaint((Paint)Color.DARK_GRAY);
        categoryPlot.setOutlineStroke((Stroke)new BasicStroke(1.5f));
        categoryPlot.setOutlineVisible(true);
        return jfreeChart;
    }

    protected JFreeChart createMeterChart() throws JRException {
        return this.createDialChart();
    }

    protected JFreeChart createThermometerChart() throws JRException {
        JRThermometerPlot jrPlot = (JRThermometerPlot)this.getPlot();
        ThermometerPlot chartPlot = new ThermometerPlot((ValueDataset)this.getDataset());
        JFreeChart jfreeChart = new JFreeChart((Plot)chartPlot);
        this.configureChart(jfreeChart, this.getPlot());
        jfreeChart.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        jfreeChart.setBorderVisible(false);
        Range range = this.convertRange(jrPlot.getDataRange());
        chartPlot.setLowerBound(range.getLowerBound());
        chartPlot.setUpperBound(range.getUpperBound());
        chartPlot.setGap(0);
        chartPlot.setUnits(0);
        List seriesPaints = (List)this.getDefaultValue(this.defaultChartPropertiesMap, "seriesColors");
        Color paint = jrPlot.getMercuryColor() != null ? jrPlot.getMercuryColor() : (Paint)seriesPaints.get(0);
        chartPlot.setMercuryPaint((Paint)paint);
        chartPlot.setThermometerPaint((Paint)THERMOMETER_COLOR);
        chartPlot.setThermometerStroke((Stroke)new BasicStroke(2.0f));
        chartPlot.setOutlineVisible(false);
        chartPlot.setValueFont(chartPlot.getValueFont().deriveFont(1));
        JRValueDisplay display = jrPlot.getValueDisplay();
        if (display != null) {
            if (display.getColor() != null) {
                chartPlot.setValuePaint((Paint)display.getColor());
            }
            if (display.getMask() != null) {
                chartPlot.setValueFormat((NumberFormat)new DecimalFormat(display.getMask()));
            }
            if (display.getFont() != null) {
                // empty if block
            }
        }
        int valueLocation = jrPlot.getValueLocationByte() == null ? 3 : (int)jrPlot.getValueLocationByte().byteValue();
        switch (valueLocation) {
            case 0: {
                chartPlot.setValueLocation(0);
                break;
            }
            case 1: {
                chartPlot.setValueLocation(2);
                break;
            }
            case 2: {
                chartPlot.setValueLocation(1);
                break;
            }
            default: {
                chartPlot.setValueLocation(3);
            }
        }
        range = this.convertRange(jrPlot.getLowRange());
        if (range != null) {
            chartPlot.setSubrangeInfo(2, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getMediumRange())) != null) {
            chartPlot.setSubrangeInfo(1, range.getLowerBound(), range.getUpperBound());
        }
        if ((range = this.convertRange(jrPlot.getHighRange())) != null) {
            chartPlot.setSubrangeInfo(0, range.getLowerBound(), range.getUpperBound());
        }
        return jfreeChart;
    }

    protected JFreeChart createDialChart() throws JRException {
        String label;
        String displayVisibility;
        JRMeterPlot jrPlot = (JRMeterPlot)this.getPlot();
        DialPlot dialPlot = new DialPlot();
        dialPlot.setDataset((ValueDataset)this.getDataset());
        StandardDialFrame dialFrame = new StandardDialFrame();
        dialFrame.setForegroundPaint((Paint)Color.BLACK);
        dialFrame.setBackgroundPaint((Paint)Color.BLACK);
        dialFrame.setStroke((Stroke)new BasicStroke(1.0f));
        dialPlot.setDialFrame((DialFrame)dialFrame);
        DialBackground db = new DialBackground(ChartThemesConstants.TRANSPARENT_PAINT);
        dialPlot.setBackground((DialLayer)db);
        JRValueDisplay display = jrPlot.getValueDisplay();
        JRBaseFont jrFont = display != null && display.getFont() != null ? display.getFont() : new JRBaseFont((JRStyleContainer)this.getChart(), this.getChart().getLegendFont());
        Range range = this.convertRange(jrPlot.getDataRange());
        double bound = Math.max(Math.abs(range.getUpperBound()), Math.abs(range.getLowerBound()));
        int dialUnitScale = ChartThemesUtilities.getScale(bound);
        double lowerBound = ChartThemesUtilities.getTruncatedValue(range.getLowerBound(), dialUnitScale);
        double upperBound = ChartThemesUtilities.getTruncatedValue(range.getUpperBound(), dialUnitScale);
        ScaledDialScale scale = new ScaledDialScale(lowerBound, upperBound, 210.0, -240.0, (upperBound - lowerBound) / 6.0, 1);
        scale.setTickRadius(0.9);
        scale.setTickLabelOffset(0.16);
        scale.setTickLabelFont(JRFontUtil.getAwtFont((JRFont)jrFont, (Locale)this.getLocale()).deriveFont(16.0f).deriveFont(1));
        scale.setMajorTickStroke(new BasicStroke(1.0f));
        scale.setMinorTickStroke(new BasicStroke(0.7f));
        scale.setMajorTickPaint(Color.BLACK);
        scale.setMinorTickPaint(Color.BLACK);
        scale.setTickLabelsVisible(true);
        scale.setFirstTickLabelVisible(true);
        if (lowerBound == (double)((int)lowerBound) && upperBound == (double)((int)upperBound) && scale.getMajorTickIncrement() == (double)((int)scale.getMajorTickIncrement()) || dialUnitScale > 1) {
            scale.setTickLabelFormatter(new DecimalFormat("#,##0"));
        } else if (dialUnitScale == 1) {
            scale.setTickLabelFormatter(new DecimalFormat("#,##0.0"));
        } else if (dialUnitScale <= 0) {
            scale.setTickLabelFormatter(new DecimalFormat("#,##0.00"));
        }
        dialPlot.addScale(0, (DialScale)scale);
        List intervals = jrPlot.getIntervals();
        if (intervals != null && intervals.size() > 0) {
            int size = Math.min(3, intervals.size());
            for (int i = 0; i < size; ++i) {
                JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                Range intervalRange = this.convertRange(interval.getDataRange());
                double intervalLowerBound = ChartThemesUtilities.getTruncatedValue(intervalRange.getLowerBound(), dialUnitScale);
                double intervalUpperBound = ChartThemesUtilities.getTruncatedValue(intervalRange.getUpperBound(), dialUnitScale);
                ScaledDialRange dialRange = new ScaledDialRange(intervalLowerBound, intervalUpperBound, interval.getBackgroundColor() == null ? (Color)ChartThemesConstants.AEGEAN_INTERVAL_COLORS.get(i) : interval.getBackgroundColor(), 15.0f);
                dialRange.setInnerRadius(0.5);
                dialRange.setOuterRadius(0.5);
                dialPlot.addLayer((DialLayer)dialRange);
            }
            if (intervals.size() > 3) {
                int colorStep = 255 / (intervals.size() - 3);
                for (int i = 3; i < intervals.size(); ++i) {
                    JRMeterInterval interval = (JRMeterInterval)intervals.get(i);
                    Range intervalRange = this.convertRange(interval.getDataRange());
                    double intervalLowerBound = ChartThemesUtilities.getTruncatedValue(intervalRange.getLowerBound(), dialUnitScale);
                    double intervalUpperBound = ChartThemesUtilities.getTruncatedValue(intervalRange.getUpperBound(), dialUnitScale);
                    ScaledDialRange dialRange = new ScaledDialRange(intervalLowerBound, intervalUpperBound, interval.getBackgroundColor() == null ? new Color(255 - colorStep * (i - 3), 0 + colorStep * (i - 3), 0) : interval.getBackgroundColor(), 15.0f);
                    dialRange.setInnerRadius(0.5);
                    dialRange.setOuterRadius(0.5);
                    dialPlot.addLayer((DialLayer)dialRange);
                }
            }
        }
        String string = displayVisibility = display != null && this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.value.display.visible") : "false";
        if (Boolean.valueOf(displayVisibility).booleanValue()) {
            String pattern;
            ScaledDialValueIndicator dvi = new ScaledDialValueIndicator(0, dialUnitScale);
            dvi.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
            dvi.setPaint(Color.WHITE);
            String string2 = pattern = display.getMask() != null ? display.getMask() : "#,##0.####";
            if (pattern != null) {
                dvi.setNumberFormat(new DecimalFormat(pattern));
            }
            dvi.setRadius(0.15);
            dvi.setValueAnchor(RectangleAnchor.CENTER);
            dvi.setTextAnchor(TextAnchor.CENTER);
            dialPlot.addLayer((DialLayer)dvi);
        }
        String string3 = label = this.getChart().hasProperties() ? this.getChart().getPropertiesMap().getProperty("net.sf.jasperreports.chart.dial.label") : null;
        if (label != null) {
            label = dialUnitScale < 0 ? new MessageFormat(label).format(new Object[]{String.valueOf(Math.pow(10.0, dialUnitScale))}) : (dialUnitScale < 3 ? new MessageFormat(label).format(new Object[]{"1"}) : new MessageFormat(label).format(new Object[]{String.valueOf((int)Math.pow(10.0, dialUnitScale - 2))}));
            String[] textLines = label.split("\\n");
            for (int i = 0; i < textLines.length; ++i) {
                DialTextAnnotation dialAnnotation = new DialTextAnnotation(textLines[i]);
                dialAnnotation.setPaint((Paint)Color.BLACK);
                dialAnnotation.setRadius(Math.sin(0.5235987755982988) + (double)i / 10.0);
                dialAnnotation.setAnchor(TextAnchor.CENTER);
                dialPlot.addLayer((DialLayer)dialAnnotation);
            }
        }
        ScaledDialPointer needle = new ScaledDialPointer(dialUnitScale, 0.047);
        needle.setVisible(true);
        needle.setRadius(0.7);
        dialPlot.addLayer((DialLayer)needle);
        DialCap cap = new DialCap();
        cap.setRadius(0.05);
        cap.setFillPaint((Paint)Color.BLACK);
        cap.setOutlinePaint(ChartThemesConstants.TRANSPARENT_PAINT);
        dialPlot.setCap((DialLayer)cap);
        JFreeChart jfreeChart = new JFreeChart((String)this.evaluateExpression(this.getChart().getTitleExpression()), null, (Plot)dialPlot, this.getChart().getShowLegend() == null ? false : this.getChart().getShowLegend());
        this.configureChart(jfreeChart, this.getPlot());
        jfreeChart.setBackgroundPaint(ChartThemesConstants.TRANSPARENT_PAINT);
        jfreeChart.setBorderVisible(false);
        return jfreeChart;
    }

    protected JFreeChart createCandlestickChart() throws JRException {
        JFreeChart jfreeChart = super.createCandlestickChart();
        XYPlot xyPlot = (XYPlot)jfreeChart.getPlot();
        CandlestickRenderer renderer = (CandlestickRenderer)xyPlot.getRenderer();
        DefaultHighLowDataset dataset = (DefaultHighLowDataset)xyPlot.getDataset();
        List seriesPaints = (List)this.getDefaultValue(this.defaultChartPropertiesMap, "seriesColors");
        for (int i = 0; i < dataset.getSeriesCount(); ++i) {
            renderer.setSeriesFillPaint(i, (Paint)seriesPaints.get(i));
            renderer.setSeriesPaint(i, (Paint)Color.DARK_GRAY);
        }
        return jfreeChart;
    }
}

