/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.ActionMap;
import org.jdesktop.layout.GroupLayout;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Utilities;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.ProxyLookup;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class GenericInspectorTopComponent
extends TopComponent
implements ExplorerManager.Provider {
    private static GenericInspectorTopComponent instance;
    public static final String ICON_PATH = "com/jaspersoft/ireport/designer/resources/inspector.png";
    private static final String PREFERRED_ID = "GenericInspectorTopComponent";
    private final InstanceContent ic;
    private final Lookup lookup;
    private BeanTreeView view;
    private final ExplorerManager manager = new ExplorerManager();
    private TopComponent currentVisualView = null;
    private boolean updatingSelection = false;
    private AbstractNode noReportNode = null;

    private GenericInspectorTopComponent() {
        this.initComponents();
        this.setName(I18n.getString("CTL_GenericInspectorTopComponent"));
        this.setToolTipText(I18n.getString("HINT_GenericInspectorTopComponent"));
        this.setIcon(Utilities.loadImage((String)ICON_PATH, (boolean)true));
        this.ic = new InstanceContent();
        this.lookup = new AbstractLookup((AbstractLookup.Content)this.ic);
        this.noReportNode = new AbstractNode(Children.LEAF);
        this.noReportNode.setDisplayName("No Chart Theme available");
        ActionMap map = this.getActionMap();
        this.associateLookup((Lookup)new ProxyLookup(new Lookup[]{this.lookup, ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)map)}));
        this.setLayout(new BorderLayout());
        this.view = new BeanTreeView();
        this.add((Component)this.view, "Center");
        this.manager.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                if ("selectedNodes".equals(evt.getPropertyName())) {
                    if (GenericInspectorTopComponent.this.isUpdatingSelection()) {
                        return;
                    }
                    if (GenericInspectorTopComponent.this.getCurrentVisualView() != null && GenericInspectorTopComponent.this.getCurrentVisualView() instanceof ExplorerManager.Provider) {
                        try {
                            ((ExplorerManager.Provider)GenericInspectorTopComponent.this.getCurrentVisualView()).getExplorerManager().setSelectedNodes(GenericInspectorTopComponent.this.getExplorerManager().getSelectedNodes());
                        }
                        catch (PropertyVetoException propertyVetoException) {
                            // empty catch block
                        }
                    }
                }
            }
        });
        this.getExplorerManager().setRootContext((Node)this.noReportNode);
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public TopComponent getCurrentVisualView() {
        return this.currentVisualView;
    }

    public void setCurrentVisualView(TopComponent view) {
        this.currentVisualView = view;
        if (this.currentVisualView == null) {
            this.getExplorerManager().setRootContext((Node)this.noReportNode);
        } else {
            this.setUpdatingSelection(true);
            try {
                if (this.currentVisualView instanceof ExplorerManager.Provider) {
                    this.getExplorerManager().setRootContext(((ExplorerManager.Provider)this.currentVisualView).getExplorerManager().getRootContext());
                    this.getExplorerManager().setSelectedNodes(((ExplorerManager.Provider)this.currentVisualView).getExplorerManager().getSelectedNodes());
                }
            }
            catch (PropertyVetoException propertyVetoException) {
                // empty catch block
            }
            this.setUpdatingSelection(false);
        }
    }

    public void closingVisualView(TopComponent view) {
        if (view == this.currentVisualView) {
            this.setCurrentVisualView(null);
        }
    }

    public synchronized boolean isUpdatingSelection() {
        return this.updatingSelection;
    }

    public synchronized void setUpdatingSelection(boolean updatingSelection) {
        this.updatingSelection = updatingSelection;
    }

    private void initComponents() {
        GroupLayout layout = new GroupLayout((Container)((Object)this));
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 295, Short.MAX_VALUE));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(0, 368, Short.MAX_VALUE));
    }

    public static synchronized GenericInspectorTopComponent getDefault() {
        if (instance == null) {
            instance = new GenericInspectorTopComponent();
        }
        return instance;
    }

    public static synchronized GenericInspectorTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(GenericInspectorTopComponent.class.getName()).warning("Cannot find GenericInspectorTopComponent component. It will not be located properly in the window system.");
            return GenericInspectorTopComponent.getDefault();
        }
        if (win instanceof GenericInspectorTopComponent) {
            return (GenericInspectorTopComponent)win;
        }
        Logger.getLogger(GenericInspectorTopComponent.class.getName()).warning("There seem to be multiple components with the 'GenericInspectorTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return GenericInspectorTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 0;
    }

    public void componentOpened() {
    }

    public void componentClosed() {
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return GenericInspectorTopComponent.getDefault();
        }
    }
}

