/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx;

import com.jaspersoft.ireport.designer.jrctx.JRCTXVisualView;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.save.JRPrintSaveContributor;
import org.openide.util.NbBundle;

public class JRCTXPreviewToolbar
extends JToolBar
implements JRViewerListener {
    private JRCTXVisualView view = null;
    private final JRViewerController viewerContext;
    protected float MIN_ZOOM = 0.5f;
    protected float MAX_ZOOM = 10.0f;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected int defaultZoomIndex = 2;
    private static String[] chartTypes = new String[]{"Area Chart", "Bar3D Chart", "Bar Chart", "Bubble Chart", "HighLow Chart", "Line Chart", "Meter Chart", "Pie3D Chart", "Pie Chart", "Scatter Chart", "Stacked Area Chart", "Stacked Bar3D Chart", "Stacked Bar Chart", "Time Series Chart", "XyArea Chart", "XyBar Chart", "XyBar Time Period Chart", "XyBar Time Series Chart", "XyLine Chart"};
    protected int defaultChartTypeIndex = 0;
    protected List saveContributors = new ArrayList();
    protected File lastFolder = null;
    protected JRSaveContributor lastSaveContributor = null;
    protected DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    private JToggleButton btnActualSize;
    private JToggleButton btnFitPage;
    private JToggleButton btnFitWidth;
    private JButton btnPrint;
    private JButton btnSave;
    private JButton btnZoomIn;
    private JButton btnZoomOut;
    private JComboBox cmbChartType;
    private JComboBox cmbZoom;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;

    public JRCTXPreviewToolbar(JRCTXVisualView view, JRViewerController viewerContext) {
        this.viewerContext = viewerContext;
        this.viewerContext.addListener((JRViewerListener)this);
        this.initComponents();
        this.initSaveContributors();
        this.view = view;
    }

    private void initComponents() {
        this.jSeparator1 = new JToolBar.Separator();
        this.cmbChartType = new JComboBox();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnSave = new JButton();
        this.btnPrint = new JButton();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        this.setBorder(null);
        this.setRollover(true);
        this.add(this.jSeparator1);
        this.cmbChartType.setModel(this.getChartTypeComboBoxModel());
        this.cmbChartType.setMaximumSize(new Dimension(150, Short.MAX_VALUE));
        this.cmbChartType.setMinimumSize(new Dimension(150, 20));
        this.cmbChartType.setPreferredSize(new Dimension(150, 22));
        this.cmbChartType.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JRCTXPreviewToolbar.this.cmbChartTypeItemStateChanged(evt);
            }
        });
        this.cmbChartType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.cmbChartTypeActionPerformed(evt);
            }
        });
        this.add(this.cmbChartType);
        this.add(this.jSeparator2);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/save.GIF")));
        this.btnSave.setText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnSave.text"));
        this.btnSave.setToolTipText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnSave.toolTipText"));
        this.btnSave.setFocusable(false);
        this.btnSave.setHorizontalTextPosition(0);
        this.btnSave.setMaximumSize(new Dimension(23, 23));
        this.btnSave.setMinimumSize(new Dimension(23, 23));
        this.btnSave.setPreferredSize(new Dimension(23, 23));
        this.btnSave.setVerticalTextPosition(3);
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.btnSaveActionPerformed(evt);
            }
        });
        this.add(this.btnSave);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/print.GIF")));
        this.btnPrint.setText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnPrint.text"));
        this.btnPrint.setToolTipText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnPrint.toolTipText"));
        this.btnPrint.setFocusable(false);
        this.btnPrint.setHorizontalTextPosition(0);
        this.btnPrint.setMaximumSize(new Dimension(23, 23));
        this.btnPrint.setMinimumSize(new Dimension(23, 23));
        this.btnPrint.setPreferredSize(new Dimension(23, 23));
        this.btnPrint.setVerticalTextPosition(3);
        this.btnPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.btnPrintActionPerformed(evt);
            }
        });
        this.add(this.btnPrint);
        this.add(this.jSeparator3);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/actualsize.GIF")));
        this.btnActualSize.setText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnActualSize.text"));
        this.btnActualSize.setFocusable(false);
        this.btnActualSize.setHorizontalTextPosition(0);
        this.btnActualSize.setMaximumSize(new Dimension(23, 23));
        this.btnActualSize.setMinimumSize(new Dimension(23, 23));
        this.btnActualSize.setPreferredSize(new Dimension(23, 23));
        this.btnActualSize.setVerticalTextPosition(3);
        this.btnActualSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.btnActualSizeActionPerformed(evt);
            }
        });
        this.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/fitpage.GIF")));
        this.btnFitPage.setText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnFitPage.text"));
        this.btnFitPage.setFocusable(false);
        this.btnFitPage.setHorizontalTextPosition(0);
        this.btnFitPage.setMaximumSize(new Dimension(23, 23));
        this.btnFitPage.setMinimumSize(new Dimension(23, 23));
        this.btnFitPage.setPreferredSize(new Dimension(23, 23));
        this.btnFitPage.setVerticalTextPosition(3);
        this.btnFitPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.btnFitPageActionPerformed(evt);
            }
        });
        this.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/fitwidth.GIF")));
        this.btnFitWidth.setText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnFitWidth.text"));
        this.btnFitWidth.setFocusable(false);
        this.btnFitWidth.setHorizontalTextPosition(0);
        this.btnFitWidth.setMaximumSize(new Dimension(23, 23));
        this.btnFitWidth.setMinimumSize(new Dimension(23, 23));
        this.btnFitWidth.setPreferredSize(new Dimension(23, 23));
        this.btnFitWidth.setVerticalTextPosition(3);
        this.btnFitWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.btnFitWidthActionPerformed(evt);
            }
        });
        this.add(this.btnFitWidth);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/zoomin-16.png")));
        this.btnZoomIn.setText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnZoomIn.text"));
        this.btnZoomIn.setToolTipText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnZoomIn.toolTipText"));
        this.btnZoomIn.setFocusable(false);
        this.btnZoomIn.setHorizontalTextPosition(0);
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.setVerticalTextPosition(3);
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.btnZoomInActionPerformed(evt);
            }
        });
        this.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/zoomout-16.png")));
        this.btnZoomOut.setText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnZoomOut.text"));
        this.btnZoomOut.setToolTipText(NbBundle.getMessage(JRCTXPreviewToolbar.class, (String)"JrxmlPreviewToolbar.btnZoomOut.toolTipText"));
        this.btnZoomOut.setFocusable(false);
        this.btnZoomOut.setHorizontalTextPosition(0);
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.setVerticalTextPosition(3);
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setModel(this.getZoomComboBoxModel());
        this.cmbZoom.setMaximumSize(new Dimension(70, Short.MAX_VALUE));
        this.cmbZoom.setMinimumSize(new Dimension(70, 20));
        this.cmbZoom.setPreferredSize(new Dimension(70, 22));
        this.cmbZoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JRCTXPreviewToolbar.this.cmbZoomItemStateChanged(evt);
            }
        });
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRCTXPreviewToolbar.this.cmbZoomActionPerformed(evt);
            }
        });
        this.add(this.cmbZoom);
    }

    private DefaultComboBoxModel getChartTypeComboBoxModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < chartTypes.length; ++i) {
            model.addElement(chartTypes[i]);
        }
        return model;
    }

    private DefaultComboBoxModel getZoomComboBoxModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.zooms.length; ++i) {
            model.addElement("" + this.zooms[i] + "%");
        }
        return model;
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index < 0) {
            this.getViewerContext().setZoomRatio((float)this.zooms[-index - 1] / 100.0f);
        } else if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.getViewerContext().setZoomRatio((float)this.zooms[index + 1] / 100.0f);
        }
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index > 0) {
            this.getViewerContext().setZoomRatio((float)this.zooms[index - 1] / 100.0f);
        } else if (index < -1) {
            this.getViewerContext().setZoomRatio((float)this.zooms[-index - 2] / 100.0f);
        }
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        int retValue;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setLocale(this.getLocale());
        fileChooser.updateUI();
        for (int i = 0; i < this.saveContributors.size(); ++i) {
            fileChooser.addChoosableFileFilter((FileFilter)((JRSaveContributor)this.saveContributors.get(i)));
        }
        if (this.saveContributors.contains(this.lastSaveContributor)) {
            fileChooser.setFileFilter((FileFilter)this.lastSaveContributor);
        } else if (this.saveContributors.size() > 0) {
            fileChooser.setFileFilter((FileFilter)((JRSaveContributor)this.saveContributors.get(0)));
        }
        if (this.lastFolder != null) {
            fileChooser.setCurrentDirectory(this.lastFolder);
        }
        if ((retValue = fileChooser.showSaveDialog(this)) == 0) {
            FileFilter fileFilter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            this.lastFolder = file.getParentFile();
            JRSaveContributor contributor = null;
            if (fileFilter instanceof JRSaveContributor) {
                contributor = (JRSaveContributor)fileFilter;
            } else {
                int i = 0;
                while (contributor == null && i < this.saveContributors.size()) {
                    if ((contributor = (JRSaveContributor)this.saveContributors.get(i++)).accept(file)) continue;
                    contributor = null;
                }
                if (contributor == null) {
                    contributor = new JRPrintSaveContributor(this.getLocale(), this.getViewerContext().getResourceBundle());
                }
            }
            this.lastSaveContributor = contributor;
            try {
                contributor.save(this.getViewerContext().getJasperPrint(), file);
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, this.getViewerContext().getBundleString(I18n.getString("JrxmlPreviewToolbar.Message.Warning")));
            }
        }
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JasperPrintManager.printReport((JasperPrint)JRCTXPreviewToolbar.this.getViewerContext().getJasperPrint(), (boolean)true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)JRCTXPreviewToolbar.this.getView()), JRCTXPreviewToolbar.this.getViewerContext().getBundleString(I18n.getString("JrxmlPreviewToolbar.Message.Warning2")));
                }
            }
        });
        thread.start();
    }

    private void btnActualSizeActionPerformed(ActionEvent evt) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.getViewerContext().setZoomRatio(1.0f);
            this.btnActualSize.setSelected(true);
        }
    }

    private void btnFitPageActionPerformed(ActionEvent evt) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.getViewerContext().fitPage();
            this.btnFitPage.setSelected(true);
        }
    }

    private void btnFitWidthActionPerformed(ActionEvent evt) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.getViewerContext().fitWidth();
            this.btnFitWidth.setSelected(true);
        }
    }

    private void cmbZoomActionPerformed(ActionEvent evt) {
        float newZoom = this.getZoomRatio();
        if (newZoom < this.MIN_ZOOM) {
            newZoom = this.MIN_ZOOM;
        }
        if (newZoom > this.MAX_ZOOM) {
            newZoom = this.MAX_ZOOM;
        }
        this.getViewerContext().setZoomRatio(newZoom);
    }

    private void cmbZoomItemStateChanged(ItemEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    private void cmbChartTypeItemStateChanged(ItemEvent evt) {
    }

    private void cmbChartTypeActionPerformed(ActionEvent evt) {
        this.getView().setReportIndex(this.cmbChartType.getSelectedIndex());
        this.getView().modelChanged();
    }

    public void init() {
        this.cmbChartType.setSelectedIndex(this.defaultChartTypeIndex);
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
    }

    public void addComponentKeyListener(KeyListener listener) {
        this.btnSave.addKeyListener(listener);
        this.btnPrint.addKeyListener(listener);
        this.btnActualSize.addKeyListener(listener);
        this.btnFitPage.addKeyListener(listener);
        this.btnFitWidth.addKeyListener(listener);
        this.btnZoomIn.addKeyListener(listener);
        this.btnZoomOut.addKeyListener(listener);
        this.cmbZoom.addKeyListener(listener);
    }

    public void addSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.add(contributor);
    }

    public void removeSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.remove(contributor);
    }

    public JRSaveContributor[] getSaveContributors() {
        return this.saveContributors.toArray(new JRSaveContributor[this.saveContributors.size()]);
    }

    public void setSaveContributors(JRSaveContributor[] saveContributors) {
        this.saveContributors = new ArrayList();
        if (saveContributors != null) {
            this.saveContributors.addAll(Arrays.asList(saveContributors));
        }
    }

    protected void initSaveContributors() {
        String[] DEFAULT_CONTRIBUTORS = new String[]{"net.sf.jasperreports.view.save.JRPrintSaveContributor", "net.sf.jasperreports.view.save.JRPdfSaveContributor", "net.sf.jasperreports.view.save.JRRtfSaveContributor", "net.sf.jasperreports.view.save.JROdtSaveContributor", "net.sf.jasperreports.view.save.JRHtmlSaveContributor", "net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor", "net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor", "net.sf.jasperreports.view.save.JRCsvSaveContributor", "net.sf.jasperreports.view.save.JRXmlSaveContributor", "net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor"};
        for (int i = 0; i < DEFAULT_CONTRIBUTORS.length; ++i) {
            try {
                Class saveContribClass = JRClassLoader.loadClassForName((String)DEFAULT_CONTRIBUTORS[i]);
                Constructor constructor = saveContribClass.getConstructor(Locale.class, ResourceBundle.class);
                JRSaveContributor saveContrib = (JRSaveContributor)constructor.newInstance(this.getLocale(), this.getViewerContext().getResourceBundle());
                this.saveContributors.add(saveContrib);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void reportLoaded() {
    }

    protected void refreshPage() {
        if (!this.viewerContext.hasPages()) {
            this.btnSave.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            return;
        }
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.getViewerContext().getZoom() < this.MAX_ZOOM);
        this.btnZoomOut.setEnabled(this.getViewerContext().getZoom() > this.MIN_ZOOM);
        this.cmbZoom.setEnabled(true);
    }

    protected float getZoomRatio() {
        float newZoom = this.getViewerContext().getZoom();
        try {
            newZoom = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return newZoom;
    }

    protected void zoomChanged() {
        this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(this.getViewerContext().getZoom() * 100.0f) + "%");
    }

    public boolean isFitPage() {
        return this.btnFitPage.isSelected();
    }

    public boolean isFitWidth() {
        return this.btnFitPage.isSelected();
    }

    public void setFitWidth() {
        this.btnFitWidth.setSelected(true);
    }

    protected void fitPage() {
        this.btnFitPage.setSelected(true);
    }

    protected void fitWidth() {
        this.btnFitWidth.setSelected(true);
    }

    public void viewerEvent(JRViewerEvent event) {
        switch (event.getCode()) {
            case 5: {
                this.fitPage();
                break;
            }
            case 6: {
                this.fitWidth();
                break;
            }
            case 2: {
                this.refreshPage();
                break;
            }
            case 4: {
                this.zoomChanged();
                break;
            }
            case 1: {
                this.reportLoaded();
            }
        }
    }

    public JRViewerController getViewerContext() {
        return this.viewerContext;
    }

    public JRCTXVisualView getView() {
        return this.view;
    }
}

