/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple;

import java.io.Serializable;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.AbstractTuplizer;
import org.hibernate.tuple.Dom4jComponentTuplizer;
import org.hibernate.tuple.Dom4jTuplizer;
import org.hibernate.tuple.DynamicMapComponentTuplizer;
import org.hibernate.tuple.DynamicMapTuplizer;
import org.hibernate.tuple.EntityMetamodel;
import org.hibernate.tuple.PojoComponentTuplizer;
import org.hibernate.tuple.PojoTuplizer;
import org.hibernate.tuple.Tuplizer;

public class TuplizerLookup
implements Serializable {
    private final Tuplizer pojoTuplizer;
    private final Tuplizer dynamicMapTuplizer;
    private final Tuplizer dom4jTuplizer;

    TuplizerLookup(Tuplizer pojoTuplizer, Tuplizer dynamicMapTuplizer, Tuplizer dom4jTuplizer) {
        this.pojoTuplizer = pojoTuplizer;
        this.dynamicMapTuplizer = dynamicMapTuplizer;
        this.dom4jTuplizer = dom4jTuplizer;
    }

    public static TuplizerLookup create(PersistentClass mappedEntity, EntityMetamodel em) {
        DynamicMapTuplizer dynamicMapTuplizer = new DynamicMapTuplizer(em, mappedEntity);
        AbstractTuplizer pojoTuplizer = mappedEntity.hasPojoRepresentation() ? new PojoTuplizer(em, mappedEntity) : dynamicMapTuplizer;
        Dom4jTuplizer dom4jTuplizer = mappedEntity.hasDom4jRepresentation() ? new Dom4jTuplizer(em, mappedEntity) : null;
        return new TuplizerLookup(pojoTuplizer, dynamicMapTuplizer, dom4jTuplizer);
    }

    public static TuplizerLookup create(Component component) {
        PersistentClass owner = component.getOwner();
        DynamicMapComponentTuplizer dmt = new DynamicMapComponentTuplizer(component);
        DynamicMapComponentTuplizer pt = owner.hasPojoRepresentation() && component.hasPojoRepresentation() ? new PojoComponentTuplizer(component) : dmt;
        Dom4jComponentTuplizer d4jt = owner.hasDom4jRepresentation() ? new Dom4jComponentTuplizer(component) : null;
        return new TuplizerLookup(pt, dmt, d4jt);
    }

    public EntityMode guessEntityMode(Object object) {
        if (this.pojoTuplizer != null && this.pojoTuplizer.isInstance(object)) {
            return EntityMode.POJO;
        }
        if (this.dom4jTuplizer != null && this.dom4jTuplizer.isInstance(object)) {
            return EntityMode.DOM4J;
        }
        if (this.dynamicMapTuplizer != null && this.dynamicMapTuplizer.isInstance(object)) {
            return EntityMode.MAP;
        }
        return null;
    }

    public Tuplizer getTuplizerOrNull(EntityMode entityMode) {
        Tuplizer rtn = null;
        if (EntityMode.POJO == entityMode) {
            rtn = this.pojoTuplizer;
        } else if (EntityMode.DOM4J == entityMode) {
            rtn = this.dom4jTuplizer;
        } else if (EntityMode.MAP == entityMode) {
            rtn = this.dynamicMapTuplizer;
        }
        return rtn;
    }

    public Tuplizer getTuplizer(EntityMode entityMode) {
        Tuplizer rtn = null;
        if (EntityMode.POJO == entityMode) {
            rtn = this.pojoTuplizer;
        } else if (EntityMode.DOM4J == entityMode) {
            rtn = this.dom4jTuplizer;
        } else if (EntityMode.MAP == entityMode) {
            rtn = this.dynamicMapTuplizer;
        }
        if (rtn == null) {
            throw new HibernateException("No tuplizer found for entity-mode [" + entityMode + "]");
        }
        return rtn;
    }
}

