/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.util.Comparator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.table.JTableHeader;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategoryTableModel;
import org.netbeans.modules.autoupdate.ui.UpdateTableModel;
import org.netbeans.modules.autoupdate.ui.Utilities;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstalledTableModel
extends UnitCategoryTableModel {
    static final String STATE_ENABLED = NbBundle.getMessage(UpdateTableModel.class, (String)"InstalledTableModel_State_Enabled");
    static final String STATE_DISABLED = NbBundle.getMessage(UpdateTableModel.class, (String)"InstalledTableModel_State_Disabled");
    private OperationContainer<OperationSupport> enableContainer = Containers.forEnable();
    private OperationContainer<OperationSupport> disableContainer = Containers.forDisable();
    private OperationContainer<OperationSupport> uninstallContainer = Containers.forUninstall();
    private final Logger err = Logger.getLogger("org.netbeans.modules.autoupdate.ui.InstalledTableModel");

    public InstalledTableModel(List<UpdateUnit> list) {
        this.setUnits(list);
    }

    @Override
    public final void setUnits(List<UpdateUnit> list) {
        this.setData(Utilities.makeInstalledCategories(list));
    }

    @Override
    public String getToolTipText(int n, int n2) {
        if (n2 == 3) {
            Unit.Installed installed = (Unit.Installed)this.getUnitAtRow(n);
            assert (installed != null) : "Unit must found at row " + n;
            String string = null;
            UpdateElement updateElement = installed.getRelevantElement();
            UpdateUnit updateUnit = installed.getRelevantElement().getUpdateUnit();
            string = updateUnit.isPending() ? (updateElement.getUpdateUnit().getInstalled() == null || !updateElement.getUpdateUnit().getInstalled().equals((Object)updateElement) ? "InstallTab_PendingForInstall_Tooltip" : "InstallTab_PendingForDeactivate_Tooltip") : (updateElement.isEnabled() ? "InstallTab_Active_Tooltip" : "InstallTab_InActive_Tooltip");
            return string != null ? this.getBundle(string, new Object[0]) : null;
        }
        if (n2 == 0) {
            Unit.Installed installed = (Unit.Installed)this.getUnitAtRow(n);
            assert (installed != null) : "Unit must found at row " + n;
            String string = null;
            UpdateElement updateElement = installed.getRelevantElement();
            if (!installed.canBeMarked()) {
                string = "InstallTab_ReadOnly_Tooltip";
            }
            return string != null ? this.getBundle(string, updateElement.getDisplayName()) : super.getToolTipText(n, n2);
        }
        return super.getToolTipText(n, n2);
    }

    @Override
    public void setValueAt(Object object, int n, int n2) {
        super.setValueAt(object, n, n2);
        if (n2 == 1) {
            return;
        }
        assert (n2 == 0) : "First column.";
        if (object == null) {
            return;
        }
        Unit.Installed installed = (Unit.Installed)this.getUnitAtRow(n);
        assert (object instanceof Boolean) : object + " must be instanceof Boolean.";
        boolean bl = installed.isMarked();
        installed.setMarked(!bl);
        if (installed.isMarked() != bl) {
            this.fireButtonsChange();
        } else {
            String string = this.getBundle("NotificationAlreadyPreparedToIntsall", installed.getDisplayName());
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
        }
    }

    @Override
    public Object getValueAt(int n, int n2) {
        Object object = null;
        Unit.Installed installed = (Unit.Installed)this.getUnitAtRow(n);
        switch (n2) {
            case 0: {
                object = installed.isMarked() ? Boolean.TRUE : Boolean.FALSE;
                break;
            }
            case 1: {
                object = installed.getDisplayName();
                break;
            }
            case 2: {
                object = installed.getCategoryName();
                break;
            }
            case 3: {
                object = installed.getRelevantElement().isEnabled();
                break;
            }
            case 4: {
                object = installed.getInstalledVersion();
            }
        }
        return object;
    }

    @Override
    public int getColumnCount() {
        return 4;
    }

    @Override
    public Class getColumnClass(int n) {
        Class clazz = null;
        switch (n) {
            case 0: {
                clazz = Boolean.class;
                break;
            }
            case 1: {
                clazz = String.class;
                break;
            }
            case 2: {
                clazz = String.class;
                break;
            }
            case 3: {
                clazz = Boolean.class;
                break;
            }
            case 4: {
                clazz = String.class;
            }
        }
        return clazz;
    }

    @Override
    public String getColumnName(int n) {
        switch (n) {
            case 0: {
                return this.getBundle("InstalledTableModel_Columns_Uninstall", new Object[0]);
            }
            case 1: {
                return this.getBundle("InstalledTableModel_Columns_Name", new Object[0]);
            }
            case 2: {
                return this.getBundle("InstalledTableModel_Columns_Category", new Object[0]);
            }
            case 3: {
                return this.getBundle("InstalledTableModel_Columns_Enabled", new Object[0]);
            }
            case 4: {
                return this.getBundle("InstalledTableModel_Columns_Installed", new Object[0]);
            }
        }
        assert (false);
        return super.getColumnName(n);
    }

    @Override
    public int getMinWidth(JTableHeader jTableHeader, int n) {
        return super.getMinWidth(jTableHeader, n);
    }

    @Override
    public int getPreferredWidth(JTableHeader jTableHeader, int n) {
        switch (n) {
            case 1: {
                return super.getMinWidth(jTableHeader, n) * 4;
            }
            case 2: {
                return super.getMinWidth(jTableHeader, n) * 2;
            }
        }
        return super.getMinWidth(jTableHeader, n);
    }

    @Override
    public UnitCategoryTableModel.Type getType() {
        return UnitCategoryTableModel.Type.INSTALLED;
    }

    @Override
    public boolean isSortAllowed(Object object) {
        boolean bl = this.getColumnName(0).equals(object);
        return !bl;
    }

    @Override
    protected Comparator<Unit> getComparator(final Object object, final boolean bl) {
        return new Comparator<Unit>(){

            @Override
            public int compare(Unit unit, Unit unit2) {
                Unit unit3;
                Unit unit4 = bl ? unit : unit2;
                Unit unit5 = unit3 = bl ? unit2 : unit;
                if (InstalledTableModel.this.getColumnName(0).equals(object)) {
                    assert (false) : object.toString();
                } else {
                    if (InstalledTableModel.this.getColumnName(1).equals(object)) {
                        return Unit.compareDisplayNames(unit4, unit3);
                    }
                    if (InstalledTableModel.this.getColumnName(2).equals(object)) {
                        return Unit.compareCategories(unit4, unit3);
                    }
                    if (InstalledTableModel.this.getColumnName(3).equals(object)) {
                        return Unit.Installed.compareEnabledState(unit4, unit3);
                    }
                    if (InstalledTableModel.this.getColumnName(4).equals(object)) {
                        return Unit.Installed.compareInstalledVersions(unit4, unit3);
                    }
                }
                return 0;
            }
        };
    }

    @Override
    public int getDownloadSize() {
        return 0;
    }

    private String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(this.getClass(), (String)string, (Object[])objectArray);
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        Unit.Installed installed = (Unit.Installed)this.getUnitAtRow(n);
        return n2 == 0 ? installed != null && installed.canBeMarked() : super.isCellEditable(n, n2);
    }

    @Override
    public String getTabTitle() {
        return NbBundle.getMessage(PluginManagerUI.class, (String)"PluginManagerUI_UnitTab_Installed_Title");
    }

    @Override
    public int getTabIndex() {
        return 3;
    }

    @Override
    public boolean needsRestart() {
        return true;
    }
}

