/*
 * Decompiled with CFR 0.152.
 */
package org.openide.explorer.propertysheet;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.beans.FeatureDescriptor;
import java.beans.PropertyEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.openide.explorer.propertysheet.InplaceEditor;
import org.openide.explorer.propertysheet.PropUtils;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.explorer.propertysheet.PropertyModel;
import org.openide.util.Utilities;

class IconPanel
extends JComponent
implements InplaceEditor {
    private InplaceEditor inplaceEditor;
    private Icon icon;
    private boolean needLayout = true;
    private PropertyEnv env = null;
    private Component comp;

    public IconPanel() {
        this.setOpaque(true);
    }

    public void setInplaceEditor(InplaceEditor inplaceEditor) {
        this.inplaceEditor = inplaceEditor;
        this.setComponent(inplaceEditor.getComponent());
    }

    public InplaceEditor getInplaceEditor() {
        return this.inplaceEditor;
    }

    public void setEnabled(boolean bl) {
        if (this.comp != null) {
            this.comp.setEnabled(bl);
        }
        super.setEnabled(bl);
    }

    public void setBackground(Color color) {
        if (this.comp != null) {
            this.comp.setBackground(color);
        }
        super.setBackground(color);
    }

    public void setForeground(Color color) {
        if (this.comp != null) {
            this.comp.setForeground(color);
        }
        super.setForeground(color);
    }

    public void setFont(Font font) {
        if (this.comp != null) {
            this.comp.setFont(font);
        }
        super.setFont(font);
    }

    private void setComponent(Component component) {
        if (this.comp != null) {
            this.remove(this.comp);
        }
        if (component != null) {
            this.add(component);
        }
        this.comp = component;
        this.needLayout = true;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
        this.needLayout = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        if (this.needLayout) {
            this.doLayout();
        }
        if (this.icon != null) {
            Color color = graphics.getColor();
            try {
                graphics.setColor(this.getBackground());
                int n = this.comp != null ? this.comp.getLocation().x + this.icon.getIconWidth() : this.icon.getIconWidth() + 2;
                graphics.fillRect(0, 0, n, this.getHeight());
                Insets insets = this.getInsets();
                int n2 = insets.left;
                int n3 = insets.top + Math.max(this.getHeight() / 2 - this.icon.getIconHeight() / 2, 0);
                this.icon.paintIcon(this, graphics, n2, n3);
            }
            finally {
                graphics.setColor(color);
            }
        }
        super.paintComponent(graphics);
    }

    public void addActionListener(ActionListener actionListener) {
        this.inplaceEditor.addActionListener(actionListener);
    }

    public void clear() {
        this.inplaceEditor.clear();
        this.setIcon(null);
        this.setComponent(null);
        this.env = null;
    }

    public void connect(PropertyEditor propertyEditor, PropertyEnv propertyEnv) {
        this.inplaceEditor.connect(propertyEditor, propertyEnv);
        this.env = propertyEnv;
        this.updateIcon();
    }

    private void updateIcon() {
        if (this.env != null) {
            Icon icon = null;
            FeatureDescriptor featureDescriptor = this.env.getFeatureDescriptor();
            if (this.env.getState() == PropertyEnv.STATE_INVALID) {
                icon = new ImageIcon(Utilities.loadImage((String)"org/openide/resources/propertysheet/invalid.gif"));
            } else if (featureDescriptor != null) {
                icon = (Icon)featureDescriptor.getValue("valueIcon");
            }
            this.setIcon(icon);
            this.needLayout = true;
        }
    }

    public void setOpaque(boolean bl) {
        if (this.getInplaceEditor() != null) {
            this.getInplaceEditor().getComponent().setOpaque(true);
        }
    }

    public JComponent getComponent() {
        return this;
    }

    public KeyStroke[] getKeyStrokes() {
        return this.inplaceEditor.getKeyStrokes();
    }

    public PropertyEditor getPropertyEditor() {
        return this.inplaceEditor.getPropertyEditor();
    }

    public PropertyModel getPropertyModel() {
        return this.inplaceEditor.getPropertyModel();
    }

    public Object getValue() {
        return this.inplaceEditor.getValue();
    }

    public boolean isKnownComponent(Component component) {
        return component == this || this.inplaceEditor.isKnownComponent(component);
    }

    public void removeActionListener(ActionListener actionListener) {
        this.inplaceEditor.removeActionListener(actionListener);
    }

    public void reset() {
        this.inplaceEditor.reset();
        this.updateIcon();
    }

    public void setPropertyModel(PropertyModel propertyModel) {
        this.inplaceEditor.setPropertyModel(propertyModel);
    }

    public void setValue(Object object) {
        this.inplaceEditor.setValue(object);
    }

    public boolean supportsTextEntry() {
        return this.inplaceEditor.supportsTextEntry();
    }

    public void requestFocus() {
        this.comp.requestFocus();
    }

    public boolean requestFocusInWindow() {
        return this.comp.requestFocusInWindow();
    }

    public void addFocusListener(FocusListener focusListener) {
        if (this.comp != null) {
            this.comp.addFocusListener(focusListener);
        } else {
            super.addFocusListener(focusListener);
        }
    }

    public void removeFocusListener(FocusListener focusListener) {
        if (this.comp != null) {
            this.comp.removeFocusListener(focusListener);
        } else {
            super.removeFocusListener(focusListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void layout() {
        Insets insets = this.getInsets();
        int n = Math.max(this.icon.getIconWidth() + PropUtils.getTextMargin(), 18);
        int n2 = this.icon == null ? insets.left : insets.left + n;
        int n3 = insets.top;
        Object object = this.getTreeLock();
        synchronized (object) {
            Component component = this.comp;
            if (component == null) {
                return;
            }
            component.setBounds(n2, n3, this.getWidth() - (n2 + insets.right), this.getHeight() - insets.bottom);
            if (component instanceof Container) {
                ((Container)component).doLayout();
            }
        }
    }

    public Dimension getPreferredSize() {
        Insets insets = this.getInsets();
        Component component = this.comp;
        Dimension dimension = new Dimension(0, 0);
        if (this.icon != null) {
            dimension.width = this.icon.getIconWidth() + PropUtils.getTextMargin();
            dimension.height = this.icon.getIconHeight();
        }
        if (component != null) {
            Dimension dimension2 = component.getPreferredSize();
            dimension.width += dimension2.width;
            dimension.height = Math.max(dimension2.height, dimension.height);
        }
        dimension.width += insets.left + insets.right;
        dimension.height += insets.top + insets.bottom;
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }
}

