/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.BasicStroke;
import java.awt.Stroke;
import net.sf.jasperreports.engine.JRPen;

public class JRPenUtil {
    public static void setLinePenFromPen(byte pen, JRPen linePen) {
        JRPenUtil.setLinePenFromPen(new Byte(pen), linePen);
    }

    public static void setLinePenFromPen(Byte pen, JRPen linePen) {
        if (pen != null) {
            switch (pen) {
                case 5: {
                    linePen.setLineWidth(0.5f);
                    linePen.setLineStyle((byte)0);
                    break;
                }
                case 1: {
                    linePen.setLineWidth(1.0f);
                    linePen.setLineStyle((byte)0);
                    break;
                }
                case 2: {
                    linePen.setLineWidth(2.0f);
                    linePen.setLineStyle((byte)0);
                    break;
                }
                case 3: {
                    linePen.setLineWidth(4.0f);
                    linePen.setLineStyle((byte)0);
                    break;
                }
                case 4: {
                    linePen.setLineWidth(1.0f);
                    linePen.setLineStyle((byte)1);
                    break;
                }
                case 0: {
                    linePen.setLineWidth(0.0f);
                    linePen.setLineStyle((byte)0);
                }
            }
        }
    }

    public static byte getPenFromLinePen(JRPen linePen) {
        float lineWidth = linePen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return 0;
        }
        if (0.0f < lineWidth && lineWidth < 1.0f) {
            return 5;
        }
        if (1.0f <= lineWidth && lineWidth < 2.0f) {
            if (linePen.getLineStyle() == 1) {
                return 4;
            }
            return 1;
        }
        if (2.0f <= lineWidth && lineWidth < 4.0f) {
            return 2;
        }
        return 3;
    }

    public static Byte getOwnPenFromLinePen(JRPen linePen) {
        if (linePen.getOwnLineWidth() == null && linePen.getOwnLineStyle() == null) {
            return null;
        }
        return new Byte(JRPenUtil.getPenFromLinePen(linePen));
    }

    public static Stroke getStroke(JRPen pen, int lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            byte lineStyle = pen.getLineStyle();
            switch (lineStyle) {
                case 3: {
                    return new BasicStroke(lineWidth / 3.0f, lineCap, 0);
                }
                case 2: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{0.0f, 2.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{lineWidth, lineWidth}, 0.0f);
                        }
                    }
                }
                case 1: {
                    switch (lineCap) {
                        case 2: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{4.0f * lineWidth, 4.0f * lineWidth}, 0.0f);
                        }
                        case 0: {
                            return new BasicStroke(lineWidth, lineCap, 0, 10.0f, new float[]{5.0f * lineWidth, 3.0f * lineWidth}, 0.0f);
                        }
                    }
                }
            }
            return new BasicStroke(lineWidth, lineCap, 0);
        }
        return null;
    }
}

