/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.jdbc.core.simple;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BatchPreparedStatementSetter;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.SqlParameterValue;
import org.springframework.jdbc.core.StatementCreatorUtils;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcOperations;
import org.springframework.jdbc.core.namedparam.NamedParameterJdbcTemplate;
import org.springframework.jdbc.core.namedparam.NamedParameterUtils;
import org.springframework.jdbc.core.namedparam.ParsedSql;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcOperations;
import org.springframework.util.ObjectUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleJdbcTemplate
implements SimpleJdbcOperations {
    private final NamedParameterJdbcOperations namedParameterJdbcOperations;

    public SimpleJdbcTemplate(DataSource dataSource) {
        this.namedParameterJdbcOperations = new NamedParameterJdbcTemplate(dataSource);
    }

    public SimpleJdbcTemplate(JdbcOperations classicJdbcTemplate) {
        this.namedParameterJdbcOperations = new NamedParameterJdbcTemplate(classicJdbcTemplate);
    }

    public SimpleJdbcTemplate(NamedParameterJdbcOperations namedParameterJdbcTemplate) {
        this.namedParameterJdbcOperations = namedParameterJdbcTemplate;
    }

    @Override
    public JdbcOperations getJdbcOperations() {
        return this.namedParameterJdbcOperations.getJdbcOperations();
    }

    @Override
    public NamedParameterJdbcOperations getNamedParameterJdbcOperations() {
        return this.namedParameterJdbcOperations;
    }

    @Override
    public int queryForInt(String sql, Map args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForInt(sql, args);
    }

    @Override
    public int queryForInt(String sql, SqlParameterSource args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForInt(sql, args);
    }

    @Override
    public int queryForInt(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty(args) ? this.getJdbcOperations().queryForInt(sql) : this.getJdbcOperations().queryForInt(sql, this.getArguments(args));
    }

    @Override
    public long queryForLong(String sql, Map args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForLong(sql, args);
    }

    @Override
    public long queryForLong(String sql, SqlParameterSource args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForLong(sql, args);
    }

    @Override
    public long queryForLong(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty(args) ? this.getJdbcOperations().queryForLong(sql) : this.getJdbcOperations().queryForLong(sql, this.getArguments(args));
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Map args) throws DataAccessException {
        return (T)this.getNamedParameterJdbcOperations().queryForObject(sql, args, requiredType);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, SqlParameterSource args) throws DataAccessException {
        return (T)this.getNamedParameterJdbcOperations().queryForObject(sql, args, requiredType);
    }

    @Override
    public <T> T queryForObject(String sql, Class<T> requiredType, Object ... args) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty(args) ? this.getJdbcOperations().queryForObject(sql, requiredType) : this.getJdbcOperations().queryForObject(sql, this.getArguments(args), requiredType));
    }

    @Override
    public <T> T queryForObject(String sql, ParameterizedRowMapper<T> rm, Map args) throws DataAccessException {
        return (T)this.getNamedParameterJdbcOperations().queryForObject(sql, args, rm);
    }

    @Override
    public <T> T queryForObject(String sql, ParameterizedRowMapper<T> rm, SqlParameterSource args) throws DataAccessException {
        return (T)this.getNamedParameterJdbcOperations().queryForObject(sql, args, rm);
    }

    @Override
    public <T> T queryForObject(String sql, ParameterizedRowMapper<T> rm, Object ... args) throws DataAccessException {
        return (T)(ObjectUtils.isEmpty(args) ? this.getJdbcOperations().queryForObject(sql, rm) : this.getJdbcOperations().queryForObject(sql, this.getArguments(args), rm));
    }

    @Override
    public <T> List<T> query(String sql, ParameterizedRowMapper<T> rm, Map args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().query(sql, args, rm);
    }

    @Override
    public <T> List<T> query(String sql, ParameterizedRowMapper<T> rm, SqlParameterSource args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().query(sql, args, rm);
    }

    @Override
    public <T> List<T> query(String sql, ParameterizedRowMapper<T> rm, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty(args) ? this.getJdbcOperations().query(sql, rm) : this.getJdbcOperations().query(sql, this.getArguments(args), rm);
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Map args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForMap(sql, args);
    }

    @Override
    public Map<String, Object> queryForMap(String sql, SqlParameterSource args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForMap(sql, args);
    }

    @Override
    public Map<String, Object> queryForMap(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty(args) ? this.getJdbcOperations().queryForMap(sql) : this.getJdbcOperations().queryForMap(sql, this.getArguments(args));
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Map args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForList(sql, args);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, SqlParameterSource args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().queryForList(sql, args);
    }

    @Override
    public List<Map<String, Object>> queryForList(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty(args) ? this.getJdbcOperations().queryForList(sql) : this.getJdbcOperations().queryForList(sql, this.getArguments(args));
    }

    @Override
    public int update(String sql, Map args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().update(sql, args);
    }

    @Override
    public int update(String sql, SqlParameterSource args) throws DataAccessException {
        return this.getNamedParameterJdbcOperations().update(sql, args);
    }

    @Override
    public int update(String sql, Object ... args) throws DataAccessException {
        return ObjectUtils.isEmpty(args) ? this.getJdbcOperations().update(sql) : this.getJdbcOperations().update(sql, this.getArguments(args));
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs) {
        return this.doExecuteBatchUpdate(sql, batchArgs, new int[0]);
    }

    @Override
    public int[] batchUpdate(String sql, List<Object[]> batchArgs, int[] argTypes) {
        return this.doExecuteBatchUpdate(sql, batchArgs, argTypes);
    }

    @Override
    public int[] batchUpdate(String sql, Map[] batchValues) {
        SqlParameterSource[] batchArgs = new SqlParameterSource[batchValues.length];
        int i = 0;
        for (Map values : batchValues) {
            batchArgs[i] = new MapSqlParameterSource(values);
            ++i;
        }
        return this.doExecuteBatchUpdateWithNamedParameters(sql, batchArgs);
    }

    @Override
    public int[] batchUpdate(String sql, SqlParameterSource[] batchArgs) {
        return this.doExecuteBatchUpdateWithNamedParameters(sql, batchArgs);
    }

    private int[] doExecuteBatchUpdate(String sql, final List<Object[]> batchValues, final int[] columnTypes) {
        return this.getJdbcOperations().batchUpdate(sql, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = (Object[])batchValues.get(i);
                SimpleJdbcTemplate.this.doSetStatementParameters(values, ps, columnTypes);
            }

            public int getBatchSize() {
                return batchValues.size();
            }
        });
    }

    private int[] doExecuteBatchUpdateWithNamedParameters(String sql, final SqlParameterSource[] batchArgs) {
        if (batchArgs.length <= 0) {
            return new int[]{0};
        }
        final ParsedSql parsedSql = NamedParameterUtils.parseSqlStatement(sql);
        String sqlToUse = NamedParameterUtils.substituteNamedParameters(parsedSql, batchArgs[0]);
        return this.getJdbcOperations().batchUpdate(sqlToUse, new BatchPreparedStatementSetter(){

            public void setValues(PreparedStatement ps, int i) throws SQLException {
                Object[] values = NamedParameterUtils.buildValueArray(parsedSql, batchArgs[i], null);
                int[] columnTypes = NamedParameterUtils.buildSqlTypeArray(parsedSql, batchArgs[i]);
                SimpleJdbcTemplate.this.doSetStatementParameters(values, ps, columnTypes);
            }

            public int getBatchSize() {
                return batchArgs.length;
            }
        });
    }

    private void doSetStatementParameters(Object[] values, PreparedStatement ps, int[] columnTypes) throws SQLException {
        int colIndex = 0;
        for (Object value : values) {
            ++colIndex;
            if (value instanceof SqlParameterValue) {
                SqlParameterValue paramValue = (SqlParameterValue)value;
                StatementCreatorUtils.setParameterValue(ps, colIndex, paramValue, paramValue.getValue());
                continue;
            }
            int colType = columnTypes == null || columnTypes.length < colIndex ? Integer.MIN_VALUE : columnTypes[colIndex - 1];
            StatementCreatorUtils.setParameterValue(ps, colIndex, colType, value);
        }
    }

    private Object[] getArguments(Object[] varArgs) {
        if (varArgs.length == 1 && varArgs[0] instanceof Object[]) {
            return (Object[])varArgs[0];
        }
        return varArgs;
    }
}

