/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.export;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.export.ExporterFactory;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.util.prefs.Preferences;
import net.sf.jasperreports.engine.JRExporter;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.export.JExcelApiExporter;
import net.sf.jasperreports.engine.export.JExcelApiExporterParameter;
import net.sf.jasperreports.engine.export.JRCsvExporter;
import net.sf.jasperreports.engine.export.JRCsvExporterParameter;
import net.sf.jasperreports.engine.export.JRHtmlExporter;
import net.sf.jasperreports.engine.export.JRHtmlExporterParameter;
import net.sf.jasperreports.engine.export.JRPdfExporter;
import net.sf.jasperreports.engine.export.JRPdfExporterParameter;
import net.sf.jasperreports.engine.export.JRRtfExporter;
import net.sf.jasperreports.engine.export.JRTextExporter;
import net.sf.jasperreports.engine.export.JRTextExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsAbstractExporterParameter;
import net.sf.jasperreports.engine.export.JRXlsExporter;
import net.sf.jasperreports.engine.export.oasis.JROdtExporter;
import net.sf.jasperreports.engine.util.JRProperties;

public class DefaultExporterFactory
implements ExporterFactory {
    String format = "";

    public DefaultExporterFactory(String format) {
        this.format = format;
    }

    public String getExportFormat() {
        return this.format;
    }

    public String getExporterFileExtension() {
        return this.format;
    }

    public JRExporter createExporter() {
        JRPdfExporter exporter = null;
        if (this.format.equalsIgnoreCase("pdf")) {
            exporter = new JRPdfExporter();
            this.configurePdfExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("csv")) {
            exporter = new JRCsvExporter();
            this.configureCsvExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("html")) {
            exporter = new JRHtmlExporter();
            this.configureHtmlExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("xls")) {
            exporter = new JRXlsExporter();
            this.configureXlsExporter((JRExporter)exporter);
        } else if (this.format.equalsIgnoreCase("xls2")) {
            exporter = new JExcelApiExporter();
            this.configureXlsExporter((JRExporter)exporter);
        } else if (!this.format.equalsIgnoreCase("java2D")) {
            if (this.format.equalsIgnoreCase("txt")) {
                exporter = new JRTextExporter();
                this.configureTextExporter((JRExporter)exporter);
            } else if (this.format.equalsIgnoreCase("rtf")) {
                exporter = new JRRtfExporter();
            } else if (this.format.equalsIgnoreCase("odf")) {
                exporter = new JROdtExporter();
            }
        }
        return exporter;
    }

    public String getExportFormatDisplayName() {
        return I18n.getString("export.format.name." + this.format);
    }

    public String getViewer() {
        if (this.format.equalsIgnoreCase("pdf")) {
            return IReportManager.getInstance().getProperty("ExternalPDFViewer");
        }
        if (this.format.equalsIgnoreCase("csv")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalCSVViewer"), "");
        }
        if (this.format.equalsIgnoreCase("html")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalHTMLViewer"), "");
        }
        if (this.format.equalsIgnoreCase("xls")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalXLSViewer"), "");
        }
        if (this.format.equalsIgnoreCase("xls2")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalXLSViewer"), "");
        }
        if (this.format.equalsIgnoreCase("java2D")) {
            return null;
        }
        if (this.format.equalsIgnoreCase("txt")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalTXTViewer"), "");
        }
        if (this.format.equalsIgnoreCase("rtf")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalRTFViewer"), "");
        }
        if (this.format.equalsIgnoreCase("odf")) {
            return Misc.nvl(IReportManager.getInstance().getProperty("ExternalODFViewer"), "");
        }
        return null;
    }

    private void configureTextExporter(JRExporter exporter) {
        String s;
        Preferences pref = IReportManager.getPreferences();
        int val = pref.getInt("net.sf.jasperreports.export.txt.characterHeight", 0);
        if (val > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_HEIGHT, (Object)new Integer(val));
        }
        if ((val = pref.getInt("net.sf.jasperreports.export.txt.characterWidth", 0)) > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.CHARACTER_WIDTH, (Object)new Integer(val));
        }
        if ((val = pref.getInt("net.sf.jasperreports.export.txt.pageHeight", 0)) > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_HEIGHT, (Object)new Integer(val));
        }
        if ((val = pref.getInt("net.sf.jasperreports.export.txt.pageWidth", 0)) > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.PAGE_WIDTH, (Object)new Integer(val));
        }
        if ((s = pref.get("net.sf.jasperreports.export.txt.betweenPagesText", "")).length() > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.BETWEEN_PAGES_TEXT, (Object)s);
        }
        if ((s = pref.get("net.sf.jasperreports.export.txt.lineSeparator", "")).length() > 0) {
            exporter.setParameter((JRExporterParameter)JRTextExporterParameter.LINE_SEPARATOR, (Object)s);
        }
    }

    private void configureXlsExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        exporter.setParameter(JExcelApiExporterParameter.CREATE_CUSTOM_PALETTE, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.create.custom.palette", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.create.custom.palette"))));
        String password = pref.get("net.sf.jasperreports.export.xls.password", JRProperties.getProperty((String)"net.sf.jasperreports.export.xls.password"));
        if (password != null && password.length() > 0) {
            exporter.setParameter(JExcelApiExporterParameter.PASSWORD, (Object)password);
        }
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_COLLAPSE_ROW_SPAN, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.collapse.row.span", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.collapse.row.span"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_DETECT_CELL_TYPE, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.detect.cell.type", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.detect.cell.type"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_FONT_SIZE_FIX_ENABLED, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.font.size.fix.enabled", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.font.size.fix.enabled"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_CELL_BORDER, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.ignore.cell.border", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.ignore.cell.border"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IGNORE_GRAPHICS, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.ignore.graphics", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.ignore.graphics"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_IMAGE_BORDER_FIX_ENABLED, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.image.border.fix.enabled", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.image.border.fix.enabled"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_ONE_PAGE_PER_SHEET, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.one.page.per.sheet", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.one.page.per.sheet"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_COLUMNS, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.columns", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.remove.empty.space.between.columns"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.remove.empty.space.between.rows", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.remove.empty.space.between.rows"))));
        exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.white.page.background"))));
        int maxRowsPerSheet = pref.getInt("net.sf.jasperreports.export.xls.max.rows.per.sheet", JRProperties.getIntegerProperty((String)"net.sf.jasperreports.export.xls.max.rows.per.sheet"));
        if (maxRowsPerSheet > 0) {
            exporter.setParameter(JRXlsAbstractExporterParameter.MAXIMUM_ROWS_PER_SHEET, (Object)new Integer(maxRowsPerSheet));
        }
        if (pref.getBoolean("net.sf.jasperreports.export.xls.useSheetNames", false)) {
            String sheetNames = pref.get("net.sf.jasperreports.export.xls.sheetNames", "");
            exporter.setParameter((JRExporterParameter)JRXlsAbstractExporterParameter.SHEET_NAMES, (Object)sheetNames.split("\n"));
        }
    }

    private void configurePdfExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        String pdfVersion = pref.get("net.sf.jasperreports.export.pdf.version", null);
        if (pdfVersion != null && pdfVersion.length() == 1) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PDF_VERSION, (Object)new Character(pdfVersion.charAt(0)));
        }
        boolean b = pref.getBoolean("net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.create.batch.mode.bookmarks"));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS, (Object)new Boolean(b));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_COMPRESSED, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.compressed", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.compressed"))));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.FORCE_LINEBREAK_POLICY, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.force.linebreak.policy", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.force.linebreak.policy"))));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.FORCE_SVG_SHAPES, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.force.svg.shapes", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.force.svg.shapes"))));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_TAGGED, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.tagged", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.tagged"))));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_CREATING_BATCH_MODE_BOOKMARKS, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.compressed", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.compressed"))));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_ENCRYPTED, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.encrypted", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.encrypted"))));
        exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.IS_128_BIT_KEY, (Object)new Boolean(pref.getBoolean("net.sf.jasperreports.export.pdf.128.bit.key", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.pdf.128.bit.key"))));
        if (pref.get("export.pdf.METADATA_AUTHOR", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_AUTHOR, (Object)pref.get("export.pdf.METADATA_AUTHOR", ""));
        }
        if (pref.get("export.pdf.METADATA_CREATOR", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_CREATOR, (Object)pref.get("export.pdf.METADATA_CREATOR", ""));
        }
        if (pref.get("export.pdf.METADATA_KEYWORDS", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_KEYWORDS, (Object)pref.get("export.pdf.METADATA_KEYWORDS", ""));
        }
        if (pref.get("export.pdf.METADATA_SUBJECT", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_SUBJECT, (Object)pref.get("export.pdf.METADATA_SUBJECT", ""));
        }
        if (pref.get("export.pdf.METADATA_TITLE", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.METADATA_TITLE, (Object)pref.get("export.pdf.METADATA_TITLE", ""));
        }
        if (pref.get("export.pdf.OWNER_PASSWORD", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.OWNER_PASSWORD, (Object)pref.get("export.pdf.OWNER_PASSWORD", ""));
        }
        if (pref.get("export.pdf.USER_PASSWORD", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.USER_PASSWORD, (Object)pref.get("export.pdf.USER_PASSWORD", ""));
        }
        if (pref.get("export.pdf.TAG_LANGUAGE", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.tag.language")) != null) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.TAG_LANGUAGE, (Object)pref.get("export.pdf.TAG_LANGUAGE", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.tag.language")));
        }
        if (pref.get("export.pdf.PDF_JAVASCRIPT", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.javascript")) != null) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PDF_JAVASCRIPT, (Object)pref.get("export.pdf.PDF_JAVASCRIPT", JRProperties.getProperty((String)"net.sf.jasperreports.export.pdf.javascript")));
        }
        if (pref.getInt("export.pdf.PERMISSIONS", 0) != 0) {
            exporter.setParameter((JRExporterParameter)JRPdfExporterParameter.PERMISSIONS, (Object)pref.getInt("export.pdf.PERMISSIONS", 0));
        }
    }

    private void configureHtmlExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.FRAMES_AS_NESTED_TABLES, (Object)pref.getBoolean("net.sf.jasperreports.export.html.frames.as.nested.tables", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.frames.as.nested.tables")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_REMOVE_EMPTY_SPACE_BETWEEN_ROWS, (Object)pref.getBoolean("net.sf.jasperreports.export.html.remove.emtpy.space.between.rows", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.remove.emtpy.space.between.rows")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_OUTPUT_IMAGES_TO_DIR, (Object)pref.getBoolean("net.sf.jasperreports.export.html.saveImages", true));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_USING_IMAGES_TO_ALIGN, (Object)pref.getBoolean("net.sf.jasperreports.export.html.using.images.to.align", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.using.images.to.align")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WHITE_PAGE_BACKGROUND, (Object)pref.getBoolean("net.sf.jasperreports.export.xls.white.page.background", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.xls.white.page.background")));
        exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IS_WRAP_BREAK_WORD, (Object)pref.getBoolean("net.sf.jasperreports.export.html.wrap.break.word", JRProperties.getBooleanProperty((String)"net.sf.jasperreports.export.html.wrap.break.word")));
        if (pref.get("net.sf.jasperreports.export.html.imagesDirectory", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_DIR_NAME, (Object)pref.get("net.sf.jasperreports.export.html.imagesDirectory", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.imagesUri", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.IMAGES_URI, (Object)pref.get("net.sf.jasperreports.export.html.imagesUri", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlHeader", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_HEADER, (Object)pref.get("net.sf.jasperreports.export.html.htmlHeader", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.BETWEEN_PAGES_HTML, (Object)pref.get("net.sf.jasperreports.export.html.htmlBetweenPages", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.htmlFooter", "").length() > 0) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.HTML_FOOTER, (Object)pref.get("net.sf.jasperreports.export.html.htmlFooter", ""));
        }
        if (pref.get("net.sf.jasperreports.export.html.size.unit", JRProperties.getProperty((String)"net.sf.jasperreports.export.html.size.unit")).length() > 0) {
            exporter.setParameter((JRExporterParameter)JRHtmlExporterParameter.SIZE_UNIT, (Object)pref.get("net.sf.jasperreports.export.html.size.unit", JRProperties.getProperty((String)"net.sf.jasperreports.export.html.size.unit")));
        }
    }

    private void configureCsvExporter(JRExporter exporter) {
        Preferences pref = IReportManager.getPreferences();
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.FIELD_DELIMITER, (Object)pref.get("net.sf.jasperreports.export.csv.field.delimiter", JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.field.delimiter")));
        exporter.setParameter((JRExporterParameter)JRCsvExporterParameter.RECORD_DELIMITER, (Object)pref.get("net.sf.jasperreports.export.csv.record.delimiter", JRProperties.getProperty((String)"net.sf.jasperreports.export.csv.record.delimiter")));
    }
}

