/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.outline.nodes.VariableNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignVariable;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.Mutex;

public class VariablesChildren
extends Index.KeysChildren
implements PropertyChangeListener,
PreferenceChangeListener {
    JasperDesign jd = null;
    private JRDesignDataset dataset = null;
    private Lookup doLkp = null;

    public VariablesChildren(JasperDesign jd, Lookup doLkp) {
        this(jd, jd.getMainDesignDataset(), doLkp);
    }

    public VariablesChildren(JasperDesign jd, JRDesignDataset dataset, Lookup doLkp) {
        super(new ArrayList());
        this.jd = jd;
        this.doLkp = doLkp;
        if (dataset == null) {
            dataset = jd.getMainDesignDataset();
        }
        this.dataset = dataset;
        this.dataset.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        IReportManager.getPreferences().addPreferenceChangeListener(this);
    }

    protected Node[] createNodes(Object key) {
        return new Node[]{new VariableNode(this.jd, (JRDesignVariable)key, this.doLkp)};
    }

    protected void addNotify() {
        super.addNotify();
        this.recalculateKeys();
    }

    public void recalculateKeys() {
        List l = (List)this.lock();
        l.clear();
        if (IReportManager.getPreferences().getBoolean("filter_variables", false)) {
            List varsAll = this.dataset.getVariablesList();
            for (int i = 0; i < varsAll.size(); ++i) {
                JRVariable p = (JRVariable)varsAll.get(i);
                if (p.isSystemDefined()) continue;
                l.add(p);
            }
        } else {
            l.addAll(this.dataset.getVariablesList());
        }
        this.update();
    }

    public void reorder() {
        Mutex.Action action = new Mutex.Action(){

            public Object run() {
                Index.Support.showIndexedCustomizer((Index)VariablesChildren.this.getIndex());
                return null;
            }
        };
        MUTEX.writeAccess(action);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("variables")) {
            this.recalculateKeys();
        }
    }

    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().equals("filter_variables")) {
            this.recalculateKeys();
        }
    }
}

