/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.barcode;

import com.jaspersoft.ireport.components.barcode.BarcodeDescriptor;
import com.jaspersoft.ireport.components.barcode.BarcodeListRenderer;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

public class BarcodeChooserDialog
extends JDialog {
    private JRDesignComponentElement component = null;
    private JButton jButton1;
    private JButton jButton2;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JList jList1;
    private JList jList2;
    private JScrollPane jScrollPane1;
    private JScrollPane jScrollPane2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;

    public BarcodeChooserDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.jList1.setCellRenderer(new BarcodeListRenderer());
        this.jList2.setCellRenderer(new BarcodeListRenderer());
        DefaultListModel<BarcodeDescriptor> listModel = new DefaultListModel<BarcodeDescriptor>();
        List<BarcodeDescriptor> barbecueBarcodes = BarcodeDescriptor.getBarbecueBarcodes();
        for (BarcodeDescriptor b : barbecueBarcodes) {
            listModel.addElement(b);
        }
        this.jList1.setModel(listModel);
        DefaultListModel<BarcodeDescriptor> listModel2 = new DefaultListModel<BarcodeDescriptor>();
        List<BarcodeDescriptor> barcode4jBarcodes = BarcodeDescriptor.getBarcode4jBarcodes();
        for (BarcodeDescriptor b : barcode4jBarcodes) {
            listModel2.addElement(b);
        }
        this.jList2.setModel(listModel2);
        this.jList1.updateUI();
        this.jList2.updateUI();
        this.setLocationRelativeTo(null);
    }

    public static JRDesignComponentElement createBarcodeComponent(int libType, String barcodeName) {
        JRDesignComponentElement component = new JRDesignComponentElement();
        component.setWidth(200);
        component.setHeight(50);
        if (libType == 0) {
            StandardBarbecueComponent componentImpl = new StandardBarbecueComponent();
            componentImpl.setType(barcodeName);
            componentImpl.setEvaluationTime((byte)1);
            JRDesignExpression exp = Misc.createExpression((String)"java.lang.String", (String)"\"1234\"");
            componentImpl.setCodeExpression((JRExpression)exp);
            component.setComponent((net.sf.jasperreports.engine.component.Component)componentImpl);
            component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "barbecue"));
        } else {
            CodabarComponent componentImpl = null;
            if (barcodeName.equals("Codabar")) {
                componentImpl = new CodabarComponent();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "Codabar"));
            } else if (barcodeName.equals("Code128")) {
                componentImpl = new Code128Component();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "Codabar"));
            } else if (barcodeName.equals("DataMatrix")) {
                componentImpl = new DataMatrixComponent();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "DataMatrix"));
            } else if (barcodeName.equals("EAN128")) {
                componentImpl = new EAN128Component();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "EAN128"));
            } else if (barcodeName.equals("Royal Mail Customer")) {
                componentImpl = new RoyalMailCustomerComponent();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "RoyalMailCustomer"));
            } else if (barcodeName.equals("USPS Intelligent Mail")) {
                componentImpl = new USPSIntelligentMailComponent();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "USPSIntelligentMail"));
            } else if (barcodeName.equals("Int2of5")) {
                componentImpl = new Interleaved2Of5Component();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "Interleaved2Of5"));
            } else if (barcodeName.equals("Code39")) {
                componentImpl = new Code39Component();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "Code39"));
            } else if (barcodeName.equals("UPCA")) {
                componentImpl = new UPCAComponent();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "UPCA"));
            } else if (barcodeName.equals("UPCE")) {
                componentImpl = new UPCEComponent();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "UPCE"));
            } else if (barcodeName.equals("EAN13")) {
                componentImpl = new EAN13Component();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "EAN13"));
            } else if (barcodeName.equals("EAN8")) {
                componentImpl = new EAN8Component();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "EAN8"));
            } else if (barcodeName.equals("PostNet")) {
                componentImpl = new POSTNETComponent();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "POSTNET"));
            } else if (barcodeName.equals("PDF417")) {
                componentImpl = new PDF417Component();
                component.setComponentKey(new ComponentKey("http://jasperreports.sourceforge.net/jasperreports/components", "jr", "PDF417"));
            }
            componentImpl.setEvaluationTime((byte)1);
            componentImpl.setTextPosition("bottom");
            JRDesignExpression exp = new JRDesignExpression();
            exp.setValueClassName("java.lang.String");
            componentImpl.setCodeExpression((JRExpression)exp);
            component.setComponent((net.sf.jasperreports.engine.component.Component)componentImpl);
        }
        return component;
    }

    private void closeWindow(int lib) {
        this.setVisible(false);
        this.dispose();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.jLabel2 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jList1 = new JList();
        this.jLabel3 = new JLabel();
        this.jScrollPane2 = new JScrollPane();
        this.jList2 = new JList();
        this.jSeparator1 = new JSeparator();
        this.jSeparator2 = new JSeparator();
        this.setDefaultCloseOperation(2);
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/components/barcode/barcode-32.png")));
        this.jLabel1.setText(NbBundle.getMessage(BarcodeChooserDialog.class, (String)"BarcodeChooserDialog.jLabel1.text"));
        this.jLabel1.setVerticalAlignment(1);
        this.jLabel1.setVerticalTextPosition(1);
        this.jButton1.setText(NbBundle.getMessage(BarcodeChooserDialog.class, (String)"BarcodeChooserDialog.jButton1.text"));
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BarcodeChooserDialog.this.jButton1ActionPerformed(evt);
            }
        });
        this.jButton2.setText(NbBundle.getMessage(BarcodeChooserDialog.class, (String)"BarcodeChooserDialog.jButton2.text"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                BarcodeChooserDialog.this.jButton2ActionPerformed(evt);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(BarcodeChooserDialog.class, (String)"BarcodeChooserDialog.jLabel2.text"));
        this.jList1.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                BarcodeChooserDialog.this.jList1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jList1);
        this.jLabel3.setText(NbBundle.getMessage(BarcodeChooserDialog.class, (String)"BarcodeChooserDialog.jLabel3.text"));
        this.jList2.setModel(new AbstractListModel(){
            String[] strings = new String[]{"Item 1", "Item 2", "Item 3", "Item 4", "Item 5"};

            public int getSize() {
                return this.strings.length;
            }

            public Object getElementAt(int i) {
                return this.strings[i];
            }
        });
        this.jList2.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                BarcodeChooserDialog.this.jList2MouseClicked(evt);
            }
        });
        this.jScrollPane2.setViewportView(this.jList2);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jSeparator2, -1, 483, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel2, -1, 228, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jLabel3, -1, 229, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jScrollPane1, -1, 229, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jScrollPane2, -1, 228, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jButton1, -1, 228, Short.MAX_VALUE).addPreferredGap(0).add((Component)this.jButton2, -1, 229, Short.MAX_VALUE).addContainerGap()).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jSeparator1, -1, 473, Short.MAX_VALUE).addContainerGap()).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1, -1, 463, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jSeparator2, -2, 10, -2).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jScrollPane2, -1, 209, Short.MAX_VALUE).add((Component)this.jScrollPane1, -1, 209, Short.MAX_VALUE)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButton1, -1, -1, Short.MAX_VALUE).add((Component)this.jButton2)).addPreferredGap(0).add((Component)this.jSeparator1, -2, 10, -2)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        String barcodeType = "Code39 (Extended)";
        if (this.jList1.getSelectedIndex() >= 0) {
            barcodeType = ((BarcodeDescriptor)this.jList1.getSelectedValue()).getName();
        }
        this.setComponent(BarcodeChooserDialog.createBarcodeComponent(0, barcodeType));
        this.closeWindow(0);
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        String barcodeType = "Code128";
        if (this.jList2.getSelectedIndex() >= 0) {
            barcodeType = ((BarcodeDescriptor)this.jList2.getSelectedValue()).getName();
        }
        this.setComponent(BarcodeChooserDialog.createBarcodeComponent(1, barcodeType));
        this.closeWindow(1);
    }

    private void jList1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.jButton1ActionPerformed(null);
        }
    }

    private void jList2MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            this.jButton2ActionPerformed(null);
        }
    }

    public JRDesignComponentElement getComponent() {
        return this.component;
    }

    public void setComponent(JRDesignComponentElement component) {
        this.component = component;
    }
}

