/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.inc;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.lexer.LanguageOperation;
import org.netbeans.lib.lexer.LexerInputOperation;
import org.netbeans.lib.lexer.LexerUtilsConstants;
import org.netbeans.lib.lexer.inc.IncTokenList;
import org.netbeans.lib.lexer.inc.MutableTokenList;
import org.netbeans.lib.lexer.inc.TokenListChange;
import org.netbeans.lib.lexer.token.AbstractToken;
import org.netbeans.spi.lexer.TokenValidator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TokenListUpdater {
    private static final Logger LOG = Logger.getLogger(TokenListUpdater.class.getName());

    /*
     * Enabled aggressive block sorting
     */
    public static <T extends TokenId> void update(MutableTokenList<T> mutableTokenList, int n, int n2, int n3, TokenListChange<T> tokenListChange, Object tokenValidator) {
        int n4;
        int n5;
        boolean bl;
        TokenValidator tokenValidator2;
        int n6;
        int n7;
        int n8;
        int n9;
        int n10;
        int n11;
        AbstractToken<T> abstractToken;
        LanguageOperation<T> languageOperation = LexerUtilsConstants.innerLanguageOperation(mutableTokenList.languagePath());
        int n12 = mutableTokenList.tokenCountCurrent();
        boolean bl2 = LOG.isLoggable(Level.FINE);
        if (bl2) {
            LOG.log(Level.FINE, "TokenListUpdater.update() STARTED\nmodOffset=" + n + ", insertedLength=" + n2 + ", removedLength=" + n3 + ", tokenCount=" + n12 + "\n");
        }
        if (n12 == 0) {
            if (!mutableTokenList.isFullyLexed()) {
                if (bl2) {
                    LOG.log(Level.FINE, "TokenListUpdater.update() FINISHED: Not fully lexed yet.\n");
                }
                return;
            }
            abstractToken = null;
            n11 = n;
            n10 = 0;
        } else {
            n10 = n12 - 1;
            n11 = mutableTokenList.tokenOffset(n10);
            if (n >= n11) {
                abstractToken = TokenListUpdater.token(mutableTokenList, n10);
                n9 = n11 + abstractToken.length();
                if (n >= n9) {
                    if (!mutableTokenList.isFullyLexed() && n >= n9 + mutableTokenList.lookahead(n10)) {
                        if (bl2) {
                            LOG.log(Level.FINE, "TokenListUpdater.update() FINISHED: Not fully lexed yet. modTokenOffset=" + n11 + ", modToken.length()=" + abstractToken.length() + "\n");
                        }
                        return;
                    }
                    ++n10;
                    abstractToken = null;
                    n11 = n9;
                }
            } else {
                n9 = 0;
                while (n9 <= n10) {
                    n8 = (n9 + n10) / 2;
                    n7 = mutableTokenList.tokenOffset(n8);
                    if (n7 < n) {
                        n9 = n8 + 1;
                        continue;
                    }
                    if (n7 > n) {
                        n10 = n8 - 1;
                        continue;
                    }
                    n10 = n8;
                    n11 = n7;
                    break;
                }
                if (n10 < n9) {
                    n11 = mutableTokenList.tokenOffset(n10);
                }
                abstractToken = TokenListUpdater.token(mutableTokenList, n10);
                if (bl2) {
                    LOG.log(Level.FINE, "BIN-SEARCH: index=" + n10 + ", modTokenOffset=" + n11 + ", modToken.id()=" + abstractToken.id() + "\n");
                }
            }
        }
        tokenListChange.setOffsetGapIndex(n10);
        n7 = 0;
        if (n10 == 0) {
            n9 = n10;
            n8 = n11;
            if (abstractToken != null && n3 < abstractToken.length()) {
                n7 = 1;
            }
        } else {
            if (n == n11 && n3 == 0) {
                abstractToken = TokenListUpdater.token(mutableTokenList, --n10);
                n11 -= abstractToken.length();
            }
            if (n10 == 0 || n11 + mutableTokenList.lookahead(n10 - 1) <= n) {
                n9 = n10;
                n8 = n11;
                if (n + n3 < n11 + abstractToken.length()) {
                    n7 = 1;
                }
            } else {
                AbstractToken<T> abstractToken2;
                n8 = n11 - TokenListUpdater.token(mutableTokenList, n10 - 1).length();
                for (n9 = n10 - 2; n9 >= 0; --n9, n8 -= abstractToken2.length()) {
                    abstractToken2 = TokenListUpdater.token(mutableTokenList, n9);
                    if (n8 + mutableTokenList.lookahead(n9) <= n) break;
                }
                ++n9;
            }
        }
        if (n7 != 0) {
            n6 = n11 + abstractToken.length();
            tokenValidator2 = languageOperation.tokenValidator(abstractToken.id());
            if (tokenValidator2 != null && mutableTokenList.getClass() == IncTokenList.class) {
                // empty if block
            }
        } else if (n10 < n12) {
            int n13 = n + n3;
            for (n6 = n11 + abstractToken.length(); n6 < n13 && n10 + 1 < n12; n6 += TokenListUpdater.token(mutableTokenList, ++n10).length()) {
            }
        } else {
            n6 = n11;
        }
        tokenValidator2 = n9 > 0 ? mutableTokenList.state(n9 - 1) : tokenValidator;
        tokenListChange.setOffset(n8);
        boolean bl3 = bl = n8 != (n6 += n2 - n3) || n10 >= n12 || !LexerUtilsConstants.statesEqual(tokenValidator2, mutableTokenList.state(n10));
        if (!bl && (n5 = mutableTokenList.lookahead(n10)) > 1 && n10 + 1 < n12) {
            boolean bl4 = bl = n5 > TokenListUpdater.token(mutableTokenList, n10 + 1).length();
        }
        if (bl2) {
            LOG.log(Level.FINE, "BEFORE-RELEX: index=" + n10 + ", modTokenOffset=" + n11 + ", relexIndex=" + n9 + ", relexOffset=" + n8 + ", relexState=" + tokenValidator2 + ", matchOffset=" + n6 + ", perform relex: " + bl + "\n");
        }
        if (bl) {
            AbstractToken abstractToken3;
            LexerInputOperation<T> lexerInputOperation = mutableTokenList.createLexerInputOperation(n9, n8, tokenValidator2);
            do {
                AbstractToken<T> abstractToken4;
                if ((abstractToken4 = lexerInputOperation.nextToken()) == null) {
                    n7 = 0;
                    break;
                }
                n5 = lexerInputOperation.lookahead();
                abstractToken3 = lexerInputOperation.lexerState();
                if (bl2) {
                    LOG.log(Level.FINE, "LEXED-TOKEN: id=" + abstractToken4.id() + ", length=" + abstractToken4.length() + ", lookahead=" + n5 + ", state=" + abstractToken3 + "\n");
                }
                tokenListChange.addToken(abstractToken4, n5, abstractToken3);
                if ((n8 += abstractToken4.length()) > n6 && n10 < n12) {
                    n7 = 0;
                    do {
                        if (++n10 != n12) continue;
                        abstractToken = null;
                        if (mutableTokenList.isFullyLexed()) {
                            n6 = Integer.MAX_VALUE;
                            break;
                        }
                        bl = false;
                        break;
                    } while (n8 > (n6 += TokenListUpdater.token(mutableTokenList, n10).length()));
                }
                if (n8 != n6 || n10 >= n12 || !LexerUtilsConstants.statesEqual(abstractToken3, mutableTokenList.state(n10))) continue;
                int n14 = mutableTokenList.lookahead(n10);
                bl = false;
                if (n14 > 1 || n5 > 1) {
                    int n15;
                    for (int i = n10 + 1; i < n12 && ((n5 -= (n15 = TokenListUpdater.token(mutableTokenList, i).length())) > 0 || (n14 -= n15) > 0); ++i) {
                        if (n5 == mutableTokenList.lookahead(i) && n14 <= 0) continue;
                        if (bl2) {
                            LOG.log(Level.FINE, "EXTRA-RELEX: index=" + n10 + ", lookahead=" + n5 + ", tokenLength=" + n15 + "\n");
                        }
                        n10 = i;
                        n6 += n15;
                        bl = true;
                    }
                }
                if (bl || n7 == 0) continue;
                n7 = 0;
            } while (bl);
            lexerInputOperation.release();
            for (int i = tokenListChange.addedTokensOrBranchesCount() - 1; i >= 1 && n10 > n9 && n10 < n12; --i, --n10, n8 -= abstractToken3.length()) {
                abstractToken3 = LexerUtilsConstants.token(tokenListChange.addedTokensOrBranches().get(i));
                AbstractToken<T> abstractToken5 = TokenListUpdater.token(mutableTokenList, n10);
                if (abstractToken3.id() != abstractToken5.id() || abstractToken3.length() != abstractToken5.length() || tokenListChange.laState().lookahead(i) != mutableTokenList.lookahead(n10) || !LexerUtilsConstants.statesEqual(tokenListChange.laState().state(i), mutableTokenList.state(n10))) break;
                if (bl2) {
                    LOG.log(Level.FINE, "RETAIN-ORIGINAL: index=" + n10 + ", id=" + abstractToken5.id() + "\n");
                }
                tokenListChange.removeLastAddedToken();
            }
        }
        int n16 = n4 = abstractToken != null ? n10 - n9 + 1 : n10 - n9;
        if (bl2) {
            LOG.log(Level.FINE, "TokenListUpdater.update() FINISHED: Removed:" + n4 + ", Added:" + tokenListChange.addedTokensOrBranchesCount() + " tokens.\n");
        }
        tokenListChange.setIndex(n9);
        tokenListChange.setAddedEndOffset(n8);
        mutableTokenList.replaceTokens(tokenListChange, n4, n2 - n3);
    }

    private static <T extends TokenId> AbstractToken<T> token(MutableTokenList<T> mutableTokenList, int n) {
        Object object = mutableTokenList.tokenOrEmbeddingContainerUnsync(n);
        return LexerUtilsConstants.token(object);
    }
}

