/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * VersionWarningDialog.java
 *
 * Created on 25-mag-2009, 16.15.51
 */

package com.jaspersoft.ireport.designer.compatibility;

import com.jaspersoft.ireport.locale.I18n;

/**
 *
 * @author gtoffoli
 */
public class VersionWarningDialog extends javax.swing.JDialog {

    public static int DIALOG_RESULT_KEEP_VERSION = 1;
    public static int DIALOG_RESULT_USE_LAST_VERSION = 2;

    private int dialogResult = DIALOG_RESULT_KEEP_VERSION;

    /** Creates new form VersionWarningDialog */
    public VersionWarningDialog(java.awt.Frame parent, boolean modal) {
        super(parent, modal);
        initComponents();

        jLabelWarning.setText(I18n.getString("VersionWarningDialog.jLabelWarning.text")); // NOI18N
        jCheckBoxNoAgain.setText(I18n.getString("VersionWarningDialog.jCheckBoxNoAgain.text")); // NOI18N
        jButtonLastVersion.setText(I18n.getString("VersionWarningDialog.jButtonLastVersion.text")); // NOI18N
        jButtonOk.setText(I18n.getString("VersionWarningDialog.jButtonOk.text")); // NOI18N

        setLocationRelativeTo(null);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelWarning = new javax.swing.JLabel();
        jCheckBoxNoAgain = new javax.swing.JCheckBox();
        jButtonLastVersion = new javax.swing.JButton();
        jButtonOk = new javax.swing.JButton();
        jSeparator1 = new javax.swing.JSeparator();

        setDefaultCloseOperation(javax.swing.WindowConstants.DISPOSE_ON_CLOSE);
        setTitle("\"Compatibility warning\"");

        jLabelWarning.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/resources/info.png"))); // NOI18N
        jLabelWarning.setText("<html>This report may contain formatting or content that cannot be saved in JasperReports {0}. Do you want to save the report using keeping the compatibility with this version anyway?<br><br>Use the latest JasperReports version to be sure all formatting and content is saved correctly.");
        jLabelWarning.setVerticalAlignment(javax.swing.SwingConstants.TOP);
        jLabelWarning.setIconTextGap(10);

        jCheckBoxNoAgain.setText("Don't show this dialog again");

        jButtonLastVersion.setText("Save using the latest version");
        jButtonLastVersion.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonLastVersionActionPerformed(evt);
            }
        });

        jButtonOk.setText("Keep this version");
        jButtonOk.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOkActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, jSeparator1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 498, Short.MAX_VALUE)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap(80, Short.MAX_VALUE)
                .add(jCheckBoxNoAgain, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 385, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .add(33, 33, 33))
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabelWarning, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 478, Short.MAX_VALUE)
                .addContainerGap())
            .add(layout.createSequentialGroup()
                .add(85, 85, 85)
                .add(jButtonOk)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jButtonLastVersion)
                .addContainerGap(121, Short.MAX_VALUE))
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabelWarning, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 103, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                    .add(jButtonOk)
                    .add(jButtonLastVersion))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jSeparator1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 10, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jCheckBoxNoAgain))
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonOkActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOkActionPerformed

        setDialogResult(DIALOG_RESULT_KEEP_VERSION);
        this.setVisible(false);
        this.dispose();

    }//GEN-LAST:event_jButtonOkActionPerformed

    private void jButtonLastVersionActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonLastVersionActionPerformed
        setDialogResult(DIALOG_RESULT_USE_LAST_VERSION);
        this.setVisible(false);
        this.dispose();
    }//GEN-LAST:event_jButtonLastVersionActionPerformed

    public void setVersion(String version)
    {
        String v = version.replace('_', '.');
        jLabelWarning.setText(I18n.getString("VersionWarningDialog.jLabelWarning.text", v));
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonLastVersion;
    private javax.swing.JButton jButtonOk;
    private javax.swing.JCheckBox jCheckBoxNoAgain;
    private javax.swing.JLabel jLabelWarning;
    private javax.swing.JSeparator jSeparator1;
    // End of variables declaration//GEN-END:variables

    public boolean askAgain()
    {
        return !jCheckBoxNoAgain.isSelected();
    }

    /**
     * @return the dialogResult
     */
    public int getDialogResult() {
        return dialogResult;
    }

    /**
     * @param dialogResult the dialogResult to set
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
}
