/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

/*
 * LabelItemPanel.java
 *
 * Created on 30-lug-2009, 22.55.25
 */

package com.jaspersoft.ireport.designer.sheet.properties.charts;

import com.jaspersoft.ireport.designer.fonts.JRFontPanel;
import java.awt.BorderLayout;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.design.JRDesignItemLabel;
import net.sf.jasperreports.engine.JRChart;

/**
 *
 * @author gtoffoli
 */
public class JRItemLabelPanel extends javax.swing.JPanel {

    JRFontPanel fontPanel = null;
    JRChart chart = null;
    /** Creates new form LabelItemPanel */
    public JRItemLabelPanel() {
        initComponents();
        fontPanel = new JRFontPanel();
        add(fontPanel, BorderLayout.CENTER);
        this.updateUI();
    }

    public void setChart(JRChart chart)
    {
        this.chart = chart;
    }

    public void setItemLabel(JRItemLabel itemLabel)
    {
        if (itemLabel == null)
        {
            itemLabel = new JRDesignItemLabel(null, chart);
        }
        fontPanel.setJRFont(itemLabel.getFont());
        colorSelectorPanel1.setColor( itemLabel.getColor() );
        colorSelectorPanel2.setColor( itemLabel.getBackgroundColor() );
    }

    public JRDesignItemLabel getItemLabel()
    {
        JRDesignItemLabel itemLabel = new JRDesignItemLabel(null, chart);
        itemLabel.setFont(  fontPanel.getJRFont() );
        itemLabel.setColor( colorSelectorPanel1.getColor());
        itemLabel.setBackgroundColor( colorSelectorPanel2.getColor());

        return itemLabel;
    }


    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jPanel1 = new javax.swing.JPanel();
        colorSelectorPanel1 = new com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel();
        jLabelColor = new javax.swing.JLabel();
        jLabelBackgroundColor = new javax.swing.JLabel();
        colorSelectorPanel2 = new com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel();
        jButtonResetColor = new javax.swing.JButton();
        jButtonResetColor1 = new javax.swing.JButton();

        setLayout(new java.awt.BorderLayout());

        jLabelColor.setText(org.openide.util.NbBundle.getMessage(JRItemLabelPanel.class, "JRItemLabelPanel.jLabelColor.text")); // NOI18N

        jLabelBackgroundColor.setText(org.openide.util.NbBundle.getMessage(JRItemLabelPanel.class, "JRItemLabelPanel.jLabelBackgroundColor.text")); // NOI18N

        jButtonResetColor.setText(org.openide.util.NbBundle.getMessage(JRItemLabelPanel.class, "JRItemLabelPanel.jButtonResetColor.text")); // NOI18N
        jButtonResetColor.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonResetColorActionPerformed(evt);
            }
        });

        jButtonResetColor1.setText(org.openide.util.NbBundle.getMessage(JRItemLabelPanel.class, "JRItemLabelPanel.jButtonResetColor1.text")); // NOI18N
        jButtonResetColor1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonResetColor1ActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout jPanel1Layout = new org.jdesktop.layout.GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING, false)
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jLabelColor)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .add(colorSelectorPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 106, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                    .add(jPanel1Layout.createSequentialGroup()
                        .add(jLabelBackgroundColor)
                        .add(18, 18, 18)
                        .add(colorSelectorPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 106, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jButtonResetColor)
                    .add(jButtonResetColor1))
                .addContainerGap(117, Short.MAX_VALUE))
        );
        jPanel1Layout.setVerticalGroup(
            jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jPanel1Layout.createSequentialGroup()
                .addContainerGap()
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(jLabelColor)
                    .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                        .add(jButtonResetColor)
                        .add(colorSelectorPanel1, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jPanel1Layout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(colorSelectorPanel2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(jLabelBackgroundColor)
                    .add(jButtonResetColor1))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        add(jPanel1, java.awt.BorderLayout.SOUTH);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonResetColorActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonResetColorActionPerformed
          colorSelectorPanel1.setColor(chart.getForecolor());
    }//GEN-LAST:event_jButtonResetColorActionPerformed

    private void jButtonResetColor1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonResetColor1ActionPerformed
         colorSelectorPanel2.setColor(chart.getBackcolor());
    }//GEN-LAST:event_jButtonResetColor1ActionPerformed


    // Variables declaration - do not modify//GEN-BEGIN:variables
    private com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel colorSelectorPanel1;
    private com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel colorSelectorPanel2;
    private javax.swing.JButton jButtonResetColor;
    private javax.swing.JButton jButtonResetColor1;
    private javax.swing.JLabel jLabelBackgroundColor;
    private javax.swing.JLabel jLabelColor;
    private javax.swing.JPanel jPanel1;
    // End of variables declaration//GEN-END:variables

}
