/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.db.sql.support;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.openide.util.Parameters;

public final class SQLIdentifiers {
    static /* synthetic */ Class class$org$netbeans$api$db$sql$support$SQLIdentifiers$Quoter;
    static /* synthetic */ Class class$org$netbeans$api$db$sql$support$SQLIdentifiers;

    private SQLIdentifiers() {
    }

    public static Quoter createQuoter(DatabaseMetaData databaseMetaData) {
        return new Quoter(databaseMetaData);
    }

    public static class Quoter {
        private static final Logger LOGGER;
        private static final int LC_RULE = 0;
        private static final int UC_RULE = 1;
        private static final int MC_RULE = 2;
        private final String extraNameChars;
        private final String quoteString;
        private final int caseRule;
        static final /* synthetic */ boolean $assertionsDisabled;

        private Quoter(DatabaseMetaData databaseMetaData) {
            this.extraNameChars = Quoter.getExtraNameChars(databaseMetaData);
            this.quoteString = Quoter.getQuoteString(databaseMetaData);
            this.caseRule = Quoter.getCaseRule(databaseMetaData);
        }

        public final String quoteIfNeeded(String string) {
            Parameters.notNull((CharSequence)"identifier", (Object)string);
            if (this.needToQuote(string)) {
                return this.quoteString + string + this.quoteString;
            }
            return string;
        }

        private boolean needToQuote(String string) {
            if (!$assertionsDisabled && string == null) {
                throw new AssertionError();
            }
            if (string.startsWith(this.quoteString) && string.endsWith(this.quoteString)) {
                return false;
            }
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!this.charNeedsQuoting(string.charAt(i), i == 0)) continue;
                return true;
            }
            if (this.caseRule == 1 && Quoter.containsLowerCase(string)) {
                return true;
            }
            return this.caseRule == 0 && Quoter.containsUpperCase(string);
        }

        private boolean charNeedsQuoting(char c, boolean bl) {
            if (Quoter.isUpperCase(c) || Quoter.isLowerCase(c)) {
                return false;
            }
            if (Quoter.isNumber(c) || c == '_') {
                return bl;
            }
            return this.extraNameChars.indexOf(c) == -1;
        }

        private static boolean isUpperCase(char c) {
            return c >= 'A' && c <= 'Z';
        }

        private static boolean isLowerCase(char c) {
            return c >= 'a' && c <= 'z';
        }

        private static boolean isNumber(char c) {
            return c >= '0' && c <= '9';
        }

        private static boolean containsLowerCase(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!Quoter.isLowerCase(string.charAt(i))) continue;
                return true;
            }
            return false;
        }

        private static boolean containsUpperCase(String string) {
            int n = string.length();
            for (int i = 0; i < n; ++i) {
                if (!Quoter.isUpperCase(string.charAt(i))) continue;
                return true;
            }
            return false;
        }

        private static String getExtraNameChars(DatabaseMetaData databaseMetaData) {
            String string = "";
            try {
                string = databaseMetaData.getExtraNameCharacters();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "DatabaseMetaData.getExtraNameCharacters() failed (" + sQLException.getMessage() + "). " + "Using standard set of characters");
                LOGGER.log(Level.FINE, null, sQLException);
            }
            return string;
        }

        private static String getQuoteString(DatabaseMetaData databaseMetaData) {
            String string = "\"";
            try {
                string = databaseMetaData.getIdentifierQuoteString().trim();
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "DatabaseMetaData.getIdentifierQuoteString() failed (" + sQLException.getMessage() + "). " + "Using '\"' for quoting SQL identifiers");
                LOGGER.log(Level.FINE, null, sQLException);
            }
            return string;
        }

        private static int getCaseRule(DatabaseMetaData databaseMetaData) {
            int n = 1;
            try {
                n = databaseMetaData.storesUpperCaseIdentifiers() ? 1 : (databaseMetaData.storesLowerCaseIdentifiers() ? 0 : (databaseMetaData.storesMixedCaseIdentifiers() ? 2 : 1));
            }
            catch (SQLException sQLException) {
                LOGGER.log(Level.WARNING, "Exception trying to find out how the database stores unquoted identifiers, assuming upper case: " + sQLException.getMessage());
                LOGGER.log(Level.FINE, null, sQLException);
            }
            return n;
        }

        static {
            $assertionsDisabled = !(class$org$netbeans$api$db$sql$support$SQLIdentifiers == null ? (class$org$netbeans$api$db$sql$support$SQLIdentifiers = SQLIdentifiers.class$("org.netbeans.api.db.sql.support.SQLIdentifiers")) : class$org$netbeans$api$db$sql$support$SQLIdentifiers).desiredAssertionStatus();
            LOGGER = Logger.getLogger((class$org$netbeans$api$db$sql$support$SQLIdentifiers$Quoter == null ? (class$org$netbeans$api$db$sql$support$SQLIdentifiers$Quoter = SQLIdentifiers.class$("org.netbeans.api.db.sql.support.SQLIdentifiers$Quoter")) : class$org$netbeans$api$db$sql$support$SQLIdentifiers$Quoter).getName());
        }
    }
}

