/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.explorer.infos;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.api.db.explorer.JDBCDriverManager;
import org.netbeans.modules.db.explorer.DatabaseDriver;
import org.netbeans.modules.db.explorer.driver.JDBCDriverSupport;
import org.netbeans.modules.db.explorer.infos.DatabaseNodeInfo;

public class DriverNodeInfo
extends DatabaseNodeInfo {
    static final long serialVersionUID = 6994829681095273161L;

    public DatabaseDriver getDatabaseDriver() {
        return (DatabaseDriver)this.get("dbdriver");
    }

    public void setDatabaseDriver(DatabaseDriver databaseDriver) {
        this.put("name", databaseDriver.getName());
        this.put("url", databaseDriver.getURL());
        this.put("prefix", databaseDriver.getDatabasePrefix());
        this.put("dbdriver", databaseDriver);
    }

    public void delete() throws IOException {
        try {
            JDBCDriver jDBCDriver = this.getJDBCDriver();
            if (jDBCDriver != null) {
                JDBCDriverManager.getDefault().removeDriver(jDBCDriver);
            }
        }
        catch (DatabaseException databaseException) {
            Logger.getLogger(DriverNodeInfo.class.getName()).log(Level.INFO, null, databaseException);
        }
    }

    public String getIconBase() {
        return (String)(this.checkDriverFiles() ? this.get("iconbaseprefered") : this.get("iconbasepreferednotinstalled"));
    }

    public void setIconBase(String string) {
        if (this.checkDriverFiles()) {
            this.put("iconbaseprefered", string);
        } else {
            this.put("iconbasepreferednotinstalled", string);
        }
    }

    private boolean checkDriverFiles() {
        JDBCDriver jDBCDriver = this.getJDBCDriver();
        if (jDBCDriver != null) {
            return JDBCDriverSupport.isAvailable(jDBCDriver);
        }
        return false;
    }

    public JDBCDriver getJDBCDriver() {
        DatabaseDriver databaseDriver = this.getDatabaseDriver();
        if (databaseDriver == null) {
            return null;
        }
        return databaseDriver.getJDBCDriver();
    }
}

