/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.options.keymap;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.core.options.keymap.api.ShortcutAction;
import org.netbeans.core.options.keymap.api.ShortcutsFinder;
import org.netbeans.modules.options.keymap.Utils;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class ShortcutsDialog
extends JPanel {
    public static final String PROP_SHORTCUT_VALID = "ShortcutsDialog.PROP_SHORTCUT_VALID";
    private Listener listener = null;
    private JButton bTab = new JButton();
    private JButton bClear = new JButton();
    private ShortcutsFinder f = null;
    private boolean shortcutValid = false;
    private JLabel lConflict;
    private JLabel lShortcut;
    private JTextField tfShortcut;

    void init(ShortcutsFinder shortcutsFinder) {
        this.f = shortcutsFinder;
        ShortcutsDialog.loc(this.lShortcut, "Shortcut");
        this.lConflict.setForeground(Color.red);
        ShortcutsDialog.loc(this.bTab, "CTL_Tab");
        this.bTab.getAccessibleContext().setAccessibleName(ShortcutsDialog.loc("AN_Tab"));
        this.bTab.getAccessibleContext().setAccessibleDescription(ShortcutsDialog.loc("AD_Tab"));
        ShortcutsDialog.loc(this.bClear, "CTL_Clear");
        this.bClear.getAccessibleContext().setAccessibleName(ShortcutsDialog.loc("AN_Clear"));
        this.bClear.getAccessibleContext().setAccessibleDescription(ShortcutsDialog.loc("AD_Clear"));
        this.tfShortcut.setFocusTraversalKeys(1, Collections.emptySet());
        this.tfShortcut.setFocusTraversalKeys(3, Collections.emptySet());
        this.tfShortcut.getAccessibleContext().setAccessibleName(ShortcutsDialog.loc("AN_Shortcut"));
        this.tfShortcut.getAccessibleContext().setAccessibleDescription(ShortcutsDialog.loc("AD_Shortcut"));
        this.tfShortcut.setFocusTraversalKeys(2, Collections.emptySet());
        this.listener = new Listener();
        this.tfShortcut.addKeyListener(this.listener);
    }

    private static String loc(String string) {
        return NbBundle.getMessage(ShortcutsDialog.class, (String)string);
    }

    private static void loc(Component component, String string) {
        if (component instanceof AbstractButton) {
            Mnemonics.setLocalizedText((AbstractButton)((AbstractButton)component), (String)ShortcutsDialog.loc(string));
        } else {
            Mnemonics.setLocalizedText((JLabel)((JLabel)component), (String)ShortcutsDialog.loc(string));
        }
    }

    public ShortcutsDialog() {
        this.initComponents();
    }

    public Listener getListener() {
        return this.listener;
    }

    public JLabel getLShortcut() {
        return this.lShortcut;
    }

    public JTextField getTfShortcut() {
        return this.tfShortcut;
    }

    private void initComponents() {
        this.lShortcut = new JLabel();
        this.tfShortcut = new JTextField();
        this.lConflict = new JLabel();
        this.lShortcut.setLabelFor(this.tfShortcut);
        this.lShortcut.setText("Shortcut:");
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.lConflict, -1, 467, Short.MAX_VALUE).add((GroupLayout.Group)groupLayout.createSequentialGroup().add((Component)this.lShortcut).addPreferredGap(0).add((Component)this.tfShortcut, -1, 406, Short.MAX_VALUE))).addContainerGap()));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((GroupLayout.Group)groupLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)groupLayout.createParallelGroup(3).add((Component)this.lShortcut).add((Component)this.tfShortcut, -2, -1, -2)).addPreferredGap(0).add((Component)this.lConflict).addContainerGap(41, Short.MAX_VALUE)));
    }

    public JButton getBTab() {
        return this.bTab;
    }

    public JButton getBClear() {
        return this.bClear;
    }

    public boolean isShortcutValid() {
        return this.shortcutValid;
    }

    private void setShortcutValid(boolean bl) {
        if (bl != this.shortcutValid) {
            this.shortcutValid = bl;
            this.firePropertyChange(PROP_SHORTCUT_VALID, !this.shortcutValid, this.shortcutValid);
        }
    }

    class Listener
    implements ActionListener,
    KeyListener {
        private KeyStroke backspaceKS = KeyStroke.getKeyStroke(8, 0);
        private KeyStroke tabKS = KeyStroke.getKeyStroke(9, 0);
        private String key = "";

        Listener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public void keyPressed(KeyEvent keyEvent) {
            boolean bl;
            KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
            boolean bl2 = bl = keyEvent.getKeyCode() != 16 && keyEvent.getKeyCode() != 17 && keyEvent.getKeyCode() != 18 && keyEvent.getKeyCode() != 157 && keyEvent.getKeyCode() != 65406;
            if (keyStroke.equals(this.backspaceKS) && !this.key.equals("")) {
                int n = this.key.lastIndexOf(32);
                this.key = n < 0 ? "" : this.key.substring(0, n);
                ShortcutsDialog.this.getTfShortcut().setText(this.key);
            } else {
                this.addKeyStroke(keyStroke, bl);
            }
            if (bl) {
                this.updateWarning();
            } else {
                ShortcutsDialog.this.setShortcutValid(false);
            }
            keyEvent.consume();
        }

        public void keyReleased(KeyEvent keyEvent) {
            keyEvent.consume();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == ShortcutsDialog.this.getBClear()) {
                this.key = "";
                ShortcutsDialog.this.getTfShortcut().setText(this.key);
            } else if (actionEvent.getSource() == ShortcutsDialog.this.getBTab()) {
                this.addKeyStroke(this.tabKS, true);
            }
            this.updateWarning();
        }

        private void updateWarning() {
            String string = ShortcutsDialog.this.getTfShortcut().getText();
            ShortcutAction shortcutAction = ShortcutsDialog.this.f.findActionForShortcut(string);
            if (shortcutAction != null) {
                ShortcutsDialog.this.lConflict.setText(MessageFormat.format(ShortcutsDialog.loc("Shortcut_Conflict"), shortcutAction.getDisplayName()));
                ShortcutsDialog.this.setShortcutValid(true);
            } else {
                ShortcutsDialog.this.lConflict.setText("");
                ShortcutsDialog.this.setShortcutValid(string != null && string.length() > 0);
            }
        }

        private void addKeyStroke(KeyStroke keyStroke, boolean bl) {
            String string = Utils.getKeyStrokeAsText(keyStroke);
            if (this.key.equals("")) {
                ShortcutsDialog.this.getTfShortcut().setText(string);
                if (bl) {
                    this.key = string;
                }
            } else {
                ShortcutsDialog.this.getTfShortcut().setText(this.key + " " + string);
                if (bl) {
                    this.key = this.key + " " + string;
                }
            }
        }
    }
}

