/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.impl.highlighting;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.font.TextAttribute;
import java.awt.im.InputMethodHighlight;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.editor.BaseDocumentEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.support.AbstractHighlightsContainer;
import org.netbeans.spi.editor.highlighting.support.OffsetsBag;
import org.openide.util.WeakListeners;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ComposedTextHighlighting
extends AbstractHighlightsContainer
implements DocumentListener,
HighlightsChangeListener {
    private static final Logger LOG = Logger.getLogger(ComposedTextHighlighting.class.getName());
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.impl.highlighting.ComposedTextHighlighting";
    private static final String PROP_COMPLETION_ACTIVE = "completion-active";
    private final JTextComponent component;
    private final Document document;
    private final OffsetsBag bag;
    private final AttributeSet highlightInverse;
    private final AttributeSet highlightUnderlined;

    public ComposedTextHighlighting(JTextComponent jTextComponent, Document document, String string) {
        FontColorSettings fontColorSettings = (FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.parse((String)string)).lookup(FontColorSettings.class);
        AttributeSet attributeSet = fontColorSettings.getFontColors("default");
        Color color = (Color)attributeSet.getAttribute(StyleConstants.Background);
        Color color2 = (Color)attributeSet.getAttribute(StyleConstants.Foreground);
        this.highlightInverse = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, color2, StyleConstants.Foreground, color});
        this.highlightUnderlined = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Underline, color2});
        this.bag = new OffsetsBag(document);
        this.bag.addHighlightsChangeListener((HighlightsChangeListener)this);
        this.document = document;
        this.document.addDocumentListener(WeakListeners.document((DocumentListener)this, (Object)this.document));
        this.component = jTextComponent;
    }

    public HighlightsSequence getHighlights(int n, int n2) {
        return this.bag.getHighlights(n, n2);
    }

    public void highlightChanged(HighlightsChangeEvent highlightsChangeEvent) {
        this.fireHighlightsChange(highlightsChangeEvent.getStartOffset(), highlightsChangeEvent.getEndOffset());
    }

    @Override
    public void insertUpdate(DocumentEvent documentEvent) {
        AttributedString attributedString = ComposedTextHighlighting.getComposedTextAttribute(documentEvent);
        if (attributedString != null) {
            Map<AttributedCharacterIterator.Attribute, Object> map;
            char c;
            Object object;
            ComposedTextHighlighting.enableParsing(this.component, false);
            if (LOG.isLoggable(Level.FINE)) {
                object = new StringBuilder();
                AttributedCharacterIterator attributedCharacterIterator = attributedString.getIterator();
                ((StringBuilder)object).append("\nInsertUpdate: \n");
                c = attributedCharacterIterator.first();
                while (c != '\uffff') {
                    ((StringBuilder)object).append("'").append(c).append("' = {");
                    map = attributedCharacterIterator.getAttributes();
                    for (AttributedCharacterIterator.Attribute attribute : map.keySet()) {
                        Object object2 = map.get(attribute);
                        if (object2 instanceof InputMethodHighlight) {
                            ((StringBuilder)object).append("'").append(attribute).append("' = {");
                            Map<TextAttribute, ?> map2 = ((InputMethodHighlight)object2).getStyle();
                            if (map2 == null) {
                                map2 = Toolkit.getDefaultToolkit().mapInputMethodHighlight((InputMethodHighlight)object2);
                            }
                            if (map2 != null) {
                                for (TextAttribute textAttribute : map2.keySet()) {
                                    Object obj = map2.get(textAttribute);
                                    ((StringBuilder)object).append("'").append(textAttribute).append("' = '").append(obj).append("', ");
                                }
                            } else {
                                ((StringBuilder)object).append("null");
                            }
                            ((StringBuilder)object).append("}, ");
                            continue;
                        }
                        ((StringBuilder)object).append("'").append(attribute).append("' = '").append(object2).append("', ");
                    }
                    ((StringBuilder)object).append("}\n");
                    c = attributedCharacterIterator.next();
                }
                ((StringBuilder)object).append("-------------------------------------\n");
                LOG.fine(((StringBuilder)object).toString());
            }
            object = attributedString.getIterator();
            this.bag.clear();
            int n = documentEvent.getOffset();
            c = object.first();
            while (c != '\uffff') {
                map = object.getAttributes();
                AttributeSet attributeSet = this.translateAttributes(map);
                this.bag.addHighlight(n, n + 1, attributeSet);
                ++n;
                c = object.next();
            }
        } else {
            ComposedTextHighlighting.enableParsing(this.component, true);
            this.bag.clear();
        }
    }

    @Override
    public void removeUpdate(DocumentEvent documentEvent) {
    }

    @Override
    public void changedUpdate(DocumentEvent documentEvent) {
    }

    private static AttributedString getComposedTextAttribute(DocumentEvent documentEvent) {
        Object object;
        AttributeSet attributeSet;
        if (documentEvent instanceof BaseDocumentEvent && (attributeSet = ((BaseDocumentEvent)documentEvent).getChangeAttributes()) != null && (object = attributeSet.getAttribute(StyleConstants.ComposedTextAttribute)) instanceof AttributedString) {
            return (AttributedString)object;
        }
        return null;
    }

    private AttributeSet translateAttributes(Map<AttributedCharacterIterator.Attribute, ?> map) {
        for (AttributedCharacterIterator.Attribute attribute : map.keySet()) {
            Object obj = map.get(attribute);
            if (!(obj instanceof InputMethodHighlight)) continue;
            InputMethodHighlight inputMethodHighlight = (InputMethodHighlight)obj;
            if (inputMethodHighlight.isSelected()) {
                return this.highlightInverse;
            }
            return this.highlightUnderlined;
        }
        LOG.fine("No translation for " + map);
        return SimpleAttributeSet.EMPTY;
    }

    private static void enableParsing(JTextComponent jTextComponent, boolean bl) {
        boolean bl2 = !bl;
        Boolean bl3 = (Boolean)jTextComponent.getClientProperty(PROP_COMPLETION_ACTIVE);
        if (bl3 == null || bl3 != bl2) {
            jTextComponent.putClientProperty(PROP_COMPLETION_ACTIVE, bl2);
        }
    }
}

