/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.lexer.token;

import org.netbeans.api.lexer.PartType;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.lib.editor.util.CharSequenceUtilities;
import org.netbeans.lib.lexer.EmbeddedTokenList;
import org.netbeans.lib.lexer.TokenList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractToken<T extends TokenId>
extends Token<T>
implements CharSequence {
    private final T id;
    private TokenList<T> tokenList;
    private int rawOffset;

    public AbstractToken(T t) {
        assert (t != null);
        this.id = t;
    }

    AbstractToken(T t, TokenList<T> tokenList, int n) {
        this.id = t;
        this.tokenList = tokenList;
        this.rawOffset = n;
    }

    @Override
    public abstract int length();

    @Override
    public final T id() {
        return this.id;
    }

    @Override
    public CharSequence text() {
        if (this.tokenList != null) {
            if (this.tokenList.getClass() == EmbeddedTokenList.class) {
                EmbeddedTokenList embeddedTokenList = (EmbeddedTokenList)this.tokenList;
                return embeddedTokenList.embeddingContainer().updateStatus() ? this : null;
            }
            return this;
        }
        return null;
    }

    public final TokenList<T> tokenList() {
        return this.tokenList;
    }

    public final void setTokenList(TokenList<T> tokenList) {
        this.tokenList = tokenList;
    }

    public final int rawOffset() {
        return this.rawOffset;
    }

    public final void setRawOffset(int n) {
        this.rawOffset = n;
    }

    @Override
    public final boolean isFlyweight() {
        return this.rawOffset == -1;
    }

    public final void makeFlyweight() {
        this.setRawOffset(-1);
    }

    @Override
    public PartType partType() {
        return PartType.COMPLETE;
    }

    @Override
    public boolean isCustomText() {
        return false;
    }

    @Override
    public final int offset(TokenHierarchy<?> tokenHierarchy) {
        if (this.rawOffset == -1) {
            return -1;
        }
        return this.tokenList != null ? this.tokenList.childTokenOffset(this.rawOffset) : this.rawOffset;
    }

    @Override
    public boolean hasProperties() {
        return false;
    }

    @Override
    public Object getProperty(Object object) {
        return null;
    }

    @Override
    public final char charAt(int n) {
        if (n < 0 || n >= this.length()) {
            throw new IndexOutOfBoundsException("index=" + n + ", length=" + this.length());
        }
        if (this.tokenList == null) {
            throw new IndexOutOfBoundsException("index=" + n + ", length=" + this.length() + " but tokenList==null for token " + this.dumpInfo(null));
        }
        return this.tokenList.childTokenCharAt(this.rawOffset, n);
    }

    @Override
    public final CharSequence subSequence(int n, int n2) {
        return CharSequenceUtilities.toString((CharSequence)this, (int)n, (int)n2);
    }

    @Override
    public String toString() {
        CharSequence charSequence = this.text();
        return charSequence != null ? CharSequenceUtilities.toString((CharSequence)this, (int)0, (int)this.length()) : "<null>";
    }

    public String dumpInfo(TokenHierarchy<?> tokenHierarchy) {
        int n;
        StringBuilder stringBuilder = new StringBuilder();
        CharSequence charSequence = this.text();
        if (charSequence != null) {
            stringBuilder.append('\"');
            for (n = 0; n < charSequence.length(); ++n) {
                try {
                    CharSequenceUtilities.debugChar((StringBuilder)stringBuilder, (char)charSequence.charAt(n));
                    continue;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    stringBuilder.append("IOOBE at index=").append(n).append("!!!");
                    break;
                }
            }
            stringBuilder.append('\"');
        } else {
            stringBuilder.append("<null-text>");
        }
        stringBuilder.append(' ');
        if (this.isFlyweight()) {
            stringBuilder.append("F(").append(this.length()).append(')');
        } else {
            n = this.offset(tokenHierarchy);
            stringBuilder.append('<').append(n);
            stringBuilder.append(",").append(n + this.length()).append('>');
        }
        stringBuilder.append(' ').append(this.id != null ? this.id.name() + '[' + this.id.ordinal() + ']' : "<null-id>");
        stringBuilder.append(" ").append(this.dumpInfoTokenType());
        return stringBuilder.toString();
    }

    protected String dumpInfoTokenType() {
        return "AbsT";
    }
}

