/*
 * Decompiled with CFR 0.152.
 */
package org.openidex.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import org.openide.ErrorManager;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openidex.search.SearchGroup;
import org.openidex.search.SearchInfo;
import org.openidex.search.SearchType;
import org.openidex.search.Utils;

public class DataObjectSearchGroup
extends SearchGroup {
    private static boolean lowMemoryWarning = false;
    private static int lowMemoryWarningCount = 0;
    private static int MB = 0x100000;
    private static int REQUIRED_PER_ITERATION = 2 * MB;
    private static int REQUIRED_PER_FULL_GC = 7 * MB;

    protected void add(SearchType searchType) {
        boolean bl = false;
        for (Class clazz : searchType.getSearchTypeClasses()) {
            if (clazz != DataObject.class) continue;
            bl = true;
            break;
        }
        if (bl) {
            super.add(searchType);
        }
    }

    public void doSearch() {
        Node[] nodeArray = DataObjectSearchGroup.normalizeNodes(this.searchRoots.toArray(new Node[this.searchRoots.size()]));
        lowMemoryWarning = false;
        lowMemoryWarningCount = 0;
        DataObjectSearchGroup.assureMemory(REQUIRED_PER_ITERATION, true);
        for (Node node : nodeArray) {
            SearchInfo searchInfo = Utils.getSearchInfo(node);
            if (searchInfo == null) continue;
            Iterator<DataObject> iterator = searchInfo.objectsToSearch();
            while (iterator.hasNext()) {
                if (this.stopped) {
                    return;
                }
                DataObjectSearchGroup.assureMemory(REQUIRED_PER_ITERATION, false);
                this.processSearchObject(iterator.next());
            }
        }
    }

    private static void assureMemory(int n, boolean bl) {
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory();
        long l2 = runtime.maxMemory();
        long l3 = Math.max(l / 13L, (long)(n + REQUIRED_PER_FULL_GC));
        if (l == l2 && runtime.freeMemory() < l3) {
            if (bl) {
                try {
                    byte[] byArray = new byte[(int)l3];
                    byArray[0] = 75;
                    byArray = null;
                    return;
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    DataObjectSearchGroup.throwNoMemory();
                }
            } else {
                lowMemoryWarning = true;
            }
        } else if (lowMemoryWarning) {
            lowMemoryWarning = false;
            ++lowMemoryWarningCount;
        }
        if (lowMemoryWarningCount > 7 || l == l2 && runtime.freeMemory() < (long)REQUIRED_PER_FULL_GC) {
            DataObjectSearchGroup.throwNoMemory();
        }
    }

    private static void throwNoMemory() {
        RuntimeException runtimeException = new RuntimeException("Low memory condition");
        String string = NbBundle.getMessage(DataObjectSearchGroup.class, (String)"EX_memory");
        ErrorManager.getDefault().annotate((Throwable)runtimeException, 256, null, string, null, null);
        throw runtimeException;
    }

    public Node getNodeForFoundObject(Object object) {
        if (!(object instanceof DataObject)) {
            return null;
        }
        return ((DataObject)object).getNodeDelegate();
    }

    private static Node[] normalizeNodes(Node[] nodeArray) {
        if (nodeArray.length < 2) {
            return nodeArray;
        }
        HashMap<Node, Boolean> hashMap = new HashMap<Node, Boolean>(2 * nodeArray.length, 0.75f);
        HashMap<Node, Boolean> hashMap2 = new HashMap<Node, Boolean>(2 * nodeArray.length, 0.75f);
        ArrayList<Object> arrayList = new ArrayList<Object>(10);
        ArrayList<Node> arrayList2 = new ArrayList<Node>(nodeArray.length);
        for (Node node : nodeArray) {
            hashMap.put(node, Boolean.FALSE);
        }
        for (Node node : nodeArray) {
            Node node2;
            Object object;
            arrayList.clear();
            boolean bl = false;
            for (object = node.getParentNode(); object != null; object = object.getParentNode()) {
                if (hashMap.containsKey(object)) {
                    bl = true;
                    break;
                }
                if (hashMap2.containsKey(object)) break;
                arrayList.add(object);
            }
            if (bl) {
                hashMap.put(node, Boolean.TRUE);
                object = arrayList.iterator();
                while (object.hasNext()) {
                    node2 = (Node)object.next();
                    hashMap.put(node2, Boolean.TRUE);
                }
                continue;
            }
            object = arrayList.iterator();
            while (object.hasNext()) {
                node2 = (Node)object.next();
                hashMap2.put(node2, Boolean.TRUE);
            }
            arrayList2.add(node);
        }
        return arrayList2.toArray(new Node[arrayList2.size()]);
    }
}

