/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;
import mondrian.util.FilteredIterableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExceptFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Except", "Except(<Set1>, <Set2>[, ALL])", "Finds the difference between two sets, optionally retaining duplicates.", new String[]{"fxxx", "fxxxy"}, ExceptFunDef.class);

    public ExceptFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        ListCalc listCalc0 = compiler.compileList(call.getArg(0));
        ListCalc listCalc1 = compiler.compileList(call.getArg(1));
        Type elementType = ((SetType)listCalc0.getType()).getElementType();
        if (elementType instanceof TupleType) {
            final TupleListCalc tupleListCalc0 = (TupleListCalc)listCalc0;
            final TupleListCalc tupleListCalc1 = (TupleListCalc)listCalc1;
            return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

                public List evaluateList(Evaluator evaluator) {
                    List<Member[]> list0 = tupleListCalc0.evaluateTupleList(evaluator);
                    if (list0.isEmpty()) {
                        return list0;
                    }
                    List<Member[]> list1 = tupleListCalc1.evaluateTupleList(evaluator);
                    return ExceptFunDef.this.exceptTuples(list0, list1);
                }
            };
        }
        final MemberListCalc memberListCalc0 = (MemberListCalc)listCalc0;
        final MemberListCalc memberListCalc1 = (MemberListCalc)listCalc1;
        return new AbstractListCalc(call, new Calc[]{listCalc0, listCalc1}){

            public List evaluateList(Evaluator evaluator) {
                List<Member> list0 = memberListCalc0.evaluateMemberList(evaluator);
                if (list0.isEmpty()) {
                    return list0;
                }
                List<Member> list1 = memberListCalc1.evaluateMemberList(evaluator);
                return ExceptFunDef.this.except(list0, list1);
            }
        };
    }

    <T> List<T> except(List<T> list0, List<T> list1) {
        if (list0.size() == 0) {
            return list0;
        }
        final HashSet<T> set = new HashSet<T>(list1);
        return new FilteredIterableList<T>(list0, new FilteredIterableList.Filter<T>(){

            @Override
            public boolean accept(T o) {
                return !set.contains(o);
            }
        });
    }

    List exceptTuples(List<Member[]> list0, List<Member[]> list1) {
        if (list0.size() == 0) {
            return list0;
        }
        final HashSet<List<Member>> set = new HashSet<List<Member>>();
        for (Member[] members : list1) {
            set.add(Arrays.asList(members));
        }
        return new FilteredIterableList<Member[]>(list0, new FilteredIterableList.Filter<Member[]>(){

            @Override
            public boolean accept(Member[] o) {
                return !set.contains(Arrays.asList(o));
            }
        });
    }
}

