/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberCalc;
import mondrian.calc.MemberIterCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.ResultStyle;
import mondrian.calc.TupleCalc;
import mondrian.calc.TupleIterCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.VoidCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractMemberIterCalc;
import mondrian.calc.impl.AbstractMemberListCalc;
import mondrian.calc.impl.AbstractTupleIterCalc;
import mondrian.calc.impl.AbstractTupleListCalc;
import mondrian.calc.impl.AbstractVoidCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.ExpBase;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.ResultStyleException;
import mondrian.olap.Syntax;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;
import mondrian.resource.MondrianResource;
import mondrian.util.ConcatenableList;
import mondrian.util.FilteredIterableList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SetFunDef
extends FunDefBase {
    static final ResolverImpl Resolver = new ResolverImpl();

    SetFunDef(Resolver resolver, int[] argTypes) {
        super(resolver, 8, argTypes);
    }

    @Override
    public void unparse(Exp[] args, PrintWriter pw) {
        ExpBase.unparseList(pw, args, "{", ", ", "}");
    }

    @Override
    public Type getResultType(Validator validator, Exp[] args) {
        Type type0 = null;
        if (args.length == 0) {
            type0 = MemberType.Unknown;
        } else {
            for (int i = 0; i < args.length; ++i) {
                Exp arg = args[i];
                Type type = arg.getType();
                type = TypeUtil.toMemberOrTupleType(type);
                if (i == 0) {
                    type0 = type;
                    continue;
                }
                if (TypeUtil.isUnionCompatible(type0, type)) continue;
                throw MondrianResource.instance().ArgsMustHaveSameHierarchy.ex(this.getName());
            }
        }
        return new SetType(type0);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        Exp[] args = call.getArgs();
        if (args.length == 0) {
            return new EmptyListCalc(call);
        }
        if (args.length == 1 && args[0].getType() instanceof SetType) {
            return args[0].accept(compiler);
        }
        if (((SetType)call.getType()).getArity() == 1) {
            return new MemberSetListCalc(call, args, compiler, ResultStyle.LIST_MUTABLELIST);
        }
        return new TupleSetListCalc(call, args, compiler, ResultStyle.LIST_MUTABLELIST);
    }

    private static List<Calc> compileSelf(Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
        ArrayList<Calc> calcs = new ArrayList<Calc>(args.length);
        for (Exp arg : args) {
            calcs.add(SetFunDef.createCalc(arg, compiler, resultStyles));
        }
        return calcs;
    }

    private static IterCalc createCalc(Exp arg, ExpCompiler compiler, List<ResultStyle> resultStyles) {
        Type type = arg.getType();
        if (type instanceof SetType) {
            Calc calc = compiler.compileAs(arg, null, resultStyles);
            if (((SetType)type).getArity() == 1) {
                switch (calc.getResultStyle()) {
                    case ITERABLE: {
                        final MemberIterCalc iterCalc = (MemberIterCalc)calc;
                        return new AbstractMemberIterCalc(arg, new Calc[]{calc}){

                            @Override
                            public Iterable<Member> evaluateMemberIterable(Evaluator evaluator) {
                                return iterCalc.evaluateMemberIterable(evaluator);
                            }

                            @Override
                            protected String getName() {
                                return "Sublist";
                            }
                        };
                    }
                    case LIST: 
                    case MUTABLE_LIST: {
                        final MemberListCalc memberListCalc = (MemberListCalc)calc;
                        return new AbstractMemberIterCalc(arg, new Calc[]{calc}){

                            @Override
                            public Iterable<Member> evaluateMemberIterable(Evaluator evaluator) {
                                ArrayList<Member> result = new ArrayList<Member>();
                                List<Member> list = memberListCalc.evaluateMemberList(evaluator);
                                for (Member member : list) {
                                    if (member == null || member.isNull()) continue;
                                    result.add(member);
                                }
                                return result;
                            }

                            @Override
                            protected String getName() {
                                return "Sublist";
                            }
                        };
                    }
                }
                throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
            }
            switch (calc.getResultStyle()) {
                case ITERABLE: {
                    final TupleIterCalc iterCalc = (TupleIterCalc)calc;
                    return new AbstractTupleIterCalc(arg, new Calc[]{calc}){

                        @Override
                        public Iterable<Member[]> evaluateTupleIterable(Evaluator evaluator) {
                            return iterCalc.evaluateTupleIterable(evaluator);
                        }

                        @Override
                        protected String getName() {
                            return "Sublist";
                        }
                    };
                }
                case LIST: 
                case MUTABLE_LIST: {
                    final TupleListCalc tupleListCalc = (TupleListCalc)calc;
                    return new AbstractTupleIterCalc(arg, new Calc[]{calc}){

                        @Override
                        public Iterable<Member[]> evaluateTupleIterable(Evaluator evaluator) {
                            ArrayList<Member[]> result = new ArrayList<Member[]>();
                            List<Member[]> list = tupleListCalc.evaluateTupleList(evaluator);
                            block0: for (Member[] members : list) {
                                for (Member member : members) {
                                    if (member == null || member.isNull()) continue block0;
                                }
                                result.add(members);
                            }
                            return result;
                        }

                        @Override
                        protected String getName() {
                            return "Sublist";
                        }
                    };
                }
            }
            throw ResultStyleException.generateBadType(ResultStyle.ITERABLE_LIST_MUTABLELIST, calc.getResultStyle());
        }
        if (TypeUtil.couldBeMember(type)) {
            final MemberCalc memberCalc = compiler.compileMember(arg);
            ResolvedFunCall call = SetFunDef.wrapAsSet(arg);
            return new AbstractMemberIterCalc(call, new Calc[]{memberCalc}){

                @Override
                public Iterable<Member> evaluateMemberIterable(Evaluator evaluator) {
                    final Member member = memberCalc.evaluateMember(evaluator);
                    return new Iterable<Member>(){

                        @Override
                        public Iterator<Member> iterator() {
                            return new Iterator<Member>(){
                                private Member m;
                                {
                                    this.m = member;
                                }

                                @Override
                                public boolean hasNext() {
                                    return this.m != null;
                                }

                                /*
                                 * WARNING - Removed try catching itself - possible behaviour change.
                                 */
                                @Override
                                public Member next() {
                                    try {
                                        Member member = this.m;
                                        return member;
                                    }
                                    finally {
                                        this.m = null;
                                    }
                                }

                                @Override
                                public void remove() {
                                    throw new UnsupportedOperationException("remove");
                                }
                            };
                        }
                    };
                }

                @Override
                protected String getName() {
                    return "Sublist";
                }
            };
        }
        final TupleCalc tupleCalc = compiler.compileTuple(arg);
        ResolvedFunCall call = SetFunDef.wrapAsSet(arg);
        return new AbstractTupleIterCalc(call, new Calc[]{tupleCalc}){

            @Override
            public Iterable<Member[]> evaluateTupleIterable(Evaluator evaluator) {
                final Member[] members = tupleCalc.evaluateTuple(evaluator);
                return new Iterable<Member[]>(){

                    @Override
                    public Iterator<Member[]> iterator() {
                        return new Iterator<Member[]>(){
                            private Member[] m;
                            {
                                this.m = members;
                            }

                            @Override
                            public boolean hasNext() {
                                return this.m != null;
                            }

                            /*
                             * WARNING - Removed try catching itself - possible behaviour change.
                             */
                            @Override
                            public Member[] next() {
                                try {
                                    Member[] memberArray = this.m;
                                    return memberArray;
                                }
                                finally {
                                    this.m = null;
                                }
                            }

                            @Override
                            public void remove() {
                                throw new UnsupportedOperationException("remove");
                            }
                        };
                    }
                };
            }

            @Override
            protected String getName() {
                return "Sublist";
            }
        };
    }

    public static ResolvedFunCall wrapAsSet(Exp ... args) {
        assert (args.length > 0);
        int[] categories = new int[args.length];
        Type type = null;
        for (int i = 0; i < args.length; ++i) {
            Exp arg = args[i];
            categories[i] = arg.getCategory();
            Type argType = arg.getType();
            if (!(argType instanceof SetType)) continue;
            type = ((SetType)argType).getElementType();
        }
        return new ResolvedFunCall(new SetFunDef(Resolver, categories), args, new SetType(type));
    }

    private static class EmptyListCalc
    extends AbstractListCalc {
        EmptyListCalc(ResolvedFunCall call) {
            super(call, new Calc[0]);
        }

        public List evaluateList(Evaluator evaluator) {
            return Collections.EMPTY_LIST;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ResolverImpl
    extends ResolverBase {
        public ResolverImpl() {
            super("{}", "{<Member> [, <Member>...]}", "Brace operator constructs a set.", Syntax.Braces);
        }

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            int[] parameterTypes = new int[args.length];
            for (int i = 0; i < args.length; ++i) {
                if (validator.canConvert(args[i], 6, conversions)) {
                    parameterTypes[i] = 6;
                    continue;
                }
                if (validator.canConvert(args[i], 8, conversions)) {
                    parameterTypes[i] = 8;
                    continue;
                }
                if (validator.canConvert(args[i], 10, conversions)) {
                    parameterTypes[i] = 10;
                    continue;
                }
                return null;
            }
            return new SetFunDef(this, parameterTypes);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExprMemberIterCalc
    extends AbstractMemberIterCalc {
        private final MemberIterCalc[] iterCalcs;

        public ExprMemberIterCalc(Exp exp, Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            super(exp, null);
            List calcList = SetFunDef.compileSelf(args, compiler, resultStyles);
            this.iterCalcs = calcList.toArray(new MemberIterCalc[calcList.size()]);
        }

        @Override
        public Calc[] getCalcs() {
            return this.iterCalcs;
        }

        @Override
        public Iterable<Member> evaluateMemberIterable(final Evaluator evaluator) {
            return new Iterable<Member>(){

                @Override
                public Iterator<Member> iterator() {
                    return new Iterator<Member>(){
                        int index = 0;
                        Iterator<Member> currentIterator = null;
                        Member member = null;

                        @Override
                        public boolean hasNext() {
                            if (this.member != null) {
                                return true;
                            }
                            if (this.currentIterator == null) {
                                if (this.index >= ExprMemberIterCalc.this.iterCalcs.length) {
                                    return false;
                                }
                                MemberIterCalc iterCalc = ExprMemberIterCalc.this.iterCalcs[this.index++];
                                Iterable<Member> iter = iterCalc.evaluateMemberIterable(evaluator);
                                this.currentIterator = iter.iterator();
                            }
                            do {
                                boolean b = this.currentIterator.hasNext();
                                while (!b) {
                                    if (this.index >= ExprMemberIterCalc.this.iterCalcs.length) {
                                        return false;
                                    }
                                    MemberIterCalc iterCalc = ExprMemberIterCalc.this.iterCalcs[this.index++];
                                    Iterable<Member> iter = iterCalc.evaluateMemberIterable(evaluator);
                                    this.currentIterator = iter.iterator();
                                    b = this.currentIterator.hasNext();
                                }
                                this.member = this.currentIterator.next();
                            } while (this.member == null);
                            return true;
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public Member next() {
                            try {
                                Member member = this.member;
                                return member;
                            }
                            finally {
                                this.member = null;
                            }
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException("remove");
                        }
                    };
                }
            };
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TupleSetListCalc
    extends AbstractTupleListCalc {
        private List<Member[]> result = new ConcatenableList<Member[]>();
        private final VoidCalc[] voidCalcs;

        public TupleSetListCalc(Exp exp, Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            super(exp, null);
            this.voidCalcs = this.compileSelf(args, compiler, resultStyles);
        }

        @Override
        public Calc[] getCalcs() {
            return this.voidCalcs;
        }

        private VoidCalc[] compileSelf(Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            VoidCalc[] voidCalcs = new VoidCalc[args.length];
            for (int i = 0; i < args.length; ++i) {
                voidCalcs[i] = this.createCalc(args[i], compiler, resultStyles);
            }
            return voidCalcs;
        }

        private VoidCalc createCalc(Exp arg, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                ListCalc listCalc = compiler.compileList(arg);
                final TupleListCalc tupleListCalc = (TupleListCalc)listCalc;
                return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                    public void evaluateVoid(Evaluator evaluator) {
                        List<Member[]> list = tupleListCalc.evaluateTupleList(evaluator);
                        block0: for (Member[] members : list) {
                            for (Member member : members) {
                                if (member == null || member.isNull()) continue block0;
                            }
                            TupleSetListCalc.this.result.add(members);
                        }
                    }

                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            final TupleCalc tupleCalc = compiler.compileTuple(arg);
            return new AbstractVoidCalc(arg, new Calc[]{tupleCalc}){

                public void evaluateVoid(Evaluator evaluator) {
                    Member[] members = tupleCalc.evaluateTuple(evaluator);
                    if (members == null) {
                        return;
                    }
                    assert (!FunUtil.tupleContainsNullMember(members));
                    TupleSetListCalc.this.result.add(members);
                }
            };
        }

        @Override
        public List<Member[]> evaluateTupleList(Evaluator evaluator) {
            this.result = new ConcatenableList<Member[]>();
            for (VoidCalc voidCalc : this.voidCalcs) {
                voidCalc.evaluateVoid(evaluator);
            }
            return this.result;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MemberSetListCalc
    extends AbstractMemberListCalc {
        private List<Member> result = new ConcatenableList<Member>();
        private final VoidCalc[] voidCalcs;

        public MemberSetListCalc(Exp exp, Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            super(exp, null);
            this.voidCalcs = this.compileSelf(args, compiler, resultStyles);
        }

        @Override
        public Calc[] getCalcs() {
            return this.voidCalcs;
        }

        private VoidCalc[] compileSelf(Exp[] args, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            VoidCalc[] voidCalcs = new VoidCalc[args.length];
            for (int i = 0; i < args.length; ++i) {
                voidCalcs[i] = this.createCalc(args[i], compiler, resultStyles);
            }
            return voidCalcs;
        }

        private VoidCalc createCalc(Exp arg, ExpCompiler compiler, List<ResultStyle> resultStyles) {
            Type type = arg.getType();
            if (type instanceof SetType) {
                ListCalc listCalc = compiler.compileList(arg);
                final MemberListCalc memberListCalc = (MemberListCalc)listCalc;
                return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                    public void evaluateVoid(Evaluator evaluator) {
                        List<Member> memberList = memberListCalc.evaluateMemberList(evaluator);
                        FilteredIterableList<Member> list = new FilteredIterableList<Member>(memberList, new FilteredIterableList.Filter<Member>(){

                            @Override
                            public boolean accept(Member m) {
                                return m != null && !m.isNull();
                            }
                        });
                        MemberSetListCalc.this.result.addAll(list);
                    }

                    protected String getName() {
                        return "Sublist";
                    }
                };
            }
            final MemberCalc listCalc = compiler.compileMember(arg);
            return new AbstractVoidCalc(arg, new Calc[]{listCalc}){

                public void evaluateVoid(Evaluator evaluator) {
                    Member member = listCalc.evaluateMember(evaluator);
                    if (member == null || member.isNull()) {
                        return;
                    }
                    MemberSetListCalc.this.result.add(member);
                }

                protected String getName() {
                    return "Sublist";
                }
            };
        }

        @Override
        public List<Member> evaluateMemberList(Evaluator evaluator) {
            this.result = new ConcatenableList<Member>();
            for (VoidCalc voidCalc : this.voidCalcs) {
                voidCalc.evaluateVoid(evaluator);
            }
            if (!this.result.isEmpty() && !this.result.get(0).getDimension().isHighCardinality()) {
                this.result.toArray();
            }
            return this.result;
        }
    }
}

