/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IntegerCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.impl.AbstractMemberCalc;
import mondrian.calc.impl.AbstractTupleCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.ResolverBase;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.TupleType;
import mondrian.olap.type.Type;

class SetItemFunDef
extends FunDefBase {
    static final Resolver intResolver = new ReflectiveMultiResolver("Item", "<Set>.Item(<Index>)", "Returns a tuple from the set specified in <Set>. The tuple to be returned is specified by the zero-based position of the tuple in the set in <Index>.", new String[]{"mmxn"}, SetItemFunDef.class);
    static final Resolver stringResolver = new ResolverBase("Item", "<Set>.Item(<String> [, ...])", "Returns a tuple from the set specified in <Set>. The tuple to be returned is specified by the member name (or names) in <String>.", Syntax.Method){

        @Override
        public FunDef resolve(Exp[] args, Validator validator, List<Resolver.Conversion> conversions) {
            if (args.length < 1) {
                return null;
            }
            Exp setExp = args[0];
            if (!(setExp.getType() instanceof SetType)) {
                return null;
            }
            SetType setType = (SetType)setExp.getType();
            int arity = setType.getElementType() instanceof TupleType ? ((TupleType)setType.getElementType()).elementTypes.length : 1;
            for (int i = 1; i < args.length; ++i) {
                if (validator.canConvert(args[i], 9, conversions)) continue;
                return null;
            }
            if (args.length - 1 != arity) {
                throw Util.newError("Argument count does not match set's cardinality " + arity);
            }
            int category = arity == 1 ? 6 : 10;
            FunDef dummy = 1.createDummyFunDef(this, category, args);
            return new SetItemFunDef(dummy);
        }
    };

    public SetItemFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        SetType setType = (SetType)args[0].getType();
        return setType.getElementType();
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        StringCalc[] stringCalcs;
        IntegerCalc indexCalc;
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        Type elementType = ((SetType)listCalc.getType()).getElementType();
        boolean isString = call.getArgCount() < 2 || call.getArg(1).getType() instanceof StringType;
        ArrayList<Calc> calcList = new ArrayList<Calc>();
        calcList.add(listCalc);
        if (isString) {
            indexCalc = null;
            stringCalcs = new StringCalc[call.getArgCount() - 1];
            for (int i = 0; i < stringCalcs.length; ++i) {
                stringCalcs[i] = compiler.compileString(call.getArg(i + 1));
                calcList.add(stringCalcs[i]);
            }
        } else {
            stringCalcs = null;
            indexCalc = compiler.compileInteger(call.getArg(1));
            calcList.add(indexCalc);
        }
        Calc[] calcs = calcList.toArray(new Calc[calcList.size()]);
        if (elementType instanceof TupleType) {
            TupleType tupleType = (TupleType)elementType;
            final Member[] nullTuple = SetItemFunDef.makeNullTuple(tupleType);
            if (isString) {
                return new AbstractTupleCalc(call, calcs){

                    public Member[] evaluateTuple(Evaluator evaluator) {
                        List list = listCalc.evaluateList(evaluator.push(false));
                        assert (list != null);
                        String[] results = new String[stringCalcs.length];
                        for (int i = 0; i < stringCalcs.length; ++i) {
                            results[i] = stringCalcs[i].evaluateString(evaluator);
                        }
                        block1: for (Member[] members : list) {
                            for (int j = 0; j < results.length; ++j) {
                                Member member = members[j];
                                String result = results[j];
                                if (!SetItemFunDef.matchMember(member, result)) continue block1;
                            }
                            return members;
                        }
                        return null;
                    }
                };
            }
            return new AbstractTupleCalc(call, calcs){

                public Member[] evaluateTuple(Evaluator evaluator) {
                    int listSize;
                    List list = listCalc.evaluateList(evaluator.push(false));
                    assert (list != null);
                    int index = indexCalc.evaluateInteger(evaluator);
                    if (index >= (listSize = list.size()) || index < 0) {
                        return nullTuple;
                    }
                    return (Member[])list.get(index);
                }
            };
        }
        MemberType memberType = (MemberType)elementType;
        final Member nullMember = SetItemFunDef.makeNullMember(memberType);
        if (isString) {
            return new AbstractMemberCalc(call, calcs){

                public Member evaluateMember(Evaluator evaluator) {
                    List list = listCalc.evaluateList(evaluator.push(false));
                    assert (list != null);
                    String result = stringCalcs[0].evaluateString(evaluator);
                    for (Member member : list) {
                        if (!SetItemFunDef.matchMember(member, result)) continue;
                        return member;
                    }
                    return nullMember;
                }
            };
        }
        return new AbstractMemberCalc(call, calcs){

            public Member evaluateMember(Evaluator evaluator) {
                int listSize;
                List list = listCalc.evaluateList(evaluator.push(false));
                assert (list != null);
                int index = indexCalc.evaluateInteger(evaluator);
                if (index >= (listSize = list.size()) || index < 0) {
                    return nullMember;
                }
                return (Member)list.get(index);
            }
        };
    }

    private static boolean matchMember(Member member, String name) {
        return member.getName().equals(name);
    }

    Object makeNullMember(Evaluator evaluator, Exp[] args) {
        Type elementType = ((SetType)args[0].getType()).getElementType();
        return this.makeNullMemberOrTuple(elementType);
    }

    Object makeNullMemberOrTuple(Type elementType) {
        if (elementType instanceof MemberType) {
            MemberType memberType = (MemberType)elementType;
            return SetItemFunDef.makeNullMember(memberType);
        }
        if (elementType instanceof TupleType) {
            return SetItemFunDef.makeNullTuple((TupleType)elementType);
        }
        throw Util.newInternal("bad type " + elementType);
    }
}

