/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.spi.impl;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.diff.DiffController;
import org.netbeans.api.diff.Difference;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.modules.refactoring.api.impl.SPIAccessor;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanel;
import org.netbeans.modules.refactoring.spi.impl.RefactoringPanelContainer;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.filesystems.FileObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class PreviewManager {
    private static PreviewManager manager;
    private WeakHashMap<RefactoringPanel, HashMap<FileObject, Pair>> map = new WeakHashMap();

    private PreviewManager() {
    }

    public static PreviewManager getDefault() {
        if (manager == null) {
            manager = new PreviewManager();
        }
        return manager;
    }

    public void clean(RefactoringPanel refactoringPanel) {
        this.map.remove(refactoringPanel);
    }

    private Pair getPair(SimpleRefactoringElementImplementation simpleRefactoringElementImplementation) {
        Object object;
        RefactoringPanel refactoringPanel = RefactoringPanelContainer.getRefactoringComponent().getCurrentPanel();
        HashMap<Object, Pair> hashMap = this.map.get(refactoringPanel);
        if (hashMap != null && (object = hashMap.get(simpleRefactoringElementImplementation.getParentFile())) != null) {
            return object;
        }
        try {
            object = new NewDiffSource(simpleRefactoringElementImplementation);
            DiffController diffController = DiffController.create((StreamSource)new OldDiffSource(simpleRefactoringElementImplementation), (StreamSource)object);
            if (hashMap == null) {
                hashMap = new HashMap();
                this.map.put(refactoringPanel, hashMap);
            }
            Pair pair = new Pair(diffController, (NewDiffSource)((Object)object));
            hashMap.put(simpleRefactoringElementImplementation.getParentFile(), pair);
            return pair;
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    public void refresh(SimpleRefactoringElementImplementation simpleRefactoringElementImplementation) {
        try {
            String string = SPIAccessor.DEFAULT.getNewFileContent(simpleRefactoringElementImplementation);
            if (string == null) {
                UI.setComponentForRefactoringPreview(null);
                return;
            }
            Pair pair = this.getPair(simpleRefactoringElementImplementation);
            UI.setComponentForRefactoringPreview(pair.dc.getJComponent());
            pair.source.setNewText(string);
            if (simpleRefactoringElementImplementation.getPosition() != null) {
                pair.dc.setLocation(DiffController.DiffPane.Base, DiffController.LocationType.LineNumber, simpleRefactoringElementImplementation.getPosition().getBegin().getLine());
            }
        }
        catch (IOException iOException) {
            throw (RuntimeException)new RuntimeException().initCause(iOException);
        }
    }

    private class NewDiffSource
    extends StreamSource {
        private SimpleRefactoringElementImplementation element;
        private Document internal;

        NewDiffSource(SimpleRefactoringElementImplementation simpleRefactoringElementImplementation) {
            this.element = simpleRefactoringElementImplementation;
        }

        public String getName() {
            return NbBundle.getMessage(PreviewManager.class, (String)"LBL_ProposedRefactoring");
        }

        public String getTitle() {
            if (this.element.getParentFile().isFolder()) {
                return NbBundle.getMessage(PreviewManager.class, (String)"LBL_NewFile");
            }
            return NbBundle.getMessage(PreviewManager.class, (String)"LBL_Refactored", (Object)this.element.getParentFile().getNameExt());
        }

        public String getMIMEType() {
            if (this.element.getParentFile().isFolder()) {
                return "text/x-java";
            }
            return this.element.getParentFile().getMIMEType();
        }

        public Reader createReader() throws IOException {
            return null;
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            return null;
        }

        private Document getDocument() {
            if (this.internal == null) {
                this.internal = CloneableEditorSupport.getEditorKit((String)this.getMIMEType()).createDefaultDocument();
            }
            return this.internal;
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.getDocument());
        }

        public void setNewText(String string) {
            try {
                this.internal.remove(0, this.internal.getLength());
                this.internal.insertString(0, string, null);
            }
            catch (BadLocationException badLocationException) {
                Logger.getLogger(((Object)((Object)this)).getClass().getName()).log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
        }
    }

    private class OldDiffSource
    extends StreamSource {
        private FileObject file;

        OldDiffSource(SimpleRefactoringElementImplementation simpleRefactoringElementImplementation) {
            this.file = simpleRefactoringElementImplementation.getParentFile();
        }

        public String getName() {
            if (this.file.isFolder()) {
                return NbBundle.getMessage(PreviewManager.class, (String)"LBL_FileDoesNotExist");
            }
            return this.file.getName();
        }

        public String getTitle() {
            if (this.file.isFolder()) {
                return NbBundle.getMessage(PreviewManager.class, (String)"LBL_FileDoesNotExist");
            }
            return this.file.getNameExt();
        }

        public String getMIMEType() {
            return this.file.getMIMEType();
        }

        public Reader createReader() throws IOException {
            return null;
        }

        public Writer createWriter(Difference[] differenceArray) throws IOException {
            return null;
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.file);
        }
    }

    private class Pair {
        DiffController dc;
        NewDiffSource source;

        Pair(DiffController diffController, NewDiffSource newDiffSource) {
            this.dc = diffController;
            this.source = newDiffSource;
        }
    }
}

