/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.olap;

import bsh.EvalError;
import bsh.Interpreter;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.MondrianConnection;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import mondrian.olap.Connection;
import mondrian.olap.Query;
import mondrian.olap.Result;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignParameter;
import org.apache.commons.beanutils.PropertyUtils;

public class OLAPQueryExecuter {
    private Interpreter interpreter = null;
    private List reportParameters = null;
    private String queryString = "";
    private HashMap queryParameters = new HashMap();

    public OLAPQueryExecuter(String queryStr, List reportParameters) {
        this.setQueryString(queryStr);
        this.setReportParameters(reportParameters);
    }

    public String prepareQuery() throws Exception {
        for (JRDesignParameter param : this.getReportParameters()) {
            Object paramVal;
            String expStr;
            String parameterName = param.getName();
            if (this.queryString.indexOf("$P!{" + parameterName + "}") > 0) {
                expStr = param.getDefaultValueExpression() == null ? "" : param.getDefaultValueExpression().getText();
                paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), expStr, this.getReportParameters());
                if (paramVal == null) {
                    paramVal = "";
                }
                this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
                continue;
            }
            if (this.getQueryString().indexOf("$P{" + parameterName + "}") <= 0) continue;
            expStr = param.getDefaultValueExpression() == null ? "" : param.getDefaultValueExpression().getText();
            paramVal = ReportQueryDialog.recursiveInterpreter(this.getInterpreter(), expStr, this.getReportParameters());
            if (paramVal == null) {
                paramVal = "";
            }
            this.queryString = Misc.string_replace("" + paramVal, "$P!{" + parameterName + "}", this.queryString);
        }
        return this.queryString;
    }

    private Interpreter prepareExpressionEvaluator() throws EvalError {
        Interpreter interpreter1 = new Interpreter();
        interpreter1.setClassLoader(interpreter1.getClass().getClassLoader());
        return interpreter1;
    }

    public Interpreter getInterpreter() {
        if (this.interpreter == null) {
            try {
                this.interpreter = this.prepareExpressionEvaluator();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.interpreter;
    }

    public void setInterpreter(Interpreter interpreter) {
        this.interpreter = interpreter;
    }

    public List getReportParameters() {
        return this.reportParameters;
    }

    public void setReportParameters(List reportParameters) {
        this.reportParameters = reportParameters;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public HashMap getQueryParameters() {
        return this.queryParameters;
    }

    public void setQueryParameters(HashMap queryParameters) {
        this.queryParameters = queryParameters;
    }

    public Query createOlapQuery() throws Exception {
        this.prepareQuery();
        try {
            Query query;
            IReportConnection conn = IReportManager.getInstance().getDefaultConnection();
            if (!(conn instanceof MondrianConnection)) {
                throw new Exception("No OLAP (Mondrian) connection selected.");
            }
            Connection mconn = ((MondrianConnection)conn).getMondrianConnection();
            if (mconn == null) {
                throw new Exception("The supplied mondrian.olap.Connection object is null.");
            }
            Query query2 = query = mconn.parseQuery(this.queryString);
            return query2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public Result executeOlapQuery() throws Exception {
        this.prepareQuery();
        try {
            Result result;
            IReportConnection conn = IReportManager.getInstance().getDefaultConnection();
            if (!(conn instanceof MondrianConnection)) {
                throw new Exception("No OLAP (Mondrian) connection selected.");
            }
            Connection mconn = ((MondrianConnection)conn).getMondrianConnection();
            if (mconn == null) {
                throw new Exception("The supplied mondrian.olap.Connection object is null.");
            }
            Query query = mconn.parseQuery(this.queryString);
            Result result2 = result = mconn.execute(query);
            return result2;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    public List getFields(Object obj) {
        ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
        PropertyDescriptor[] pd = PropertyUtils.getPropertyDescriptors(obj.getClass());
        for (int nd = 0; nd < pd.length; ++nd) {
            String fieldName = pd[nd].getName();
            if (pd[nd].getPropertyType() == null || pd[nd].getReadMethod() == null) continue;
            String returnType = pd[nd].getPropertyType().getName();
            JRDesignField field = new JRDesignField();
            field.setName(fieldName);
            field.setValueClassName(Misc.getJRFieldType(returnType));
            field.setDescription("");
            fields.add(field);
        }
        return fields;
    }
}

