/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.tools.JRHyperlinkParametersTableCellRenderer;
import com.jaspersoft.ireport.designer.tools.JRLinkParameterDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.lang.reflect.Method;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.JRAnchor;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.design.JRDesignHyperlink;
import net.sf.jasperreports.engine.design.JRDesignHyperlinkParameter;

public class HyperlinkPanel
extends JPanel {
    private JRHyperlink hyperlink = null;
    private ExpressionContext expressionContext = null;
    public static final String PROPERTY_HYPERLINK = "hyperlink";
    private boolean init = false;
    private JButton jButtonAddLinkParameter;
    private JButton jButtonClose;
    private JButton jButtonModLinkParameter;
    private JButton jButtonRemLinkParameter;
    private JComboBox jComboBoxLinkTarget;
    private JComboBox jComboBoxLinkType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel36;
    private JLabel jLabelAnchor;
    private JLabel jLabelPage;
    private JLabel jLabelReference;
    private JLabel jLabelReference1;
    private JLabel jLabelTarget;
    private JPanel jPanel1;
    private JPanel jPanel3;
    private JPanel jPanel4;
    private JPanel jPanelAnchor;
    private JPanel jPanelAnchorName;
    private JPanel jPanelClose;
    private JPanel jPanelLinkParams;
    private JPanel jPanelPage;
    private JPanel jPanelReference;
    private JPanel jPanelTooltip;
    private ExpressionEditorArea jRTextExpressionAreaAnchor;
    private ExpressionEditorArea jRTextExpressionAreaAnchorName;
    private ExpressionEditorArea jRTextExpressionAreaPage;
    private ExpressionEditorArea jRTextExpressionAreaReference;
    private ExpressionEditorArea jRTextExpressionAreaTooltip;
    private JScrollPane jScrollPane1;
    private JSeparator jSeparator1;
    private JSpinner jSpinnerBookmarkLevel;
    private JTabbedPane jTabbedPane2;
    private JTable jTableLinkParameters;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_HYPERLINK_REFERENCE_EXPRESSION = 2;
    public static final int COMPONENT_HYPERLINK_ANCHOR_EXPRESSION = 3;
    public static final int COMPONENT_HYPERLINK_PAGE_EXPRESSION = 4;
    public static final int COMPONENT_HYPERLINK_TOOLTIP_EXPRESSION = 5;
    public static final int COMPONENT_HYPERLINK_PARAMETERS = 6;
    public int openParameterWithThisExpression = -1;
    private JDialog dialog = null;

    public HyperlinkPanel() {
        this.initComponents();
        this.jPanelClose.setVisible(false);
        this.hyperlink = new JRDesignHyperlink();
        this.setInit(true);
        this.jComboBoxLinkType.addItem(new Tag("None"));
        this.jComboBoxLinkType.addItem(new Tag("Reference"));
        this.jComboBoxLinkType.addItem(new Tag("LocalAnchor"));
        this.jComboBoxLinkType.addItem(new Tag("LocalPage"));
        this.jComboBoxLinkType.addItem(new Tag("RemoteAnchor"));
        this.jComboBoxLinkType.addItem(new Tag("RemotePage"));
        for (Tag t : IReportManager.getInstance().getCustomLinkTypes()) {
            this.jComboBoxLinkType.addItem(t);
        }
        JRHyperlinkParametersTableCellRenderer cre = new JRHyperlinkParametersTableCellRenderer();
        this.jTableLinkParameters.getColumnModel().getColumn(0).setCellRenderer(cre);
        this.jTableLinkParameters.getColumnModel().getColumn(1).setCellRenderer(cre);
        this.jComboBoxLinkTarget.addItem(new Tag(new Byte(1), "Self"));
        this.jComboBoxLinkTarget.addItem(new Tag(new Byte(2), "Blank"));
        this.jComboBoxLinkTarget.addItem(new Tag(new Byte(4), "Top"));
        this.jComboBoxLinkTarget.addItem(new Tag(new Byte(3), "Parent"));
        this.jRTextExpressionAreaAnchor.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaAnchorTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaAnchorTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaAnchorTextChanged();
            }
        });
        this.jRTextExpressionAreaPage.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaPageTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaPageTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaPageTextChanged();
            }
        });
        this.jRTextExpressionAreaReference.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaReferenceTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaReferenceTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaReferenceTextChanged();
            }
        });
        this.jRTextExpressionAreaTooltip.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaTooltipTextChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaTooltipTextChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaTooltipTextChanged();
            }
        });
        this.jRTextExpressionAreaAnchorName.getExpressionEditorPane().getDocument().addDocumentListener(new DocumentListener(){

            public void changedUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaAnchorNameChanged();
            }

            public void insertUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaAnchorNameChanged();
            }

            public void removeUpdate(DocumentEvent evt) {
                HyperlinkPanel.this.jRTextExpressionAreaAnchorNameChanged();
            }
        });
        DefaultListSelectionModel dlsm = (DefaultListSelectionModel)this.jTableLinkParameters.getSelectionModel();
        dlsm.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                HyperlinkPanel.this.jTableLinkParametersListSelectionValueChanged(e);
            }
        });
        this.jPanelAnchorName.setVisible(false);
        this.jSpinnerBookmarkLevel.setModel(new SpinnerNumberModel(0, 0, 10000, 1));
        this.setInit(false);
    }

    private void fireHyperlinkChanged() {
        this.firePropertyChange(PROPERTY_HYPERLINK, null, this.getHyperlink());
    }

    public JRHyperlink getHyperlink() {
        if (this.hyperlink == null) {
            this.hyperlink = new JRDesignHyperlink();
        }
        return this.hyperlink;
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.jRTextExpressionAreaAnchorName.setExpressionContext(ec);
        this.jRTextExpressionAreaAnchor.setExpressionContext(ec);
        this.jRTextExpressionAreaReference.setExpressionContext(ec);
        this.jRTextExpressionAreaAnchor.setExpressionContext(ec);
        this.jRTextExpressionAreaPage.setExpressionContext(ec);
        this.jRTextExpressionAreaTooltip.setExpressionContext(ec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setHyperlink(JRHyperlink hlink) {
        try {
            this.setInit(true);
            try {
                this.hyperlink = hlink;
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (this.hyperlink != null) {
                if (JRHyperlinkHelper.getHyperlinkType((String)this.hyperlink.getLinkType()) != 7) {
                    Misc.setComboboxSelectedTagValue(this.jComboBoxLinkType, this.hyperlink.getLinkType());
                } else {
                    this.jComboBoxLinkType.setSelectedItem(this.hyperlink.getLinkType());
                }
                Misc.setComboboxSelectedTagValue(this.jComboBoxLinkTarget, new Byte(this.hyperlink.getHyperlinkTarget()));
                this.jRTextExpressionAreaReference.setText(Misc.getExpressionText(this.hyperlink.getHyperlinkReferenceExpression()));
                this.jRTextExpressionAreaAnchor.setText(Misc.getExpressionText(this.hyperlink.getHyperlinkAnchorExpression()));
                this.jRTextExpressionAreaPage.setText(Misc.getExpressionText(this.hyperlink.getHyperlinkPageExpression()));
                this.jRTextExpressionAreaTooltip.setText(Misc.getExpressionText(this.hyperlink.getHyperlinkTooltipExpression()));
            } else {
                this.hyperlink = this.getHyperlink();
            }
            if (this.hyperlink instanceof JRAnchor) {
                this.jPanelAnchorName.setVisible(true);
                this.jSpinnerBookmarkLevel.setValue(new Integer(((JRAnchor)this.hyperlink).getBookmarkLevel()));
                this.jRTextExpressionAreaAnchorName.setText(Misc.getExpressionText(((JRAnchor)this.hyperlink).getAnchorNameExpression()));
            } else {
                this.jPanelAnchorName.setVisible(false);
            }
            this.jTabbedPane2.removeAll();
            String linkType = this.hyperlink.getLinkType();
            if (linkType == null) {
                linkType = "None";
            }
            if (linkType.equals("None")) {
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
            } else if (linkType.equals("Reference")) {
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Link"), this.jPanelLinkParams);
            } else if (linkType.equals("LocalAnchor")) {
                this.jRTextExpressionAreaAnchor.setEnabled(true);
                this.jLabelAnchor.setEnabled(true);
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Anchor"), this.jPanelAnchor);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
            } else if (linkType.equals("LocalPage")) {
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setEnabled(true);
                this.jLabelPage.setEnabled(true);
                this.jRTextExpressionAreaReference.setEnabled(false);
                this.jLabelReference.setEnabled(false);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Page"), this.jPanelPage);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
            } else if (linkType.equals("RemoteAnchor")) {
                this.jRTextExpressionAreaAnchor.setEnabled(true);
                this.jLabelAnchor.setEnabled(true);
                this.jRTextExpressionAreaPage.setEnabled(false);
                this.jLabelPage.setEnabled(false);
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Anchor"), this.jPanelAnchor);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
            } else if (linkType.equals("RemotePage")) {
                this.jRTextExpressionAreaAnchor.setEnabled(false);
                this.jLabelAnchor.setEnabled(false);
                this.jRTextExpressionAreaPage.setEnabled(true);
                this.jLabelPage.setEnabled(true);
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Page"), this.jPanelPage);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
            } else {
                this.jRTextExpressionAreaAnchor.setEnabled(true);
                this.jLabelAnchor.setEnabled(true);
                this.jRTextExpressionAreaPage.setEnabled(true);
                this.jLabelPage.setEnabled(true);
                this.jRTextExpressionAreaReference.setEnabled(true);
                this.jLabelReference.setEnabled(true);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Anchor"), this.jPanelAnchor);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Page"), this.jPanelPage);
                this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
            }
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Tooltip"), this.jPanelTooltip);
            Iterator enum_parameters = this.getParametersList().iterator();
            DefaultTableModel dtmLinkParams = (DefaultTableModel)this.jTableLinkParameters.getModel();
            dtmLinkParams.setRowCount(0);
            while (enum_parameters.hasNext()) {
                JRDesignHyperlinkParameter parameter = (JRDesignHyperlinkParameter)enum_parameters.next();
                Vector<Object> row = new Vector<Object>();
                row.addElement(parameter);
                row.addElement(Misc.getExpressionText(parameter.getValueExpression()));
                dtmLinkParams.addRow(row);
            }
        }
        finally {
            this.setInit(false);
        }
    }

    public void jTableLinkParametersListSelectionValueChanged(ListSelectionEvent e) {
        if (this.jTableLinkParameters.getSelectedRowCount() > 0) {
            this.jButtonModLinkParameter.setEnabled(true);
            this.jButtonRemLinkParameter.setEnabled(true);
        } else {
            this.jButtonModLinkParameter.setEnabled(false);
            this.jButtonRemLinkParameter.setEnabled(false);
        }
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    private void initComponents() {
        this.jPanelAnchorName = new JPanel();
        this.jLabel1 = new JLabel();
        this.jRTextExpressionAreaAnchorName = new ExpressionEditorArea();
        this.jPanel4 = new JPanel();
        this.jLabel2 = new JLabel();
        this.jSpinnerBookmarkLevel = new JSpinner();
        this.jSeparator1 = new JSeparator();
        this.jLabelTarget = new JLabel();
        this.jComboBoxLinkTarget = new JComboBox();
        this.jLabel36 = new JLabel();
        this.jComboBoxLinkType = new JComboBox();
        this.jPanel1 = new JPanel();
        this.jTabbedPane2 = new JTabbedPane();
        this.jPanelReference = new JPanel();
        this.jLabelReference = new JLabel();
        this.jRTextExpressionAreaReference = new ExpressionEditorArea();
        this.jPanelAnchor = new JPanel();
        this.jLabelAnchor = new JLabel();
        this.jRTextExpressionAreaAnchor = new ExpressionEditorArea();
        this.jPanelPage = new JPanel();
        this.jLabelPage = new JLabel();
        this.jRTextExpressionAreaPage = new ExpressionEditorArea();
        this.jPanelLinkParams = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jTableLinkParameters = new JTable();
        this.jPanel3 = new JPanel();
        this.jButtonAddLinkParameter = new JButton();
        this.jButtonModLinkParameter = new JButton();
        this.jButtonRemLinkParameter = new JButton();
        this.jPanelTooltip = new JPanel();
        this.jLabelReference1 = new JLabel();
        this.jRTextExpressionAreaTooltip = new ExpressionEditorArea();
        this.jPanelClose = new JPanel();
        this.jButtonClose = new JButton();
        this.addComponentListener(new ComponentAdapter(){

            public void componentShown(ComponentEvent evt) {
                HyperlinkPanel.this.formComponentShown(evt);
            }
        });
        this.setLayout(new GridBagLayout());
        this.jPanelAnchorName.setMinimumSize(new Dimension(272, 116));
        this.jPanelAnchorName.setPreferredSize(new Dimension(426, 116));
        this.jPanelAnchorName.setLayout(new GridBagLayout());
        this.jLabel1.setText(I18n.getString("HyperlinkPanel.Label.AnchExpr"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 2, 4);
        this.jPanelAnchorName.add((Component)this.jLabel1, gridBagConstraints);
        this.jRTextExpressionAreaAnchorName.setMaximumSize(new Dimension(Integer.MAX_VALUE, 50));
        this.jRTextExpressionAreaAnchorName.setMinimumSize(new Dimension(48, 50));
        this.jRTextExpressionAreaAnchorName.setPreferredSize(new Dimension(133, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanelAnchorName.add((Component)this.jRTextExpressionAreaAnchorName, gridBagConstraints);
        this.jPanel4.setLayout(new GridBagLayout());
        this.jLabel2.setText(I18n.getString("HyperlinkPanel.Label.BookLev"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.jPanel4.add((Component)this.jLabel2, gridBagConstraints);
        this.jSpinnerBookmarkLevel.setPreferredSize(new Dimension(50, 20));
        this.jSpinnerBookmarkLevel.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                HyperlinkPanel.this.jSpinnerBookmarkLevelStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.jPanel4.add((Component)this.jSpinnerBookmarkLevel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.jPanelAnchorName.add((Component)this.jPanel4, gridBagConstraints);
        this.jSeparator1.setMinimumSize(new Dimension(2, 10));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.jPanelAnchorName.add((Component)this.jSeparator1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanelAnchorName, gridBagConstraints);
        this.jLabelTarget.setHorizontalAlignment(4);
        this.jLabelTarget.setText(I18n.getString("HyperlinkPanel.Label.HyperTarg"));
        this.jLabelTarget.setMaximumSize(new Dimension(200, 25));
        this.jLabelTarget.setMinimumSize(new Dimension(100, 20));
        this.jLabelTarget.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 22;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, 8, 5, 0);
        this.add((Component)this.jLabelTarget, gridBagConstraints);
        this.jComboBoxLinkTarget.setMinimumSize(new Dimension(180, 20));
        this.jComboBoxLinkTarget.setPreferredSize(new Dimension(180, 20));
        this.jComboBoxLinkTarget.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPanel.this.jComboBoxLinkTargetActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 6, 0, 2);
        this.add((Component)this.jComboBoxLinkTarget, gridBagConstraints);
        this.jLabel36.setHorizontalAlignment(4);
        this.jLabel36.setText(I18n.getString("HyperlinkPanel.Label.HypType"));
        this.jLabel36.setMaximumSize(new Dimension(200, 25));
        this.jLabel36.setMinimumSize(new Dimension(100, 20));
        this.jLabel36.setPreferredSize(new Dimension(100, 20));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 22;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 8, 5, 0);
        this.add((Component)this.jLabel36, gridBagConstraints);
        this.jComboBoxLinkType.setEditable(true);
        this.jComboBoxLinkType.setMinimumSize(new Dimension(180, 20));
        this.jComboBoxLinkType.setPreferredSize(new Dimension(180, 20));
        this.jComboBoxLinkType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPanel.this.jComboBoxLinkTypeActionPerformed1(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.add((Component)this.jComboBoxLinkType, gridBagConstraints);
        this.jPanel1.setMinimumSize(new Dimension(309, 150));
        this.jPanel1.setPreferredSize(new Dimension(309, 150));
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanelReference.setLayout(new GridBagLayout());
        this.jLabelReference.setHorizontalAlignment(2);
        this.jLabelReference.setText(I18n.getString("HyperlinkPanel.Label.HypRefExp"));
        this.jLabelReference.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelReference.add((Component)this.jLabelReference, gridBagConstraints);
        this.jRTextExpressionAreaReference.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaReference.setEnabled(false);
        this.jRTextExpressionAreaReference.setMinimumSize(new Dimension(300, 50));
        this.jRTextExpressionAreaReference.setPreferredSize(new Dimension(300, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelReference.add((Component)this.jRTextExpressionAreaReference, gridBagConstraints);
        this.jTabbedPane2.addTab("Reference", this.jPanelReference);
        this.jPanelAnchor.setLayout(new GridBagLayout());
        this.jLabelAnchor.setHorizontalAlignment(2);
        this.jLabelAnchor.setText(I18n.getString("HyperlinkPanel.Label.HypAnchExp"));
        this.jLabelAnchor.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelAnchor.add((Component)this.jLabelAnchor, gridBagConstraints);
        this.jRTextExpressionAreaAnchor.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaAnchor.setEnabled(false);
        this.jRTextExpressionAreaAnchor.setMinimumSize(new Dimension(300, 50));
        this.jRTextExpressionAreaAnchor.setPreferredSize(new Dimension(300, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelAnchor.add((Component)this.jRTextExpressionAreaAnchor, gridBagConstraints);
        this.jTabbedPane2.addTab("Anchor", this.jPanelAnchor);
        this.jPanelPage.setLayout(new GridBagLayout());
        this.jLabelPage.setHorizontalAlignment(2);
        this.jLabelPage.setText(I18n.getString("HyperlinkPanel.Label.hypPagExp"));
        this.jLabelPage.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelPage.add((Component)this.jLabelPage, gridBagConstraints);
        this.jRTextExpressionAreaPage.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaPage.setEnabled(false);
        this.jRTextExpressionAreaPage.setMinimumSize(new Dimension(300, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelPage.add((Component)this.jRTextExpressionAreaPage, gridBagConstraints);
        this.jTabbedPane2.addTab("Page", this.jPanelPage);
        this.jPanelLinkParams.setLayout(new GridBagLayout());
        this.jScrollPane1.setPreferredSize(new Dimension(300, 50));
        this.jTableLinkParameters.setModel(new DefaultTableModel(new Object[0][], new String[]{"Parameter name", "Expression"}){
            boolean[] canEdit;
            {
                this.canEdit = new boolean[]{false, false};
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTableLinkParameters.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                HyperlinkPanel.this.jTableLinkParametersMouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTableLinkParameters);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanelLinkParams.add((Component)this.jScrollPane1, gridBagConstraints);
        this.jPanel3.setLayout(new GridBagLayout());
        this.jButtonAddLinkParameter.setText(I18n.getString("Global.Button.Add"));
        this.jButtonAddLinkParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPanel.this.jButtonAddLinkParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 6, 0);
        this.jPanel3.add((Component)this.jButtonAddLinkParameter, gridBagConstraints);
        this.jButtonModLinkParameter.setText(I18n.getString("Global.Button.Modify"));
        this.jButtonModLinkParameter.setEnabled(false);
        this.jButtonModLinkParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPanel.this.jButtonModLinkParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 6, 0);
        this.jPanel3.add((Component)this.jButtonModLinkParameter, gridBagConstraints);
        this.jButtonRemLinkParameter.setText(I18n.getString("Global.Button.Remove"));
        this.jButtonRemLinkParameter.setEnabled(false);
        this.jButtonRemLinkParameter.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPanel.this.jButtonRemLinkParameterActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 6, 6, 0);
        this.jPanel3.add((Component)this.jButtonRemLinkParameter, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 6, 0, 6);
        this.jPanelLinkParams.add((Component)this.jPanel3, gridBagConstraints);
        this.jTabbedPane2.addTab("Link parameters", this.jPanelLinkParams);
        this.jPanelTooltip.setLayout(new GridBagLayout());
        this.jLabelReference1.setHorizontalAlignment(2);
        this.jLabelReference1.setText(I18n.getString("HyperlinkPanel.Pane.TooltipExp"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelTooltip.add((Component)this.jLabelReference1, gridBagConstraints);
        this.jRTextExpressionAreaTooltip.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaTooltip.setMinimumSize(new Dimension(300, 50));
        this.jRTextExpressionAreaTooltip.setPreferredSize(new Dimension(300, 50));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        this.jPanelTooltip.add((Component)this.jRTextExpressionAreaTooltip, gridBagConstraints);
        this.jTabbedPane2.addTab("Tooltip", this.jPanelTooltip);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel1.add((Component)this.jTabbedPane2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 9;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.jPanelClose.setLayout(new GridBagLayout());
        this.jButtonClose.setText(I18n.getString("Global.Button.Close"));
        this.jButtonClose.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                HyperlinkPanel.this.jButtonCloseActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 8);
        this.jPanelClose.add((Component)this.jButtonClose, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 1;
        this.add((Component)this.jPanelClose, gridBagConstraints);
    }

    private void formComponentShown(ComponentEvent evt) {
    }

    private void jTableLinkParametersMouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2) {
            if (evt.getButton() == 1 && this.jTableLinkParameters.getSelectedRowCount() > 0) {
                this.jButtonModLinkParameterActionPerformed(null);
            }
        }
    }

    private void jButtonRemLinkParameterActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        DefaultTableModel dtm = (DefaultTableModel)this.jTableLinkParameters.getModel();
        int[] rows = this.jTableLinkParameters.getSelectedRows();
        for (int i = rows.length - 1; i >= 0; --i) {
            this.getParametersList().remove(this.jTableLinkParameters.getValueAt(rows[i], 0));
            dtm.removeRow(rows[i]);
        }
        IReportManager.getInstance().notifyReportChange();
    }

    private void jButtonModLinkParameterActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        if (this.jTableLinkParameters.getSelectedRowCount() <= 0) {
            return;
        }
        JRDesignHyperlinkParameter parameter = (JRDesignHyperlinkParameter)this.jTableLinkParameters.getValueAt(this.jTableLinkParameters.getSelectedRow(), 0);
        JRLinkParameterDialog jrpd = new JRLinkParameterDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        jrpd.setExpressionContext(this.getExpressionContext());
        jrpd.setParameter(parameter);
        if (evt != null && evt.getID() > 0) {
            jrpd.setFocusedExpression(evt.getID());
        }
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            parameter.setName(jrpd.getParameter().getName());
            parameter.setValueExpression(jrpd.getParameter().getValueExpression());
            DefaultTableModel dtm = (DefaultTableModel)this.jTableLinkParameters.getModel();
            dtm.setValueAt(parameter, this.jTableLinkParameters.getSelectedRow(), 0);
            dtm.setValueAt(Misc.getExpressionText(parameter.getValueExpression()), this.jTableLinkParameters.getSelectedRow(), 1);
            this.jTableLinkParameters.updateUI();
            IReportManager.getInstance().notifyReportChange();
        }
        this.fireHyperlinkChanged();
    }

    private void jButtonAddLinkParameterActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        JRLinkParameterDialog jrpd = new JRLinkParameterDialog((Dialog)((JDialog)SwingUtilities.getWindowAncestor(this)), true);
        jrpd.setVisible(true);
        if (jrpd.getDialogResult() == 0) {
            JRDesignHyperlinkParameter parameter = jrpd.getParameter();
            this.getParametersList().add(parameter);
            DefaultTableModel dtm = (DefaultTableModel)this.jTableLinkParameters.getModel();
            dtm.addRow(new Object[]{parameter, Misc.getExpressionText(parameter.getValueExpression())});
            IReportManager.getInstance().notifyReportChange();
        }
        this.fireHyperlinkChanged();
    }

    private void jComboBoxLinkTypeActionPerformed1(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        this.jTabbedPane2.removeAll();
        Object val = this.jComboBoxLinkType.getSelectedItem();
        String linkType = "None";
        if (val != null) {
            if (val instanceof Tag) {
                val = "" + ((Tag)val).getValue();
            }
            linkType = "" + val;
        }
        if (linkType.equals("None")) {
            this.setHyperlinkAttribute("LinkType", String.class, linkType);
            this.setHyperlinkAttribute("HyperlinkReferenceExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkAnchorExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkPageExpression", JRExpression.class, null);
            this.getParametersList().clear();
            this.jRTextExpressionAreaAnchor.setText("");
            this.jRTextExpressionAreaAnchor.setEnabled(false);
            this.jLabelAnchor.setEnabled(false);
            this.jRTextExpressionAreaPage.setText("");
            this.jRTextExpressionAreaPage.setEnabled(false);
            this.jLabelPage.setEnabled(false);
            this.jRTextExpressionAreaReference.setText("");
            this.jRTextExpressionAreaReference.setEnabled(false);
            this.jLabelReference.setEnabled(false);
        } else if (linkType.equals("Reference")) {
            this.setHyperlinkAttribute("LinkType", String.class, linkType);
            this.setHyperlinkAttribute("HyperlinkReferenceExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkAnchorExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkPageExpression", JRExpression.class, null);
            this.jRTextExpressionAreaAnchor.setText(null);
            this.jRTextExpressionAreaAnchor.setEnabled(false);
            this.jLabelAnchor.setEnabled(false);
            this.jRTextExpressionAreaPage.setText("");
            this.jRTextExpressionAreaPage.setEnabled(false);
            this.jLabelPage.setEnabled(false);
            this.jRTextExpressionAreaReference.setText("");
            this.jRTextExpressionAreaReference.setEnabled(true);
            this.jLabelReference.setEnabled(true);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
        } else if (linkType.equals("LocalAnchor")) {
            this.setHyperlinkAttribute("LinkType", String.class, linkType);
            this.setHyperlinkAttribute("HyperlinkReferenceExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkAnchorExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkPageExpression", JRExpression.class, null);
            this.jRTextExpressionAreaAnchor.setText("");
            this.jRTextExpressionAreaAnchor.setEnabled(true);
            this.jLabelAnchor.setEnabled(true);
            this.jRTextExpressionAreaPage.setText("");
            this.jRTextExpressionAreaPage.setEnabled(false);
            this.jLabelPage.setEnabled(false);
            this.jRTextExpressionAreaReference.setText("");
            this.jRTextExpressionAreaReference.setEnabled(false);
            this.jLabelReference.setEnabled(false);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Anchor"), this.jPanelAnchor);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
        } else if (linkType.equals("LocalPage")) {
            this.setHyperlinkAttribute("LinkType", String.class, linkType);
            this.setHyperlinkAttribute("HyperlinkReferenceExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkAnchorExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkPageExpression", JRExpression.class, null);
            this.jRTextExpressionAreaAnchor.setText("");
            this.jRTextExpressionAreaAnchor.setEnabled(false);
            this.jLabelAnchor.setEnabled(false);
            this.jRTextExpressionAreaPage.setText("");
            this.jRTextExpressionAreaPage.setEnabled(true);
            this.jLabelPage.setEnabled(true);
            this.jRTextExpressionAreaReference.setText("");
            this.jRTextExpressionAreaReference.setEnabled(false);
            this.jLabelReference.setEnabled(false);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Page"), this.jPanelPage);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
        } else if (linkType.equals("RemoteAnchor")) {
            this.setHyperlinkAttribute("LinkType", String.class, linkType);
            this.setHyperlinkAttribute("HyperlinkReferenceExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkAnchorExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkPageExpression", JRExpression.class, null);
            this.jRTextExpressionAreaAnchor.setText("");
            this.jRTextExpressionAreaAnchor.setEnabled(true);
            this.jLabelAnchor.setEnabled(true);
            this.jRTextExpressionAreaPage.setText("");
            this.jRTextExpressionAreaPage.setEnabled(false);
            this.jLabelPage.setEnabled(false);
            this.jRTextExpressionAreaReference.setText("");
            this.jRTextExpressionAreaReference.setEnabled(true);
            this.jLabelReference.setEnabled(true);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Anchor"), this.jPanelAnchor);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
        } else if (linkType.equals("RemotePage")) {
            this.setHyperlinkAttribute("LinkType", String.class, linkType);
            this.setHyperlinkAttribute("HyperlinkReferenceExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkAnchorExpression", JRExpression.class, null);
            this.setHyperlinkAttribute("HyperlinkPageExpression", JRExpression.class, null);
            this.jRTextExpressionAreaAnchor.setText("");
            this.jRTextExpressionAreaAnchor.setEnabled(false);
            this.jLabelAnchor.setEnabled(false);
            this.jRTextExpressionAreaPage.setText("");
            this.jRTextExpressionAreaPage.setEnabled(true);
            this.jLabelPage.setEnabled(true);
            this.jRTextExpressionAreaReference.setText("");
            this.jRTextExpressionAreaReference.setEnabled(true);
            this.jLabelReference.setEnabled(true);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Page"), this.jPanelPage);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
        } else {
            this.setHyperlinkAttribute("LinkType", String.class, linkType);
            this.jRTextExpressionAreaAnchor.setEnabled(true);
            this.jLabelAnchor.setEnabled(true);
            this.jRTextExpressionAreaPage.setEnabled(true);
            this.jLabelPage.setEnabled(true);
            this.jRTextExpressionAreaReference.setEnabled(true);
            this.jLabelReference.setEnabled(true);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Panel.Reference"), this.jPanelReference);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Anchor"), this.jPanelAnchor);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Page"), this.jPanelPage);
            this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.LinkParam"), this.jPanelLinkParams);
        }
        this.jTabbedPane2.addTab(I18n.getString("HyperlinkPanel.Pane.Tooltip"), this.jPanelTooltip);
        this.fireHyperlinkChanged();
    }

    private void jComboBoxLinkTargetActionPerformed1(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        this.setHyperlinkAttribute("HyperlinkTarget", Byte.TYPE, (Byte)((Tag)this.jComboBoxLinkTarget.getSelectedItem()).getValue());
        this.fireHyperlinkChanged();
    }

    private void jButtonCloseActionPerformed(ActionEvent evt) {
        if (this.dialog != null && this.dialog.isVisible()) {
            this.dialog.setVisible(false);
            this.dialog.dispose();
        }
    }

    private void jSpinnerBookmarkLevelStateChanged(ChangeEvent evt) {
        if (this.isInit()) {
            return;
        }
        int level = (Integer)this.jSpinnerBookmarkLevel.getValue();
        Integer val = new Integer(level);
        this.setHyperlinkAttribute("BookmarkLevel", Integer.TYPE, val);
        this.fireHyperlinkChanged();
    }

    public void jRTextExpressionAreaTooltipTextChanged() {
        if (this.isInit()) {
            return;
        }
        this.setHyperlinkAttribute("HyperlinkTooltipExpression", JRExpression.class, Misc.createExpression("java.lang.String", this.jRTextExpressionAreaTooltip.getText()));
        this.fireHyperlinkChanged();
    }

    public void jRTextExpressionAreaAnchorNameChanged() {
        if (this.isInit()) {
            return;
        }
        this.setHyperlinkAttribute("AnchorNameExpression", JRExpression.class, Misc.createExpression("java.lang.String", this.jRTextExpressionAreaAnchorName.getText()));
        this.fireHyperlinkChanged();
    }

    public void jRTextExpressionAreaReferenceTextChanged() {
        if (this.isInit()) {
            return;
        }
        this.setHyperlinkAttribute("HyperlinkReferenceExpression", JRExpression.class, Misc.createExpression("java.lang.String", this.jRTextExpressionAreaReference.getText()));
        this.fireHyperlinkChanged();
    }

    public void jRTextExpressionAreaAnchorTextChanged() {
        if (this.isInit()) {
            return;
        }
        this.setHyperlinkAttribute("HyperlinkAnchorExpression", JRExpression.class, Misc.createExpression("java.lang.String", this.jRTextExpressionAreaAnchor.getText()));
        this.fireHyperlinkChanged();
    }

    public void jRTextExpressionAreaPageTextChanged() {
        if (this.isInit()) {
            return;
        }
        this.setHyperlinkAttribute("HyperlinkPageExpression", JRExpression.class, Misc.createExpression("java.lang.String", this.jRTextExpressionAreaPage.getText()));
        this.fireHyperlinkChanged();
    }

    public void setFocusedExpression(Object[] expressionInfo) {
        int expID = (Integer)expressionInfo[0];
        try {
            switch (expID) {
                case 2: {
                    this.jTabbedPane2.setSelectedComponent(this.jPanelReference);
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaReference);
                    break;
                }
                case 3: {
                    this.jTabbedPane2.setSelectedComponent(this.jPanelAnchor);
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaAnchor);
                    break;
                }
                case 4: {
                    this.jTabbedPane2.setSelectedComponent(this.jPanelPage);
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaPage);
                    break;
                }
                case 5: {
                    this.jTabbedPane2.setSelectedComponent(this.jPanelTooltip);
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaTooltip);
                    break;
                }
                case 6: {
                    this.jTabbedPane2.setSelectedComponent(this.jPanelLinkParams);
                    int paramIdex = (Integer)expressionInfo[1];
                    int paramExpId = (Integer)expressionInfo[2];
                    if (paramIdex < 0 || this.jTableLinkParameters.getRowCount() <= paramIdex) break;
                    this.jTableLinkParameters.setRowSelectionInterval(paramIdex, paramIdex);
                    this.openParameterWithThisExpression = paramExpId;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void openExtraWindows() {
        if (this.openParameterWithThisExpression >= 0) {
            this.jButtonModLinkParameterActionPerformed(new ActionEvent(this.jButtonModLinkParameter, this.openParameterWithThisExpression, ""));
        }
        this.openParameterWithThisExpression = -1;
    }

    public ExpressionContext getExpressionContext() {
        return this.expressionContext;
    }

    public void showDialog(Component parent) {
        this.jPanelClose.setVisible(true);
        this.dialog = new JDialog(Misc.getMainFrame(), true);
        this.dialog.getContentPane().add(this);
        this.dialog.pack();
        this.dialog.setDefaultCloseOperation(2);
        this.dialog.setLocationRelativeTo(null);
        this.dialog.setTitle(I18n.getString("HyperlinkPanel.Dialog.Title"));
        this.dialog.setVisible(true);
    }

    private List getParametersList() {
        if (this.hyperlink == null) {
            return null;
        }
        try {
            Method m = this.hyperlink.getClass().getMethod("getHyperlinkParametersList", new Class[0]);
            return (List)m.invoke((Object)this.hyperlink, new Object[0]);
        }
        catch (Throwable t) {
            t.printStackTrace();
            return null;
        }
    }

    private void setHyperlinkAttribute(String attribute, Class clazz, Object value) {
        if (this.hyperlink == null) {
            return;
        }
        try {
            Method m = this.hyperlink.getClass().getMethod("set" + attribute, clazz);
            m.invoke((Object)this.hyperlink, value);
            IReportManager.getInstance().notifyReportChange();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    public void setAnchorNameVisible(boolean b) {
        this.jPanelAnchorName.setVisible(b);
    }
}

