/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlPreviewView;
import com.jaspersoft.ireport.designer.templates.TemplateRenderer;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyListener;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.lang.reflect.Constructor;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.filechooser.FileFilter;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperPrintManager;
import net.sf.jasperreports.engine.export.JRGraphics2DExporter;
import net.sf.jasperreports.engine.export.JRGraphics2DExporterParameter;
import net.sf.jasperreports.engine.util.JRClassLoader;
import net.sf.jasperreports.swing.JRViewerController;
import net.sf.jasperreports.swing.JRViewerEvent;
import net.sf.jasperreports.swing.JRViewerListener;
import net.sf.jasperreports.view.JRSaveContributor;
import net.sf.jasperreports.view.save.JRPrintSaveContributor;

public class JrxmlPreviewToolbar
extends JToolBar
implements JRViewerListener {
    private JrxmlPreviewView view = null;
    private final JRViewerController viewerContext;
    protected float MIN_ZOOM = 0.5f;
    protected float MAX_ZOOM = 10.0f;
    protected int[] zooms = new int[]{50, 75, 100, 125, 150, 175, 200, 250, 400, 800};
    protected int defaultZoomIndex = 2;
    protected List saveContributors = new ArrayList();
    protected File lastFolder = null;
    protected JRSaveContributor lastSaveContributor = null;
    protected DecimalFormat zoomDecimalFormat = new DecimalFormat("#.##");
    private JToggleButton btnActualSize;
    private JButton btnFirst;
    private JToggleButton btnFitPage;
    private JToggleButton btnFitWidth;
    private JButton btnLast;
    private JButton btnNext;
    private JButton btnPrevious;
    private JButton btnPrint;
    private JButton btnRefresh;
    private JButton btnSave;
    private JButton btnZoomIn;
    private JButton btnZoomOut;
    private JComboBox cmbZoom;
    private JButton jButton1;
    private JToolBar.Separator jSeparator1;
    private JToolBar.Separator jSeparator2;
    private JToolBar.Separator jSeparator3;
    private JToolBar.Separator jSeparator4;
    private JTextField txtGoTo;

    public JrxmlPreviewToolbar(JrxmlPreviewView view, JRViewerController viewerContext) {
        this.viewerContext = viewerContext;
        this.viewerContext.addListener((JRViewerListener)this);
        this.initComponents();
        this.initSaveContributors();
        this.view = view;
        this.btnSave.setText(I18n.getString("JrxmlPreviewToolbar.btnSave.text"));
        this.btnSave.setToolTipText(I18n.getString("JrxmlPreviewToolbar.btnSave.toolTipText"));
        this.btnPrint.setText(I18n.getString("JrxmlPreviewToolbar.btnPrint.text"));
        this.btnPrint.setToolTipText(I18n.getString("JrxmlPreviewToolbar.btnPrint.toolTipText"));
        this.btnActualSize.setText(I18n.getString("JrxmlPreviewToolbar.btnActualSize.text"));
        this.btnFitPage.setText(I18n.getString("JrxmlPreviewToolbar.btnFitPage.text"));
        this.btnFitPage.setToolTipText(I18n.getString("JrxmlPreviewToolbar.btnFitPage.toolTipText"));
        this.btnFitWidth.setText(I18n.getString("JrxmlPreviewToolbar.btnFitWidth.text"));
        this.btnFitWidth.setToolTipText(I18n.getString("JrxmlPreviewToolbar.btnFitWidth.toolTipText"));
        this.btnZoomIn.setText(I18n.getString("JrxmlPreviewToolbar.btnZoomIn.text"));
        this.btnZoomIn.setToolTipText(I18n.getString("JrxmlPreviewToolbar.btnZoomIn.toolTipText"));
        this.btnZoomOut.setText(I18n.getString("JrxmlPreviewToolbar.btnZoomOut.text"));
        this.btnZoomOut.setToolTipText(I18n.getString("JrxmlPreviewToolbar.btnZoomOut.toolTipText"));
    }

    private void initComponents() {
        this.jSeparator1 = new JToolBar.Separator();
        this.btnRefresh = new JButton();
        this.btnSave = new JButton();
        this.btnPrint = new JButton();
        this.jSeparator2 = new JToolBar.Separator();
        this.btnFirst = new JButton();
        this.btnPrevious = new JButton();
        this.btnNext = new JButton();
        this.btnLast = new JButton();
        this.txtGoTo = new JTextField();
        this.jSeparator3 = new JToolBar.Separator();
        this.btnActualSize = new JToggleButton();
        this.btnFitPage = new JToggleButton();
        this.btnFitWidth = new JToggleButton();
        this.btnZoomIn = new JButton();
        this.btnZoomOut = new JButton();
        this.cmbZoom = new JComboBox();
        this.jSeparator4 = new JToolBar.Separator();
        this.jButton1 = new JButton();
        this.setBorder(null);
        this.setRollover(true);
        this.add(this.jSeparator1);
        this.btnRefresh.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/refresh-16.png")));
        this.btnRefresh.setToolTipText("Run again");
        this.btnRefresh.setFocusable(false);
        this.btnRefresh.setHorizontalTextPosition(0);
        this.btnRefresh.setMaximumSize(new Dimension(23, 23));
        this.btnRefresh.setMinimumSize(new Dimension(23, 23));
        this.btnRefresh.setPreferredSize(new Dimension(23, 23));
        this.btnRefresh.setVerticalTextPosition(3);
        this.btnRefresh.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnRefreshActionPerformed(evt);
            }
        });
        this.add(this.btnRefresh);
        this.btnSave.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/save.GIF")));
        this.btnSave.setFocusable(false);
        this.btnSave.setHorizontalTextPosition(0);
        this.btnSave.setMaximumSize(new Dimension(23, 23));
        this.btnSave.setMinimumSize(new Dimension(23, 23));
        this.btnSave.setPreferredSize(new Dimension(23, 23));
        this.btnSave.setVerticalTextPosition(3);
        this.btnSave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnSaveActionPerformed(evt);
            }
        });
        this.add(this.btnSave);
        this.btnPrint.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/print.GIF")));
        this.btnPrint.setFocusable(false);
        this.btnPrint.setHorizontalTextPosition(0);
        this.btnPrint.setMaximumSize(new Dimension(23, 23));
        this.btnPrint.setMinimumSize(new Dimension(23, 23));
        this.btnPrint.setPreferredSize(new Dimension(23, 23));
        this.btnPrint.setVerticalTextPosition(3);
        this.btnPrint.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnPrintActionPerformed(evt);
            }
        });
        this.add(this.btnPrint);
        this.add(this.jSeparator2);
        this.btnFirst.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/first.GIF")));
        this.btnFirst.setFocusable(false);
        this.btnFirst.setHorizontalTextPosition(0);
        this.btnFirst.setMaximumSize(new Dimension(23, 23));
        this.btnFirst.setMinimumSize(new Dimension(23, 23));
        this.btnFirst.setPreferredSize(new Dimension(23, 23));
        this.btnFirst.setVerticalTextPosition(3);
        this.btnFirst.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnFirstActionPerformed(evt);
            }
        });
        this.add(this.btnFirst);
        this.btnPrevious.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/previous.GIF")));
        this.btnPrevious.setFocusable(false);
        this.btnPrevious.setHorizontalTextPosition(0);
        this.btnPrevious.setMaximumSize(new Dimension(23, 23));
        this.btnPrevious.setMinimumSize(new Dimension(23, 23));
        this.btnPrevious.setPreferredSize(new Dimension(23, 23));
        this.btnPrevious.setVerticalTextPosition(3);
        this.btnPrevious.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnPreviousActionPerformed(evt);
            }
        });
        this.add(this.btnPrevious);
        this.btnNext.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/next.GIF")));
        this.btnNext.setFocusable(false);
        this.btnNext.setHorizontalTextPosition(0);
        this.btnNext.setMaximumSize(new Dimension(23, 23));
        this.btnNext.setMinimumSize(new Dimension(23, 23));
        this.btnNext.setPreferredSize(new Dimension(23, 23));
        this.btnNext.setVerticalTextPosition(3);
        this.btnNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnNextActionPerformed(evt);
            }
        });
        this.add(this.btnNext);
        this.btnLast.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/last.GIF")));
        this.btnLast.setFocusable(false);
        this.btnLast.setHorizontalTextPosition(0);
        this.btnLast.setMaximumSize(new Dimension(23, 23));
        this.btnLast.setMinimumSize(new Dimension(23, 23));
        this.btnLast.setPreferredSize(new Dimension(23, 23));
        this.btnLast.setVerticalTextPosition(3);
        this.btnLast.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnLastActionPerformed(evt);
            }
        });
        this.add(this.btnLast);
        this.txtGoTo.setHorizontalAlignment(4);
        this.txtGoTo.setMaximumSize(new Dimension(40, Integer.MAX_VALUE));
        this.txtGoTo.setMinimumSize(new Dimension(40, 20));
        this.txtGoTo.setPreferredSize(new Dimension(40, 20));
        this.txtGoTo.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.txtGoToActionPerformed(evt);
            }
        });
        this.add(this.txtGoTo);
        this.add(this.jSeparator3);
        this.btnActualSize.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/actualsize.GIF")));
        this.btnActualSize.setFocusable(false);
        this.btnActualSize.setHorizontalTextPosition(0);
        this.btnActualSize.setMaximumSize(new Dimension(23, 23));
        this.btnActualSize.setMinimumSize(new Dimension(23, 23));
        this.btnActualSize.setPreferredSize(new Dimension(23, 23));
        this.btnActualSize.setVerticalTextPosition(3);
        this.btnActualSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnActualSizeActionPerformed(evt);
            }
        });
        this.add(this.btnActualSize);
        this.btnFitPage.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/fitpage.GIF")));
        this.btnFitPage.setFocusable(false);
        this.btnFitPage.setHorizontalTextPosition(0);
        this.btnFitPage.setMaximumSize(new Dimension(23, 23));
        this.btnFitPage.setMinimumSize(new Dimension(23, 23));
        this.btnFitPage.setPreferredSize(new Dimension(23, 23));
        this.btnFitPage.setVerticalTextPosition(3);
        this.btnFitPage.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnFitPageActionPerformed(evt);
            }
        });
        this.add(this.btnFitPage);
        this.btnFitWidth.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/fitwidth.GIF")));
        this.btnFitWidth.setFocusable(false);
        this.btnFitWidth.setHorizontalTextPosition(0);
        this.btnFitWidth.setMaximumSize(new Dimension(23, 23));
        this.btnFitWidth.setMinimumSize(new Dimension(23, 23));
        this.btnFitWidth.setPreferredSize(new Dimension(23, 23));
        this.btnFitWidth.setVerticalTextPosition(3);
        this.btnFitWidth.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnFitWidthActionPerformed(evt);
            }
        });
        this.add(this.btnFitWidth);
        this.btnZoomIn.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/zoomin-16.png")));
        this.btnZoomIn.setFocusable(false);
        this.btnZoomIn.setHorizontalTextPosition(0);
        this.btnZoomIn.setMaximumSize(new Dimension(23, 23));
        this.btnZoomIn.setMinimumSize(new Dimension(23, 23));
        this.btnZoomIn.setPreferredSize(new Dimension(23, 23));
        this.btnZoomIn.setVerticalTextPosition(3);
        this.btnZoomIn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnZoomInActionPerformed(evt);
            }
        });
        this.add(this.btnZoomIn);
        this.btnZoomOut.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/zoomout-16.png")));
        this.btnZoomOut.setFocusable(false);
        this.btnZoomOut.setHorizontalTextPosition(0);
        this.btnZoomOut.setMaximumSize(new Dimension(23, 23));
        this.btnZoomOut.setMinimumSize(new Dimension(23, 23));
        this.btnZoomOut.setPreferredSize(new Dimension(23, 23));
        this.btnZoomOut.setVerticalTextPosition(3);
        this.btnZoomOut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.btnZoomOutActionPerformed(evt);
            }
        });
        this.add(this.btnZoomOut);
        this.cmbZoom.setEditable(true);
        this.cmbZoom.setModel(this.getZoomComboBoxModel());
        this.cmbZoom.setMaximumSize(new Dimension(70, Short.MAX_VALUE));
        this.cmbZoom.setMinimumSize(new Dimension(70, 20));
        this.cmbZoom.setPreferredSize(new Dimension(70, 22));
        this.cmbZoom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                JrxmlPreviewToolbar.this.cmbZoomItemStateChanged(evt);
            }
        });
        this.cmbZoom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.cmbZoomActionPerformed(evt);
            }
        });
        this.add(this.cmbZoom);
        this.add(this.jSeparator4);
        this.jButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/template_preview.png")));
        this.jButton1.setToolTipText("Create a preview image");
        this.jButton1.setFocusable(false);
        this.jButton1.setHorizontalTextPosition(0);
        this.jButton1.setVerticalTextPosition(3);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JrxmlPreviewToolbar.this.jButton1ActionPerformed(evt);
            }
        });
        this.add(this.jButton1);
    }

    private DefaultComboBoxModel getZoomComboBoxModel() {
        DefaultComboBoxModel<String> model = new DefaultComboBoxModel<String>();
        for (int i = 0; i < this.zooms.length; ++i) {
            model.addElement("" + this.zooms[i] + "%");
        }
        return model;
    }

    private void btnRefreshActionPerformed(ActionEvent evt) {
        this.getView().setNeedRefresh(true);
        this.getView().componentShowing();
    }

    private void btnZoomInActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index < 0) {
            this.getViewerContext().setZoomRatio((float)this.zooms[-index - 1] / 100.0f);
        } else if (index < this.cmbZoom.getModel().getSize() - 1) {
            this.getViewerContext().setZoomRatio((float)this.zooms[index + 1] / 100.0f);
        }
    }

    private void btnZoomOutActionPerformed(ActionEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
        int newZoomInt = (int)(100.0f * this.getZoomRatio());
        int index = Arrays.binarySearch(this.zooms, newZoomInt);
        if (index > 0) {
            this.getViewerContext().setZoomRatio((float)this.zooms[index - 1] / 100.0f);
        } else if (index < -1) {
            this.getViewerContext().setZoomRatio((float)this.zooms[-index - 2] / 100.0f);
        }
    }

    private void btnFirstActionPerformed(ActionEvent evt) {
        this.getViewerContext().setPageIndex(0);
        this.getViewerContext().refreshPage();
    }

    private void btnPreviousActionPerformed(ActionEvent evt) {
        this.getViewerContext().setPageIndex(this.getViewerContext().getPageIndex() - 1);
        this.getViewerContext().refreshPage();
    }

    private void btnNextActionPerformed(ActionEvent evt) {
        this.getViewerContext().setPageIndex(this.getViewerContext().getPageIndex() + 1);
        this.getViewerContext().refreshPage();
    }

    private void btnLastActionPerformed(ActionEvent evt) {
        this.getViewerContext().setPageIndex(this.getViewerContext().getPageCount() - 1);
        this.getViewerContext().refreshPage();
    }

    private void txtGoToActionPerformed(ActionEvent evt) {
        try {
            int pageNumber = Integer.parseInt(this.txtGoTo.getText());
            if (pageNumber != this.getViewerContext().getPageIndex() + 1 && pageNumber > 0 && pageNumber <= this.getViewerContext().getPageCount()) {
                this.getViewerContext().setPageIndex(pageNumber - 1);
                this.getViewerContext().refreshPage();
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void btnSaveActionPerformed(ActionEvent evt) {
        int retValue;
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setLocale(this.getLocale());
        fileChooser.updateUI();
        for (int i = 0; i < this.saveContributors.size(); ++i) {
            fileChooser.addChoosableFileFilter((FileFilter)((JRSaveContributor)this.saveContributors.get(i)));
        }
        if (this.saveContributors.contains(this.lastSaveContributor)) {
            fileChooser.setFileFilter((FileFilter)this.lastSaveContributor);
        } else if (this.saveContributors.size() > 0) {
            fileChooser.setFileFilter((FileFilter)((JRSaveContributor)this.saveContributors.get(0)));
        }
        if (this.lastFolder != null) {
            fileChooser.setCurrentDirectory(this.lastFolder);
        }
        if ((retValue = fileChooser.showSaveDialog(this)) == 0) {
            FileFilter fileFilter = fileChooser.getFileFilter();
            File file = fileChooser.getSelectedFile();
            this.lastFolder = file.getParentFile();
            JRSaveContributor contributor = null;
            if (fileFilter instanceof JRSaveContributor) {
                contributor = (JRSaveContributor)fileFilter;
            } else {
                int i = 0;
                while (contributor == null && i < this.saveContributors.size()) {
                    if ((contributor = (JRSaveContributor)this.saveContributors.get(i++)).accept(file)) continue;
                    contributor = null;
                }
                if (contributor == null) {
                    contributor = new JRPrintSaveContributor(this.getLocale(), this.getViewerContext().getResourceBundle());
                }
            }
            this.lastSaveContributor = contributor;
            try {
                contributor.save(this.getViewerContext().getJasperPrint(), file);
            }
            catch (JRException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(this, this.getViewerContext().getBundleString(I18n.getString("JrxmlPreviewToolbar.Message.Warning")));
            }
        }
    }

    private void btnPrintActionPerformed(ActionEvent evt) {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                try {
                    JasperPrintManager.printReport((JasperPrint)JrxmlPreviewToolbar.this.getViewerContext().getJasperPrint(), (boolean)true);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog((Component)((Object)JrxmlPreviewToolbar.this.getView()), JrxmlPreviewToolbar.this.getViewerContext().getBundleString(I18n.getString("JrxmlPreviewToolbar.Message.Warning2")));
                }
            }
        });
        thread.start();
    }

    private void btnActualSizeActionPerformed(ActionEvent evt) {
        if (this.btnActualSize.isSelected()) {
            this.btnFitPage.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.getViewerContext().setZoomRatio(1.0f);
            this.btnActualSize.setSelected(true);
        }
    }

    private void btnFitPageActionPerformed(ActionEvent evt) {
        if (this.btnFitPage.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitWidth.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.getViewerContext().fitPage();
            this.btnFitPage.setSelected(true);
        }
    }

    private void btnFitWidthActionPerformed(ActionEvent evt) {
        if (this.btnFitWidth.isSelected()) {
            this.btnActualSize.setSelected(false);
            this.btnFitPage.setSelected(false);
            this.cmbZoom.setSelectedIndex(-1);
            this.getViewerContext().fitWidth();
            this.btnFitWidth.setSelected(true);
        }
    }

    private void cmbZoomActionPerformed(ActionEvent evt) {
        float newZoom = this.getZoomRatio();
        if (newZoom < this.MIN_ZOOM) {
            newZoom = this.MIN_ZOOM;
        }
        if (newZoom > this.MAX_ZOOM) {
            newZoom = this.MAX_ZOOM;
        }
        this.getViewerContext().setZoomRatio(newZoom);
    }

    private void cmbZoomItemStateChanged(ItemEvent evt) {
        this.btnActualSize.setSelected(false);
        this.btnFitPage.setSelected(false);
        this.btnFitWidth.setSelected(false);
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        if (this.getViewerContext().getJasperPrint() != null && this.getViewerContext().getJasperPrint().getPages().size() > 0 && this.getViewerContext().getPageIndex() >= 0) {
            JasperPrint print = this.getViewerContext().getJasperPrint();
            BufferedImage bufImage = new BufferedImage(2 * print.getPageWidth(), 2 * print.getPageHeight(), 2);
            Graphics2D g = bufImage.createGraphics();
            try {
                JRGraphics2DExporter exporter = new JRGraphics2DExporter();
                exporter.setParameter(JRExporterParameter.JASPER_PRINT, (Object)print);
                exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.ZOOM_RATIO, (Object)new Float(2.0));
                exporter.setParameter(JRExporterParameter.PAGE_INDEX, (Object)this.getViewerContext().getPageIndex());
                exporter.setParameter((JRExporterParameter)JRGraphics2DExporterParameter.GRAPHICS_2D, (Object)g);
                exporter.exportReport();
                bufImage = TemplateRenderer.getFasterScaledInstance(bufImage, print.getPageWidth(), print.getPageHeight(), RenderingHints.VALUE_INTERPOLATION_BILINEAR, true);
                Graphics2D gfx = bufImage.createGraphics();
                gfx.setColor(Color.DARK_GRAY);
                gfx.drawRect(0, 0, print.getPageWidth() - 1, print.getPageHeight() - 1);
            }
            catch (JRException ex) {
                JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage());
                return;
            }
            JFileChooser chooser = null;
            chooser = IReportManager.getPreferences().get("templateChooserDirectory", null) != null ? new JFileChooser(IReportManager.getPreferences().get("templateChooserDirectory", null)) : new JFileChooser(Misc.findStartingDirectory());
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    return f.isDirectory() || f.getName().toLowerCase().endsWith(".png");
                }

                public String getDescription() {
                    return "PNG Image";
                }
            });
            String fname = print.getName() + ".png";
            fname = Misc.string_replace("_", " ", fname);
            chooser.setSelectedFile(new File(fname));
            try {
                fname = IReportManager.getInstance().getActiveVisualView().getEditorSupport().getDataObject().getPrimaryFile().getNameExt();
                fname = Misc.changeFileExtension(fname, ".png");
                chooser.setSelectedFile(new File(fname));
            }
            catch (Exception ex) {
                // empty catch block
            }
            if (chooser.showSaveDialog(Misc.getMainFrame()) == 0) {
                IReportManager.getPreferences().put("templateChooserDirectory", chooser.getSelectedFile().getParent());
                try {
                    ImageIO.write((RenderedImage)bufImage, "png", chooser.getSelectedFile());
                }
                catch (Exception ex) {
                    JOptionPane.showMessageDialog(this, "Error: " + ex.getMessage());
                }
            }
        }
    }

    public void init() {
        this.cmbZoom.setSelectedIndex(this.defaultZoomIndex);
    }

    public void addComponentKeyListener(KeyListener listener) {
        this.btnSave.addKeyListener(listener);
        this.btnPrint.addKeyListener(listener);
        this.btnRefresh.addKeyListener(listener);
        this.btnFirst.addKeyListener(listener);
        this.btnPrevious.addKeyListener(listener);
        this.btnPrevious.addKeyListener(listener);
        this.btnLast.addKeyListener(listener);
        this.txtGoTo.addKeyListener(listener);
        this.btnActualSize.addKeyListener(listener);
        this.btnFitPage.addKeyListener(listener);
        this.btnFitWidth.addKeyListener(listener);
        this.btnZoomIn.addKeyListener(listener);
        this.btnZoomOut.addKeyListener(listener);
        this.cmbZoom.addKeyListener(listener);
    }

    public void addSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.add(contributor);
    }

    public void removeSaveContributor(JRSaveContributor contributor) {
        this.saveContributors.remove(contributor);
    }

    public JRSaveContributor[] getSaveContributors() {
        return this.saveContributors.toArray(new JRSaveContributor[this.saveContributors.size()]);
    }

    public void setSaveContributors(JRSaveContributor[] saveContributors) {
        this.saveContributors = new ArrayList();
        if (saveContributors != null) {
            this.saveContributors.addAll(Arrays.asList(saveContributors));
        }
    }

    protected void initSaveContributors() {
        String[] DEFAULT_CONTRIBUTORS = new String[]{"net.sf.jasperreports.view.save.JRPrintSaveContributor", "net.sf.jasperreports.view.save.JRPdfSaveContributor", "net.sf.jasperreports.view.save.JRRtfSaveContributor", "net.sf.jasperreports.view.save.JROdtSaveContributor", "net.sf.jasperreports.view.save.JRHtmlSaveContributor", "net.sf.jasperreports.view.save.JRSingleSheetXlsSaveContributor", "net.sf.jasperreports.view.save.JRMultipleSheetsXlsSaveContributor", "net.sf.jasperreports.view.save.JRCsvSaveContributor", "net.sf.jasperreports.view.save.JRXmlSaveContributor", "net.sf.jasperreports.view.save.JREmbeddedImagesXmlSaveContributor"};
        for (int i = 0; i < DEFAULT_CONTRIBUTORS.length; ++i) {
            try {
                Class saveContribClass = JRClassLoader.loadClassForName((String)DEFAULT_CONTRIBUTORS[i]);
                Constructor constructor = saveContribClass.getConstructor(Locale.class, ResourceBundle.class);
                JRSaveContributor saveContrib = (JRSaveContributor)constructor.newInstance(this.getLocale(), this.getViewerContext().getResourceBundle());
                this.saveContributors.add(saveContrib);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected void reportLoaded() {
    }

    protected void refreshPage() {
        if (!this.viewerContext.hasPages()) {
            this.btnSave.setEnabled(false);
            this.btnPrint.setEnabled(false);
            this.btnActualSize.setEnabled(false);
            this.btnFitPage.setEnabled(false);
            this.btnFitWidth.setEnabled(false);
            this.btnZoomIn.setEnabled(false);
            this.btnZoomOut.setEnabled(false);
            this.cmbZoom.setEnabled(false);
            return;
        }
        this.btnSave.setEnabled(true);
        this.btnPrint.setEnabled(true);
        this.btnActualSize.setEnabled(true);
        this.btnFitPage.setEnabled(true);
        this.btnFitWidth.setEnabled(true);
        this.btnZoomIn.setEnabled(this.getViewerContext().getZoom() < this.MAX_ZOOM);
        this.btnZoomOut.setEnabled(this.getViewerContext().getZoom() > this.MIN_ZOOM);
        this.cmbZoom.setEnabled(true);
    }

    protected void pageChanged() {
        if (this.getViewerContext().hasPages()) {
            int pageIndex = this.getViewerContext().getPageIndex();
            this.btnFirst.setEnabled(pageIndex > 0);
            this.btnPrevious.setEnabled(pageIndex > 0);
            boolean notLast = pageIndex < this.getViewerContext().getPageCount() - 1;
            this.btnNext.setEnabled(notLast);
            this.btnLast.setEnabled(notLast);
            this.txtGoTo.setEnabled(this.btnFirst.isEnabled() || this.btnLast.isEnabled());
            this.txtGoTo.setText("" + (pageIndex + 1));
        } else {
            this.btnFirst.setEnabled(false);
            this.btnPrevious.setEnabled(false);
            this.btnNext.setEnabled(false);
            this.btnLast.setEnabled(false);
            this.txtGoTo.setEnabled(false);
            this.txtGoTo.setText("");
        }
    }

    protected float getZoomRatio() {
        float newZoom = this.getViewerContext().getZoom();
        try {
            newZoom = this.zoomDecimalFormat.parse(String.valueOf(this.cmbZoom.getEditor().getItem())).floatValue() / 100.0f;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        return newZoom;
    }

    protected void zoomChanged() {
        this.cmbZoom.getEditor().setItem(this.zoomDecimalFormat.format(this.getViewerContext().getZoom() * 100.0f) + "%");
    }

    public boolean isFitPage() {
        return this.btnFitPage.isSelected();
    }

    public boolean isFitWidth() {
        return this.btnFitPage.isSelected();
    }

    public void setFitWidth() {
        this.btnFitWidth.setSelected(true);
    }

    protected void fitPage() {
        this.btnFitPage.setSelected(true);
    }

    protected void fitWidth() {
        this.btnFitWidth.setSelected(true);
    }

    public void viewerEvent(JRViewerEvent event) {
        switch (event.getCode()) {
            case 5: {
                this.fitPage();
                break;
            }
            case 6: {
                this.fitWidth();
                break;
            }
            case 3: {
                this.pageChanged();
                break;
            }
            case 2: {
                this.refreshPage();
                break;
            }
            case 4: {
                this.zoomChanged();
                break;
            }
            case 1: {
                this.reportLoaded();
            }
        }
    }

    public JRViewerController getViewerContext() {
        return this.viewerContext;
    }

    public JrxmlPreviewView getView() {
        return this.view;
    }
}

