/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.wizards;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.designer.wizards.ConnectionSelectionVisualPanel;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.util.HelpCtx;

public class ConnectionSelectionWizardPanel
implements WizardDescriptor.AsynchronousValidatingPanel {
    private WizardDescriptor wizard;
    private ConnectionSelectionVisualPanel component;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public ConnectionSelectionWizardPanel(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public Component getComponent() {
        if (this.component == null) {
            this.component = new ConnectionSelectionVisualPanel(this);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        IReportConnection con = this.component.getConnection();
        if (con instanceof WizardFieldsProvider && this.component.getQuery().trim().length() == 0) {
            this.getWizard().putProperty("WizardPanel_errorMessage", (Object)I18n.getString("Wizards.Property.Invalidquery"));
            return false;
        }
        this.getWizard().putProperty("WizardPanel_errorMessage", null);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    public void readSettings(Object settings) {
    }

    public void storeSettings(Object settings) {
    }

    public WizardDescriptor getWizard() {
        return this.wizard;
    }

    public void setWizard(WizardDescriptor wizard) {
        this.wizard = wizard;
    }

    public void prepareValidation() {
    }

    public void validate() throws WizardValidationException {
        List<JRDesignField> discoveredFields = null;
        this.getWizard().putProperty("discoveredFields", discoveredFields);
        this.getWizard().putProperty("discoveredFieldsNeedRefresh", (Object)"true");
        this.getWizard().putProperty("query", null);
        this.getWizard().putProperty("queryLanguage", null);
        try {
            IReportConnection con = this.component.getConnection();
            if (con instanceof WizardFieldsProvider) {
                discoveredFields = ((WizardFieldsProvider)((Object)con)).readFields(this.component.getQuery());
                this.getWizard().putProperty("query", (Object)this.component.getQuery());
                this.getWizard().putProperty("queryLanguage", (Object)((WizardFieldsProvider)((Object)con)).getQueryLanguage());
            } else {
                discoveredFields = null;
            }
            this.getWizard().putProperty("discoveredFields", discoveredFields);
        }
        catch (Exception ex) {
            Misc.showErrorMessage(ex.getMessage(), "Query error", ex);
            throw new WizardValidationException((JComponent)this.component, ex.getMessage(), ex.getLocalizedMessage());
        }
    }
}

