/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.openfile;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.openfile.OpenFile;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.windows.ExternalDropHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultExternalDropHandler
extends ExternalDropHandler {
    private static DataFlavor uriListDataFlavor;

    public boolean canDrop(DropTargetDragEvent dropTargetDragEvent) {
        return this.canDrop(dropTargetDragEvent.getCurrentDataFlavors());
    }

    public boolean canDrop(DropTargetDropEvent dropTargetDropEvent) {
        return this.canDrop(dropTargetDropEvent.getCurrentDataFlavors());
    }

    boolean canDrop(DataFlavor[] dataFlavorArray) {
        for (int i = 0; null != dataFlavorArray && i < dataFlavorArray.length; ++i) {
            if (!DataFlavor.javaFileListFlavor.equals(dataFlavorArray[i]) && !this.getUriListDataFlavor().equals(dataFlavorArray[i])) continue;
            return true;
        }
        return false;
    }

    public boolean handleDrop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        if (null == transferable) {
            return false;
        }
        List<File> list = this.getFileList(transferable);
        if (null != list && !list.isEmpty()) {
            for (File file : list) {
                this.openFile(file);
            }
            return true;
        }
        return false;
    }

    List<File> getFileList(Transferable transferable) {
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                return (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            }
            if (transferable.isDataFlavorSupported(this.getUriListDataFlavor())) {
                String string = (String)transferable.getTransferData(this.getUriListDataFlavor());
                return this.textURIListToFileList(string);
            }
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            ErrorManager.getDefault().notify(1, (Throwable)unsupportedFlavorException);
        }
        catch (IOException iOException) {
            Logger.getLogger(DefaultExternalDropHandler.class.getName()).log(Level.FINE, null, iOException);
        }
        return null;
    }

    void openFile(File file) {
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        OpenFile.open(fileObject, -1);
    }

    DataFlavor getUriListDataFlavor() {
        if (null == uriListDataFlavor) {
            try {
                uriListDataFlavor = new DataFlavor("text/uri-list;class=java.lang.String");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new AssertionError((Object)classNotFoundException);
            }
        }
        return uriListDataFlavor;
    }

    List<File> textURIListToFileList(String string) {
        ArrayList<File> arrayList = new ArrayList<File>(1);
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\r\n");
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (string2.startsWith("#")) continue;
            try {
                URI uRI = new URI(string2);
                File file = new File(uRI);
                arrayList.add(file);
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {}
        }
        return arrayList;
    }
}

