/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import net.sf.jasperreports.engine.JRCloneable;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentManager;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.events.JRPropertyChangeSupport;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRDesignComponentElement
extends JRDesignElement
implements JRComponentElement {
    private static final long serialVersionUID = 10200L;
    private static final Log log = LogFactory.getLog((Class)JRDesignComponentElement.class);
    public static final String PROPERTY_COMPONENT = "component";
    public static final String PROPERTY_COMPONENT_KEY = "componentKey";
    private ComponentKey componentKey;
    private Component component;
    private transient JRPropertyChangeSupport eventSupport;

    public JRDesignComponentElement() {
        super(null);
    }

    public JRDesignComponentElement(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JRPropertyChangeSupport getEventSupport() {
        JRDesignComponentElement jRDesignComponentElement = this;
        synchronized (jRDesignComponentElement) {
            if (this.eventSupport == null) {
                this.eventSupport = new JRPropertyChangeSupport(this);
            }
        }
        return this.eventSupport;
    }

    public void collectExpressions(JRExpressionCollector collector) {
        ComponentManager manager = ComponentsEnvironment.getComponentManager(this.componentKey);
        manager.getComponentCompiler().collectExpressions(this.component, collector);
    }

    public void visit(JRVisitor visitor) {
        visitor.visitComponentElement(this);
    }

    public Component getComponent() {
        return this.component;
    }

    public void setComponent(Component component) {
        Component old = this.component;
        this.component = component;
        this.getEventSupport().firePropertyChange(PROPERTY_COMPONENT, old, this.component);
    }

    public ComponentKey getComponentKey() {
        return this.componentKey;
    }

    public void setComponentKey(ComponentKey componentKey) {
        ComponentKey old = this.componentKey;
        this.componentKey = componentKey;
        this.getEventSupport().firePropertyChange(PROPERTY_COMPONENT_KEY, old, this.componentKey);
    }

    public Object clone() {
        JRDesignComponentElement clone = (JRDesignComponentElement)super.clone();
        if (this.component instanceof JRCloneable) {
            clone.component = (Component)((JRCloneable)((Object)this.component)).clone();
        } else if (this.component != null && log.isDebugEnabled()) {
            log.debug((Object)("Component of type " + this.component.getClass().getName() + " does not implement JRCloneable, not cloning"));
        }
        return clone;
    }
}

