/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.settings.storage;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.KeyStroke;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.KeyBindingSettings;
import org.netbeans.api.editor.settings.MultiKeyBinding;
import org.netbeans.modules.editor.settings.storage.EditorSettingsImpl;
import org.netbeans.modules.editor.settings.storage.KeyMapsStorage;
import org.netbeans.modules.editor.settings.storage.api.KeyBindingSettingsFactory;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyBindingSettingsImpl
extends KeyBindingSettingsFactory {
    private static final Logger LOG = Logger.getLogger(KeyBindingSettingsImpl.class.getName());
    private static final Map<MimePath, WeakReference<KeyBindingSettingsImpl>> INSTANCES = new WeakHashMap<MimePath, WeakReference<KeyBindingSettingsImpl>>();
    private MimePath mimePath;
    private PropertyChangeSupport pcs;
    private Map<String, Map<Collection<KeyStroke>, MultiKeyBinding>> keyMaps = new HashMap<String, Map<Collection<KeyStroke>, MultiKeyBinding>>();
    private KeyBindingSettingsImpl baseKBS;
    private Listener listener;
    private String logActionName = null;
    private boolean init = false;
    private Map<String, Map<Collection<KeyStroke>, MultiKeyBinding>> defaults = new HashMap<String, Map<Collection<KeyStroke>, MultiKeyBinding>>();

    public static synchronized KeyBindingSettingsImpl get(MimePath mimePath) {
        KeyBindingSettingsImpl keyBindingSettingsImpl;
        WeakReference<KeyBindingSettingsImpl> weakReference = INSTANCES.get(mimePath);
        KeyBindingSettingsImpl keyBindingSettingsImpl2 = keyBindingSettingsImpl = weakReference == null ? null : (KeyBindingSettingsImpl)weakReference.get();
        if (keyBindingSettingsImpl == null) {
            keyBindingSettingsImpl = new KeyBindingSettingsImpl(mimePath);
            INSTANCES.put(mimePath, new WeakReference<KeyBindingSettingsImpl>(keyBindingSettingsImpl));
        }
        return keyBindingSettingsImpl;
    }

    private KeyBindingSettingsImpl(MimePath mimePath) {
        this.mimePath = mimePath;
        this.pcs = new PropertyChangeSupport(this);
        String string = KeyBindingSettingsImpl.class.getName();
        String string2 = System.getProperty(string);
        if (string2 != null) {
            if (!string2.equals("true")) {
                this.logActionName = System.getProperty(string);
            }
        } else if (mimePath.size() == 1) {
            this.logActionName = System.getProperty(string + '.' + mimePath.getMimeType(0));
        }
    }

    private void init() {
        if (this.init) {
            return;
        }
        this.init = true;
        if (this.mimePath.size() > 0) {
            this.baseKBS = KeyBindingSettingsImpl.get(MimePath.EMPTY);
        }
        this.listener = new Listener(this, this.baseKBS);
    }

    @Override
    public List<MultiKeyBinding> getKeyBindings() {
        return this.getKeyBindings(EditorSettingsImpl.getInstance().getCurrentKeyMapProfile());
    }

    @Override
    public List<MultiKeyBinding> getKeyBindings(String string) {
        Map<Collection<KeyStroke>, MultiKeyBinding> map;
        this.init();
        string = EditorSettingsImpl.getInstance().getInternalKeymapProfile(string);
        HashMap<Collection<KeyStroke>, MultiKeyBinding> hashMap = new HashMap<Collection<KeyStroke>, MultiKeyBinding>();
        if (this.baseKBS != null) {
            map = this.baseKBS.getShortcuts(string);
            hashMap.putAll(map);
        }
        map = this.getShortcuts(string);
        hashMap.putAll(map);
        ArrayList arrayList = new ArrayList(hashMap.values());
        this.log("getKeyBindings", arrayList);
        return Collections.unmodifiableList(arrayList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<Collection<KeyStroke>, MultiKeyBinding> getShortcuts(String string) {
        KeyBindingSettingsImpl keyBindingSettingsImpl = this;
        synchronized (keyBindingSettingsImpl) {
            Map<Collection<KeyStroke>, MultiKeyBinding> map = this.keyMaps.get(string);
            if (map == null) {
                map = KeyMapsStorage.loadKeyMaps(this.mimePath, string, false);
                this.keyMaps.put(string, map);
            }
            return map;
        }
    }

    @Override
    public List<MultiKeyBinding> getKeyBindingDefaults(String string) {
        string = EditorSettingsImpl.getInstance().getInternalKeymapProfile(string);
        return Collections.unmodifiableList(new ArrayList<MultiKeyBinding>(this.getDefaults(string).values()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setKeyBindings(String string, List<MultiKeyBinding> list) {
        KeyBindingSettingsImpl keyBindingSettingsImpl = this;
        synchronized (keyBindingSettingsImpl) {
            this.log("setKeyBindings", list);
            string = EditorSettingsImpl.getInstance().getInternalKeymapProfile(string);
            this.init();
            if (list == null) {
                this.keyMaps.remove(string);
                KeyMapsStorage.deleteProfile(this.mimePath, string, false);
                return;
            }
            HashMap<List, MultiKeyBinding> hashMap = new HashMap<List, MultiKeyBinding>();
            for (MultiKeyBinding object2 : list) {
                hashMap.put(object2.getKeyStrokeList(), object2);
            }
            HashMap hashMap2 = new HashMap(hashMap);
            this.keyMaps.put(string, hashMap2);
            Map<Collection<KeyStroke>, MultiKeyBinding> map = this.getDefaults(string);
            HashSet<Collection<KeyStroke>> hashSet = new HashSet<Collection<KeyStroke>>();
            for (Collection<KeyStroke> collection : map.keySet()) {
                MultiKeyBinding multiKeyBinding = map.get(collection);
                if (!hashMap.containsKey(collection)) {
                    hashSet.add(collection);
                    continue;
                }
                MultiKeyBinding multiKeyBinding2 = (MultiKeyBinding)hashMap.get(collection);
                if (!multiKeyBinding2.getActionName().equals(multiKeyBinding.getActionName())) continue;
                hashMap.remove(collection);
            }
            this.log("  changed:", hashMap.values());
            this.log("  removed:", hashSet);
            this.log("", Collections.EMPTY_LIST);
            this.listener.removeListeners();
            KeyMapsStorage.saveKeyMaps(this.mimePath, string, false, hashMap.values(), hashSet);
            this.listener.addListeners();
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }

    private Map<Collection<KeyStroke>, MultiKeyBinding> getDefaults(String string) {
        if (!this.defaults.containsKey(string)) {
            Map<Collection<KeyStroke>, MultiKeyBinding> map = KeyMapsStorage.loadKeyMaps(this.mimePath, string, true);
            this.defaults.put(string, map);
        }
        return this.defaults.get(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refresh() {
        KeyBindingSettingsImpl keyBindingSettingsImpl = this;
        synchronized (keyBindingSettingsImpl) {
            this.keyMaps.clear();
            this.log("refresh", Collections.EMPTY_SET);
        }
        this.pcs.firePropertyChange(null, null, null);
    }

    private void log(String string, Collection collection) {
        if (!LOG.isLoggable(Level.FINE)) {
            return;
        }
        if (string.length() != 0) {
            if (this.mimePath.size() == 1) {
                string = string + " " + this.mimePath.getMimeType(0);
            }
            string = string + " " + EditorSettingsImpl.getInstance().getCurrentKeyMapProfile();
        }
        if (collection == null) {
            LOG.fine(string + " : null");
            return;
        }
        LOG.fine(string);
        for (Object e : collection) {
            if (this.logActionName == null || !(e instanceof MultiKeyBinding)) {
                LOG.fine("  " + e);
                continue;
            }
            if (!(e instanceof MultiKeyBinding) || !this.logActionName.equals(((MultiKeyBinding)e).getActionName())) continue;
            LOG.fine("  " + e);
        }
    }

    public Object createInstanceForLookup() {
        List<MultiKeyBinding> list = this.getKeyBindings();
        return new Immutable(new ArrayList<MultiKeyBinding>(list));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Immutable
    extends KeyBindingSettings {
        private List<MultiKeyBinding> keyBindings;

        public Immutable(List<MultiKeyBinding> list) {
            this.keyBindings = list;
        }

        public List<MultiKeyBinding> getKeyBindings() {
            return Collections.unmodifiableList(this.keyBindings);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class Listener
    extends WeakReference<KeyBindingSettingsImpl>
    implements PropertyChangeListener,
    Runnable {
        private KeyBindingSettingsFactory baseKBS;

        Listener(KeyBindingSettingsImpl keyBindingSettingsImpl, KeyBindingSettingsFactory keyBindingSettingsFactory) {
            super(keyBindingSettingsImpl, Utilities.activeReferenceQueue());
            this.baseKBS = keyBindingSettingsFactory;
            this.addListeners();
        }

        private KeyBindingSettingsImpl getSettings() {
            KeyBindingSettingsImpl keyBindingSettingsImpl = (KeyBindingSettingsImpl)this.get();
            if (keyBindingSettingsImpl != null) {
                return keyBindingSettingsImpl;
            }
            this.removeListeners();
            return null;
        }

        private void addListeners() {
            EditorSettingsImpl.getInstance().addPropertyChangeListener("currentKeyMapProfile", this);
            if (this.baseKBS != null) {
                this.baseKBS.addPropertyChangeListener(this);
            }
        }

        private void removeListeners() {
            if (this.baseKBS != null) {
                this.baseKBS.removePropertyChangeListener(this);
            }
            EditorSettingsImpl.getInstance().removePropertyChangeListener("currentKeyMapProfile", this);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            KeyBindingSettingsImpl keyBindingSettingsImpl = this.getSettings();
            if (keyBindingSettingsImpl == null) {
                return;
            }
            keyBindingSettingsImpl.log("refresh2", Collections.EMPTY_SET);
            keyBindingSettingsImpl.pcs.firePropertyChange(null, null, null);
        }

        @Override
        public void run() {
            this.removeListeners();
        }
    }
}

