/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.parser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTToken;
import org.netbeans.api.languages.CharInput;
import org.netbeans.api.languages.Language;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.TokenType;
import org.netbeans.modules.languages.parser.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Parser {
    public static final String DEFAULT_STATE = "DEFAULT";
    private Map<Integer, Pattern> stateToPattern = new HashMap<Integer, Pattern>();
    private Map<String, Integer> nameToState = new HashMap<String, Integer>();
    private Map<Integer, String> stateToName = new HashMap<Integer, String>();
    private List<TokenType> tokenTypes;
    private int counter = 1;
    private Map<String, Pattern> patterns;

    private Parser() {
        this.nameToState.put(DEFAULT_STATE, -1);
        this.stateToName.put(-1, DEFAULT_STATE);
        this.patterns = new HashMap<String, Pattern>();
    }

    public static Parser create(List<TokenType> list) {
        return new Parser(list);
    }

    private Parser(List<TokenType> list) {
        this.nameToState.put(DEFAULT_STATE, -1);
        this.stateToName.put(-1, DEFAULT_STATE);
        this.patterns = new HashMap<String, Pattern>();
        this.tokenTypes = list;
        for (TokenType tokenType : list) {
            this.add(tokenType);
        }
    }

    public List<TokenType> getTokenTypes() {
        return this.tokenTypes;
    }

    private void add(TokenType tokenType) {
        if (tokenType.getPattern() == null) {
            return;
        }
        String string = tokenType.getStartState();
        if (string == null) {
            string = DEFAULT_STATE;
        }
        int n = 0;
        if (this.nameToState.containsKey(string)) {
            n = this.nameToState.get(string);
        } else {
            n = this.counter++;
            this.nameToState.put(string, n);
            this.stateToName.put(n, string);
        }
        Pattern pattern = tokenType.getPattern();
        pattern.mark(tokenType.getPriority(), tokenType);
        if (this.stateToPattern.containsKey(n)) {
            this.stateToPattern.put(n, this.stateToPattern.get(n).merge(pattern));
        } else {
            this.stateToPattern.put(n, pattern);
        }
    }

    public ASTToken read(Cookie cookie, CharInput charInput, Language language) {
        if (charInput.eof()) {
            return null;
        }
        int n = charInput.getIndex();
        Pattern pattern = this.stateToPattern.get(cookie.getState());
        if (pattern == null) {
            return null;
        }
        TokenType tokenType = (TokenType)pattern.read(charInput);
        if (tokenType == null) {
            return null;
        }
        Feature feature = tokenType.getProperties();
        cookie.setProperties(feature);
        String string = tokenType.getEndState();
        int n2 = -1;
        if (string != null) {
            n2 = this.getState(string);
        }
        cookie.setState(n2);
        ASTToken aSTToken = ASTToken.create(language, tokenType.getTypeID(), charInput.getString(n, charInput.getIndex()), n);
        if (feature != null && feature.getType("call") != Feature.Type.NOT_SET) {
            charInput.setIndex(n);
            Object[] objectArray = (Object[])feature.getValue("call", new Object[]{charInput});
            aSTToken = (ASTToken)objectArray[0];
            if (objectArray[1] != null) {
                cookie.setState(this.getState((String)objectArray[1]));
            }
        }
        return aSTToken;
    }

    public int getState(String string) {
        Integer n = this.nameToState.get(string);
        if (n == null) {
            throw new IllegalArgumentException("Unknown lexer state: " + string);
        }
        return n;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (String string : this.patterns.keySet()) {
            stringBuffer.append(string).append(":").append(this.patterns.get(string));
        }
        return stringBuffer.toString();
    }

    public static interface Cookie {
        public int getState();

        public void setState(int var1);

        public void setProperties(Feature var1);
    }
}

