/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.autoupdate.ui;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.Collator;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.OperationSupport;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.autoupdate.UpdateUnitProvider;
import org.netbeans.api.autoupdate.UpdateUnitProviderFactory;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.Containers;
import org.netbeans.modules.autoupdate.ui.NetworkProblemPanel;
import org.netbeans.modules.autoupdate.ui.PluginManagerUI;
import org.netbeans.modules.autoupdate.ui.SettingsTableModel;
import org.netbeans.modules.autoupdate.ui.Unit;
import org.netbeans.modules.autoupdate.ui.UnitCategory;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Utilities {
    private static Logger logger = Logger.getLogger(Utilities.class.getName());
    private static Boolean isModulesOnly;
    private static String PLUGIN_MANAGER_MODULES_ONLY;
    private static String PLUGIN_MANAGER_SHARED_INSTALLATION;
    public static final SimpleDateFormat DATE_FORMAT;
    static final String UNSORTED_CATEGORY;
    static final String LIBRARIES_CATEGORY;
    static final String BRIDGES_CATEGORY;

    public static List<UnitCategory> makeInstalledCategories(List<UpdateUnit> list) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateElement == null && !updateUnit.isPending()) continue;
            String string = updateElement == null && updateUnit.isPending() ? ((UpdateElement)updateUnit.getAvailableUpdates().get(0)).getCategory() : updateElement.getCategory();
            Unit.Installed installed = new Unit.Installed(updateUnit, string);
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(installed);
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(installed);
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeInstalledCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    public static List<UnitCategory> makeUpdateCategories(List<UpdateUnit> list, boolean bl) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateUnit.isPending() || updateElement == null || (list2 = updateUnit.getAvailableUpdates()).isEmpty()) continue;
            String string = updateElement.getCategory();
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(new Unit.Update(updateUnit, bl, string));
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(new Unit.Update(updateUnit, bl, string));
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeUpdateCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    public static List<UnitCategory> makeAvailableCategories(List<UpdateUnit> list, boolean bl) {
        ArrayList<UnitCategory> arrayList = new ArrayList<UnitCategory>();
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (UpdateUnit updateUnit : list) {
            UnitCategory unitCategory;
            List list2;
            UpdateElement updateElement = updateUnit.getInstalled();
            if (updateUnit.isPending() || updateElement != null || (list2 = updateUnit.getAvailableUpdates()) == null || list2.size() == 0) continue;
            UpdateElement updateElement2 = (UpdateElement)list2.get(0);
            String string = updateElement2.getCategory();
            if (arrayList2.contains(string)) {
                unitCategory = (UnitCategory)arrayList.get(arrayList2.indexOf(string));
                unitCategory.addUnit(new Unit.Available(updateUnit, bl, string));
                continue;
            }
            unitCategory = new UnitCategory(string);
            unitCategory.addUnit(new Unit.Available(updateUnit, bl, string));
            arrayList.add(unitCategory);
            arrayList2.add(string);
        }
        logger.log(Level.FINER, "makeAvailableCategories (" + list.size() + ") returns " + arrayList.size());
        return arrayList;
    }

    public static void showURL(URL uRL) {
        HtmlBrowser.URLDisplayer uRLDisplayer = HtmlBrowser.URLDisplayer.getDefault();
        assert (uRLDisplayer != null) : "HtmlBrowser.URLDisplayer found.";
        if (uRLDisplayer != null) {
            uRLDisplayer.showURL(uRL);
        } else {
            logger.log(Level.INFO, "No URLDisplayer found.");
        }
    }

    public static List<UpdateElement> getRequiredElements(UpdateUnit updateUnit, UpdateElement updateElement, OperationContainer<OperationSupport> operationContainer) {
        List<UpdateElement> list = Collections.emptyList();
        if (operationContainer.canBeAdded(updateUnit, updateElement)) {
            OperationContainer.OperationInfo operationInfo = operationContainer.add(updateUnit, updateElement);
            list = new LinkedList<UpdateElement>(operationInfo.getRequiredElements());
        }
        return list;
    }

    public static boolean isGtk() {
        return "GTK".equals(UIManager.getLookAndFeel().getID());
    }

    public static String getDownloadSizeAsString(int n) {
        int n2 = n / 0x40000000;
        if (n2 > 0) {
            return n2 + Utilities.getBundle("Utilities_DownloadSize_GB", new Object[0]);
        }
        int n3 = n / 0x100000;
        if (n3 > 0) {
            return n3 + Utilities.getBundle("Utilities_DownloadSize_MB", new Object[0]);
        }
        int n4 = n / 1024;
        if (n4 > 0) {
            return n4 + Utilities.getBundle("Utilities_DownloadSize_kB", new Object[0]);
        }
        return n + Utilities.getBundle("Utilities_DownloadSize_B", new Object[0]);
    }

    private static String getBundle(String string, Object ... objectArray) {
        return NbBundle.getMessage(Utilities.class, (String)string, (Object[])objectArray);
    }

    public static void presentRefreshProvider(UpdateUnitProvider updateUnitProvider, PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(Collections.singleton(updateUnitProvider), pluginManagerUI, bl);
    }

    public static void presentRefreshProviders(Collection<UpdateUnitProvider> collection, PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProvider() call in EQ!";
        Utilities.doRefreshProviders(collection, pluginManagerUI, bl);
    }

    public static void presentRefreshProviders(PluginManagerUI pluginManagerUI, boolean bl) {
        assert (!SwingUtilities.isEventDispatchThread()) : "Don't presentRefreshProviders() call in EQ!";
        Utilities.doRefreshProviders(null, pluginManagerUI, bl);
    }

    private static void doRefreshProviders(Collection<UpdateUnitProvider> collection, PluginManagerUI pluginManagerUI, boolean bl) {
        boolean bl2 = false;
        while (!bl2) {
            bl2 = Utilities.tryRefreshProviders(collection, pluginManagerUI, bl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean tryRefreshProviders(Collection<UpdateUnitProvider> list, PluginManagerUI pluginManagerUI, boolean bl) {
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(SettingsTableModel.class, (String)"Utilities_CheckingForUpdates"));
        JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
        JLabel jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
        jLabel.setHorizontalAlignment(2);
        try {
            pluginManagerUI.setProgressComponent(jLabel, jComponent);
            progressHandle.setInitialDelay(0);
            progressHandle.start();
            if (list == null) {
                list = UpdateUnitProviderFactory.getDefault().getUpdateUnitProviders(true);
            }
            for (UpdateUnitProvider updateUnitProvider : list) {
                try {
                    updateUnitProvider.refresh(progressHandle, bl);
                }
                catch (IOException iOException) {
                    boolean bl2;
                    block12: {
                        logger.log(Level.INFO, iOException.getMessage(), iOException);
                        JButton jButton = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton, (String)Utilities.getBundle("Utilities_NetworkProblem_Cancel", new Object[0]));
                        JButton jButton2 = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton2, (String)Utilities.getBundle("Utilities_NetworkProblem_Skip", new Object[0]));
                        jButton2.setEnabled(list.size() > 1);
                        JButton jButton3 = new JButton();
                        Mnemonics.setLocalizedText((AbstractButton)jButton3, (String)Utilities.getBundle("Utilities_NetworkProblem_Continue", new Object[0]));
                        NetworkProblemPanel networkProblemPanel = new NetworkProblemPanel(Utilities.getBundle("Utilities_NetworkProblem_Text", updateUnitProvider.getDisplayName(), iOException.getLocalizedMessage()), jButton3, jButton2, jButton);
                        Object object = networkProblemPanel.showNetworkProblemDialog();
                        if (jButton2.equals(object)) continue;
                        if (jButton3.equals(object)) {
                            boolean bl3 = false;
                            if (progressHandle != null) {
                                progressHandle.finish();
                            }
                            Containers.initNotify();
                            pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                            return bl3;
                        }
                        try {
                            bl2 = true;
                            if (progressHandle == null) break block12;
                        }
                        catch (Throwable throwable) {
                            throw throwable;
                            return true;
                        }
                        progressHandle.finish();
                    }
                    Containers.initNotify();
                    pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                    return bl2;
                }
            }
        }
        finally {
            if (progressHandle != null) {
                progressHandle.finish();
            }
            Containers.initNotify();
            pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
        }
    }

    public static void startAsWorkerThread(final PluginManagerUI pluginManagerUI, final Runnable runnable, final String string) {
        Utilities.startAsWorkerThread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)string);
                JComponent jComponent = ProgressHandleFactory.createProgressComponent((ProgressHandle)progressHandle);
                JLabel jLabel = ProgressHandleFactory.createDetailLabelComponent((ProgressHandle)progressHandle);
                try {
                    jLabel.setHorizontalAlignment(2);
                    pluginManagerUI.setProgressComponent(jLabel, jComponent);
                    progressHandle.setInitialDelay(0);
                    progressHandle.start();
                    progressHandle.progress(string);
                    runnable.run();
                }
                finally {
                    if (progressHandle != null) {
                        progressHandle.finish();
                    }
                    pluginManagerUI.unsetProgressComponent(jLabel, jComponent);
                }
            }
        });
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnable) {
        return Utilities.startAsWorkerThread(runnable, 0);
    }

    public static RequestProcessor.Task startAsWorkerThread(Runnable runnable, int n) {
        RequestProcessor.Task task = RequestProcessor.getDefault().create(runnable);
        if (SwingUtilities.isEventDispatchThread()) {
            task.schedule(n);
        } else {
            if (n > 0) {
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
            task.run();
        }
        return task;
    }

    public static UpdateManager.TYPE[] getUnitTypes() {
        if (Utilities.modulesOnly()) {
            return new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE};
        }
        return new UpdateManager.TYPE[]{UpdateManager.TYPE.KIT_MODULE, UpdateManager.TYPE.CUSTOM_HANDLED_COMPONENT};
    }

    public static boolean isGlobalInstallation() {
        return Utilities.getPreferences().getBoolean(PLUGIN_MANAGER_SHARED_INSTALLATION, Boolean.valueOf(System.getProperty("plugin.manager.install.global")));
    }

    public static void setGlobalInstallation(boolean bl) {
        Utilities.getPreferences().putBoolean(PLUGIN_MANAGER_SHARED_INSTALLATION, bl);
    }

    public static boolean modulesOnly() {
        return isModulesOnly == null ? Utilities.modulesOnlyDefault() : isModulesOnly;
    }

    public static boolean showExtendedDescription() {
        return Boolean.valueOf(System.getProperty("plugin.manager.extended.description"));
    }

    public static boolean shouldCheckAvailableNewPlugins() {
        String string = System.getProperty("plugin.manager.check.new.plugins");
        return string == null ? false : Boolean.valueOf(string);
    }

    public static boolean shouldCheckAvailableUpdates() {
        String string = System.getProperty("plugin.manager.check.updates");
        return string == null ? true : Boolean.valueOf(string);
    }

    public static void setModulesOnly(boolean bl) {
        isModulesOnly = bl ? Boolean.TRUE : Boolean.FALSE;
        Utilities.getPreferences().putBoolean(PLUGIN_MANAGER_MODULES_ONLY, isModulesOnly);
    }

    private static boolean modulesOnlyDefault() {
        return Utilities.getPreferences().getBoolean(PLUGIN_MANAGER_MODULES_ONLY, Boolean.valueOf(System.getProperty("plugin.manager.modules.only")));
    }

    public static Comparator<String> getCategoryComparator() {
        return new Comparator<String>(){

            @Override
            public int compare(String string, String string2) {
                if (LIBRARIES_CATEGORY.equals(string)) {
                    if (LIBRARIES_CATEGORY.equals(string2)) {
                        return 0;
                    }
                    return 1;
                }
                if (LIBRARIES_CATEGORY.equals(string2)) {
                    return -1;
                }
                if (BRIDGES_CATEGORY.equals(string)) {
                    if (BRIDGES_CATEGORY.equals(string2)) {
                        return 0;
                    }
                    return 1;
                }
                if (BRIDGES_CATEGORY.equals(string2)) {
                    return -1;
                }
                if (UNSORTED_CATEGORY.equals(string)) {
                    if (UNSORTED_CATEGORY.equals(string2)) {
                        return 0;
                    }
                    return 1;
                }
                if (UNSORTED_CATEGORY.equals(string2)) {
                    return -1;
                }
                return Collator.getInstance().compare(string, string2);
            }
        };
    }

    public static List<File> sharedDirs() {
        Object object;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        String string = System.getProperty("netbeans.dirs");
        if (string != null) {
            object = new StringTokenizer(string, File.pathSeparator);
            while (object.hasMoreElements()) {
                File file = new File((String)object.nextElement());
                arrayList.add(file);
            }
        }
        if ((object = Utilities.getPlatformDir()) != null) {
            arrayList.add(object);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private static File getPlatformDir() {
        String string = System.getProperty("netbeans.home");
        return string == null ? null : new File(string);
    }

    private static Preferences getPreferences() {
        return NbPreferences.forModule(Utilities.class);
    }

    static String getCategoryName(UpdateUnitProvider.CATEGORY cATEGORY) {
        String string = null;
        switch (cATEGORY) {
            case STANDARD: {
                string = "AvailableTab_SourceCategory_Tooltip_STANDARD";
                break;
            }
            case BETA: {
                string = "AvailableTab_SourceCategory_Tooltip_BETA";
                break;
            }
            case COMMUNITY: {
                string = "AvailableTab_SourceCategory_Tooltip_COMMUNITY";
            }
        }
        return string != null ? Utilities.getBundle(string, new Object[0]) : null;
    }

    static URL getCategoryIcon(UpdateUnitProvider.CATEGORY cATEGORY) {
        URL uRL = null;
        if (UpdateUnitProvider.CATEGORY.BETA.equals((Object)cATEGORY)) {
            uRL = Utilities.class.getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-beta.png");
        } else if (UpdateUnitProvider.CATEGORY.COMMUNITY.equals((Object)cATEGORY)) {
            uRL = Utilities.class.getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-community.png");
        } else if (UpdateUnitProvider.CATEGORY.STANDARD.equals((Object)cATEGORY)) {
            uRL = Utilities.class.getResource("/org/netbeans/modules/autoupdate/ui/resources/icon-standard.png");
        }
        return uRL;
    }

    static {
        PLUGIN_MANAGER_MODULES_ONLY = "plugin_manager_modules_only";
        PLUGIN_MANAGER_SHARED_INSTALLATION = "plugin_manager_shared_installation";
        DATE_FORMAT = new SimpleDateFormat("yyyy/MM/dd");
        UNSORTED_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Unsorted_Category");
        LIBRARIES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Libraries_Category");
        BRIDGES_CATEGORY = NbBundle.getMessage(Utilities.class, (String)"Utilities_Bridges_Category");
    }
}

