/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.editor.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ListenerList<T extends EventListener>
implements Serializable {
    static final long serialVersionUID = 0L;
    private static final EventListener[] EMPTY_LISTENER_ARRAY = new EventListener[0];
    private transient ImmutableList<T> listenersList = new ImmutableList(EMPTY_LISTENER_ARRAY);

    public synchronized List<T> getListeners() {
        return this.listenersList;
    }

    public synchronized int getListenerCount() {
        return this.listenersList.size();
    }

    public synchronized void add(T t) {
        if (t == null) {
            return;
        }
        EventListener[] eventListenerArray = new EventListener[this.listenersList.getArray().length + 1];
        if (eventListenerArray.length > 1) {
            System.arraycopy(this.listenersList.getArray(), 0, eventListenerArray, 0, eventListenerArray.length - 1);
        }
        eventListenerArray[eventListenerArray.length - 1] = t;
        this.listenersList = new ImmutableList(eventListenerArray);
    }

    public synchronized void remove(T t) {
        if (t == null) {
            return;
        }
        int n = this.listenersList.indexOf(t);
        if (n == -1) {
            return;
        }
        EventListener[] eventListenerArray = new EventListener[this.listenersList.getArray().length - 1];
        if (eventListenerArray.length > 0) {
            System.arraycopy(this.listenersList.getArray(), 0, eventListenerArray, 0, n);
        }
        if (eventListenerArray.length > n) {
            System.arraycopy(this.listenersList.getArray(), n + 1, eventListenerArray, n, this.listenersList.getArray().length - n - 1);
        }
        this.listenersList = new ImmutableList(eventListenerArray);
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        for (EventListener eventListener : this.listenersList) {
            if (!(eventListener instanceof Serializable)) continue;
            objectOutputStream.writeObject(eventListener);
        }
        objectOutputStream.writeObject(null);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        Object object;
        objectInputStream.defaultReadObject();
        ArrayList<EventListener> arrayList = new ArrayList<EventListener>();
        while (null != (object = objectInputStream.readObject())) {
            EventListener eventListener = (EventListener)object;
            arrayList.add(eventListener);
        }
        this.listenersList = new ImmutableList(arrayList.toArray(new EventListener[arrayList.size()]));
    }

    public String toString() {
        return this.listenersList.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ImmutableList<E extends EventListener>
    extends AbstractList<E> {
        private EventListener[] array;

        public ImmutableList(EventListener[] eventListenerArray) {
            assert (eventListenerArray != null) : "The array can't be null";
            this.array = eventListenerArray;
        }

        @Override
        public E get(int n) {
            if (n >= 0 && n < this.array.length) {
                EventListener eventListener = this.array[n];
                return (E)eventListener;
            }
            throw new IndexOutOfBoundsException("index = " + n + ", size = " + this.array.length);
        }

        @Override
        public int size() {
            return this.array.length;
        }

        public EventListener[] getArray() {
            return this.array;
        }
    }
}

