/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.awt.Color;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.export.ooxml.Utility;

public class DocxBorderInfo {
    protected static final String[] BORDER = new String[]{"top", "left", "bottom", "right"};
    protected static final int TOP_BORDER = 0;
    protected static final int LEFT_BORDER = 1;
    protected static final int BOTTOM_BORDER = 2;
    protected static final int RIGHT_BORDER = 3;
    protected Color[] borderColor = new Color[4];
    protected String[] borderWidth = new String[4];
    protected String[] borderStyle = new String[4];
    protected String[] borderPadding = new String[4];

    public DocxBorderInfo(JRLineBox box) {
        this.setBorder(box.getTopPen(), 0);
        this.borderPadding[0] = String.valueOf(Utility.twip(box.getTopPadding().intValue()));
        this.setBorder(box.getLeftPen(), 1);
        this.borderPadding[1] = String.valueOf(Utility.twip(box.getLeftPadding().intValue()));
        this.setBorder(box.getBottomPen(), 2);
        this.borderPadding[2] = String.valueOf(Utility.twip(box.getBottomPadding().intValue()));
        this.setBorder(box.getRightPen(), 3);
        this.borderPadding[3] = String.valueOf(Utility.twip(box.getRightPadding().intValue()));
    }

    public DocxBorderInfo(JRPen pen) {
        if (this.borderWidth[0] == null && this.borderWidth[1] == null && this.borderWidth[2] == null && this.borderWidth[3] == null) {
            this.setBorder(pen, 0);
            this.setBorder(pen, 1);
            this.setBorder(pen, 2);
            this.setBorder(pen, 3);
        }
    }

    protected boolean hasBorder() {
        return this.borderWidth[0] != null || this.borderWidth[1] != null || this.borderWidth[2] != null || this.borderWidth[3] != null;
    }

    private void setBorder(JRPen pen, int side) {
        float width = pen.getLineWidth() == null ? 0.0f : pen.getLineWidth().floatValue();
        String style = null;
        if (width > 0.0f) {
            switch (pen.getLineStyle()) {
                case 2: {
                    style = "dotted";
                    break;
                }
                case 1: {
                    style = "dashSmallGap";
                    break;
                }
                default: {
                    style = "single";
                }
            }
            this.borderWidth[side] = String.valueOf(Utility.halfPoint(width));
        } else {
            style = "none";
        }
        this.borderStyle[side] = style;
        this.borderColor[side] = pen.getLineColor();
    }
}

