/*
 * Decompiled with CFR 0.152.
 */
package mondrian.test;

import java.util.Random;
import junit.framework.Assert;
import mondrian.olap.CacheControl;
import mondrian.olap.Connection;
import mondrian.olap.Query;
import mondrian.olap.Result;
import mondrian.olap.Util;
import mondrian.test.FoodMartTestCase;

public class ParallelTest
extends FoodMartTestCase {
    public ParallelTest(String name) {
        super(name);
    }

    public void testParallelSchemaFlush() {
        this.checkSchemaFlush(5, 8, 10);
    }

    private void checkSchemaFlush(int count, final int cycleCount, final int flushInverseFrequency) {
        int i;
        final Random random = new Random(123456L);
        Worker[] workers = new Worker[count];
        Thread[] threads = new Thread[count];
        for (i = 0; i < count; ++i) {
            workers[i] = new Worker(){

                public void runSafe() {
                    for (int i = 0; i < cycleCount; ++i) {
                        this.cycle();
                        try {
                            Thread.sleep(random.nextInt(100));
                            continue;
                        }
                        catch (InterruptedException e) {
                            throw Util.newInternal(e, "interrupted");
                        }
                    }
                }

                private void cycle() {
                    Connection connection = ParallelTest.this.getConnection();
                    Query query = connection.parseQuery("select {[Measures].[Unit Sales]} on columns, {[Product].Members} on rows from [Sales]");
                    Result result = connection.execute(query);
                    String s = result.toString();
                    Assert.assertNotNull((Object)s);
                    if (random.nextInt(flushInverseFrequency) == 0) {
                        CacheControl cacheControl = connection.getCacheControl(null);
                        cacheControl.flushSchemaCache();
                    }
                }
            };
            threads[i] = new Thread(workers[i]);
        }
        for (i = 0; i < count; ++i) {
            threads[i].start();
        }
        for (i = 0; i < count; ++i) {
            try {
                threads[i].join();
                continue;
            }
            catch (InterruptedException e) {
                throw Util.newInternal(e, "while joining thread #" + i);
            }
        }
    }

    private static abstract class Worker
    implements Runnable {
        Throwable throwable;

        private Worker() {
        }

        public void run() {
            try {
                this.runSafe();
            }
            catch (Throwable e) {
                this.throwable = e;
            }
        }

        public abstract void runSafe();
    }
}

