/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.diff;

import java.beans.PropertyChangeListener;
import java.io.IOException;
import javax.swing.JComponent;
import org.netbeans.api.diff.Diff;
import org.netbeans.api.diff.DiffView;
import org.netbeans.api.diff.StreamSource;
import org.netbeans.spi.diff.DiffControllerImpl;
import org.netbeans.spi.diff.DiffControllerProvider;
import org.openide.util.Lookup;

public final class DiffController {
    public static final String PROP_DIFFERENCES = "(void) differencesChanged";
    private final DiffControllerImpl impl;

    public static DiffController create(StreamSource streamSource, StreamSource streamSource2) throws IOException {
        DiffControllerProvider diffControllerProvider = (DiffControllerProvider)Lookup.getDefault().lookup(DiffControllerProvider.class);
        if (diffControllerProvider != null) {
            return new DiffController(diffControllerProvider.createDiffController(streamSource, streamSource2));
        }
        DiffView diffView = Diff.getDefault().createDiff(streamSource, streamSource2);
        return new DiffController(new DiffControllerViewBridge(diffView));
    }

    private DiffController(DiffControllerImpl diffControllerImpl) {
        this.impl = diffControllerImpl;
    }

    public void setLocation(DiffPane diffPane, LocationType locationType, int n) {
        this.impl.setLocation(diffPane, locationType, n);
    }

    public JComponent getJComponent() {
        return this.impl.getJComponent();
    }

    public int getDifferenceCount() {
        return this.impl.getDifferenceCount();
    }

    public int getDifferenceIndex() {
        return this.impl.getDifferenceIndex();
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.impl.removePropertyChangeListener(propertyChangeListener);
    }

    private static class DiffControllerViewBridge
    extends DiffControllerImpl {
        private final DiffView view;

        DiffControllerViewBridge(DiffView diffView) {
            this.view = diffView;
        }

        public void setLocation(DiffPane diffPane, LocationType locationType, int n) {
            if (locationType == LocationType.DifferenceIndex) {
                this.view.setCurrentDifference(n);
            }
        }

        public JComponent getJComponent() {
            return (JComponent)this.view.getComponent();
        }

        public int getDifferenceCount() {
            return this.view.getDifferenceCount();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LocationType {
        LineNumber,
        DifferenceIndex;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DiffPane {
        Base,
        Modified;

    }
}

