/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.List;
import junit.framework.Assert;
import mondrian.olap.Member;
import mondrian.olap.Position;
import mondrian.olap.fun.TestMember;
import mondrian.rolap.RolapAxis;
import mondrian.test.FoodMartTestCase;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapAxisTest
extends FoodMartTestCase {
    public RolapAxisTest() {
    }

    public RolapAxisTest(String name) {
        super(name);
    }

    public void testMemberList() {
        ArrayList<Member> list = new ArrayList<Member>();
        list.add(new TestMember("a"));
        list.add(new TestMember("b"));
        list.add(new TestMember("c"));
        list.add(new TestMember("d"));
        StringBuffer buf = new StringBuffer(100);
        RolapAxis.MemberList axis = new RolapAxis.MemberList(list);
        List<Position> positions = ((RolapAxis)axis).getPositions();
        boolean firstTimeInner = true;
        for (Position position : positions) {
            if (!firstTimeInner) {
                buf.append(',');
            }
            buf.append(this.toString(position));
            firstTimeInner = false;
        }
        String s = buf.toString();
        String e = "{a},{b},{c},{d}";
        Assert.assertEquals((String)s, (String)e);
        positions = ((RolapAxis)axis).getPositions();
        int size = positions.size();
        Assert.assertEquals((int)size, (int)4);
        buf.setLength(0);
        for (int i = 0; i < size; ++i) {
            Position position = positions.get(i);
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.toString(position));
        }
        s = buf.toString();
        e = "{a},{b},{c},{d}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testMemberArrayList() {
        ArrayList<Member[]> list = new ArrayList<Member[]>();
        list.add(new Member[]{new TestMember("a"), new TestMember("b"), new TestMember("c")});
        list.add(new Member[]{new TestMember("d"), new TestMember("e"), new TestMember("f")});
        list.add(new Member[]{new TestMember("g"), new TestMember("h"), new TestMember("i")});
        StringBuffer buf = new StringBuffer(100);
        RolapAxis.MemberArrayList axis = new RolapAxis.MemberArrayList(list);
        List<Position> positions = ((RolapAxis)axis).getPositions();
        boolean firstTimeInner = true;
        for (Position position : positions) {
            if (!firstTimeInner) {
                buf.append(',');
            }
            buf.append(this.toString(position));
            firstTimeInner = false;
        }
        String s = buf.toString();
        String e = "{a,b,c},{d,e,f},{g,h,i}";
        Assert.assertEquals((String)s, (String)e);
        positions = ((RolapAxis)axis).getPositions();
        int size = positions.size();
        Assert.assertEquals((int)size, (int)3);
        buf.setLength(0);
        for (int i = 0; i < size; ++i) {
            Position position = positions.get(i);
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.toString(position));
        }
        s = buf.toString();
        e = "{a,b,c},{d,e,f},{g,h,i}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testMemberIterable() {
        ArrayList<Member> list = new ArrayList<Member>();
        list.add(new TestMember("a"));
        list.add(new TestMember("b"));
        list.add(new TestMember("c"));
        list.add(new TestMember("d"));
        StringBuffer buf = new StringBuffer(100);
        RolapAxis.MemberIterable axis = new RolapAxis.MemberIterable(list);
        List<Position> positions = ((RolapAxis)axis).getPositions();
        boolean firstTimeInner = true;
        for (Position position : positions) {
            if (!firstTimeInner) {
                buf.append(',');
            }
            buf.append(this.toString(position));
            firstTimeInner = false;
        }
        String s = buf.toString();
        String e = "{a},{b},{c},{d}";
        Assert.assertEquals((String)s, (String)e);
        positions = ((RolapAxis)axis).getPositions();
        int size = positions.size();
        Assert.assertEquals((int)size, (int)4);
        buf.setLength(0);
        for (int i = 0; i < size; ++i) {
            Position position = positions.get(i);
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.toString(position));
        }
        s = buf.toString();
        e = "{a},{b},{c},{d}";
        Assert.assertEquals((String)s, (String)e);
    }

    public void testMemberArrayIterable() {
        ArrayList<Member[]> list = new ArrayList<Member[]>();
        list.add(new Member[]{new TestMember("a"), new TestMember("b"), new TestMember("c")});
        list.add(new Member[]{new TestMember("d"), new TestMember("e"), new TestMember("f")});
        list.add(new Member[]{new TestMember("g"), new TestMember("h"), new TestMember("i")});
        StringBuffer buf = new StringBuffer(100);
        RolapAxis.MemberArrayIterable axis = new RolapAxis.MemberArrayIterable(list);
        List<Position> positions = ((RolapAxis)axis).getPositions();
        boolean firstTimeInner = true;
        for (Position position : positions) {
            if (!firstTimeInner) {
                buf.append(',');
            }
            buf.append(this.toString(position));
            firstTimeInner = false;
        }
        String s = buf.toString();
        String e = "{a,b,c},{d,e,f},{g,h,i}";
        Assert.assertEquals((String)s, (String)e);
        positions = ((RolapAxis)axis).getPositions();
        int size = positions.size();
        Assert.assertEquals((int)size, (int)3);
        buf.setLength(0);
        for (int i = 0; i < size; ++i) {
            Position position = positions.get(i);
            if (i > 0) {
                buf.append(',');
            }
            buf.append(this.toString(position));
        }
        s = buf.toString();
        e = "{a,b,c},{d,e,f},{g,h,i}";
        Assert.assertEquals((String)s, (String)e);
    }

    protected String toString(List<Member> position) {
        StringBuffer buf = new StringBuffer(100);
        buf.append('{');
        boolean firstTimeInner = true;
        for (Member m : position) {
            if (!firstTimeInner) {
                buf.append(',');
            }
            buf.append(m);
            firstTimeInner = false;
        }
        buf.append('}');
        return buf.toString();
    }
}

