/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.spi.project.support;

import java.beans.PropertyChangeListener;
import java.io.File;
import javax.swing.Icon;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

public class GenericSources {
    private GenericSources() {
    }

    public static Sources genericOnly(Project project) {
        return new GenericOnlySources(project);
    }

    public static SourceGroup group(Project project, FileObject fileObject, String string, String string2, Icon icon, Icon icon2) {
        if (string == null) {
            throw new NullPointerException("Cannot specify a null name for a source group");
        }
        return new Group(project, fileObject, string, string2, icon, icon2);
    }

    private static final class Group
    implements SourceGroup {
        private final Project p;
        private final FileObject rootFolder;
        private final String name;
        private final String displayName;
        private final Icon icon;
        private final Icon openedIcon;

        Group(Project project, FileObject fileObject, String string, String string2, Icon icon, Icon icon2) {
            this.p = project;
            this.rootFolder = fileObject;
            this.name = string;
            this.displayName = string2;
            this.icon = icon;
            this.openedIcon = icon2;
        }

        public FileObject getRootFolder() {
            return this.rootFolder;
        }

        public String getName() {
            return this.name;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public Icon getIcon(boolean bl) {
            return bl ? this.icon : this.openedIcon;
        }

        public boolean contains(FileObject fileObject) throws IllegalArgumentException {
            File file;
            if (fileObject != this.rootFolder && !FileUtil.isParentOf((FileObject)this.rootFolder, (FileObject)fileObject)) {
                throw new IllegalArgumentException();
            }
            if (this.p != null) {
                if (fileObject.isFolder() && fileObject != this.p.getProjectDirectory() && ProjectManager.getDefault().isProject(fileObject)) {
                    return false;
                }
                if (FileOwnerQuery.getOwner(fileObject) != this.p) {
                    return false;
                }
            }
            if ((file = FileUtil.toFile((FileObject)fileObject)) != null) {
                return SharabilityQuery.getSharability((File)file) != 2;
            }
            return true;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        public String toString() {
            return "GenericSources.Group[name=" + this.name + ",rootFolder=" + this.rootFolder + "]";
        }
    }

    private static final class GenericOnlySources
    implements Sources {
        private final Project p;

        GenericOnlySources(Project project) {
            this.p = project;
        }

        public SourceGroup[] getSourceGroups(String string) {
            if (string.equals("generic")) {
                return new SourceGroup[]{GenericSources.group(this.p, this.p.getProjectDirectory(), "generic", ProjectUtils.getInformation(this.p).getDisplayName(), null, null)};
            }
            return new SourceGroup[0];
        }

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }
    }
}

