/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.url;

import java.io.IOException;
import org.netbeans.modules.url.EncodingQueryImpl;
import org.netbeans.modules.url.URLDataObject;
import org.netbeans.spi.queries.FileEncodingQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObjectExistsException;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.loaders.UniFileLoader;
import org.openide.util.NbBundle;

public class URLDataLoader
extends UniFileLoader {
    static final long serialVersionUID = -7407252842873642582L;
    private static final String URL_MIME_TYPE = "text/url";
    private static final String PROP_ENCODING_QUERY_IMPL = "org.netbeans.modules.url.encoding";

    public URLDataLoader() {
        super("org.netbeans.modules.url.URLDataObject");
    }

    FileEncodingQueryImplementation getEncoding() {
        return (FileEncodingQueryImplementation)this.getProperty(PROP_ENCODING_QUERY_IMPL);
    }

    protected void initialize() {
        block2: {
            super.initialize();
            ExtensionList extensionList = new ExtensionList();
            extensionList.addMimeType(URL_MIME_TYPE);
            extensionList.addMimeType("text/x-url");
            this.setExtensions(extensionList);
            try {
                this.putProperty(PROP_ENCODING_QUERY_IMPL, (Object)new EncodingQueryImpl());
            }
            catch (IllegalArgumentException illegalArgumentException) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(URLDataLoader.class, (String)"PROP_URLLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/url/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject fileObject) throws DataObjectExistsException, IOException {
        return new URLDataObject(fileObject, (MultiFileLoader)this);
    }
}

