/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders;

import com.jaspersoft.ireport.designer.FieldsProvider;
import com.jaspersoft.ireport.designer.FieldsProviderEditor;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.connection.JDBCNBConnection;
import com.jaspersoft.ireport.designer.data.ReportQueryDialog;
import com.jaspersoft.ireport.designer.data.fieldsproviders.QueryBuilderDialog;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Dialog;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JDialog;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRQueryChunk;
import net.sf.jasperreports.engine.design.JRDesignField;

public class SQLFieldsProvider
implements FieldsProvider {
    public static boolean useVisualDesigner = true;

    public boolean supportsGetFieldsOperation() {
        return true;
    }

    public JRField[] getFields(IReportConnection irConn, JRDataset reportDataset, Map parameters) throws JRException, UnsupportedOperationException {
        if (irConn == null || !irConn.isJDBCConnection()) {
            throw new JRException("The active connection is not of type JDBC. Activate a JDBC connection first.");
        }
        String query = "";
        String error_msg = "";
        Connection con = null;
        Statement ps = null;
        if (reportDataset.getQuery() == null || reportDataset.getQuery().getText() == null || reportDataset.getQuery().getText().length() == 0) {
            return new JRField[0];
        }
        try {
            StringBuffer queryBuf = new StringBuffer("");
            JRQueryChunk[] chunks = reportDataset.getQuery().getChunks();
            ArrayList<Object> queryParams = new ArrayList<Object>();
            block25: for (int i = 0; i < chunks.length; ++i) {
                switch (chunks[i].getType()) {
                    case 1: {
                        queryBuf.append(chunks[i].getText());
                        continue block25;
                    }
                    case 3: {
                        String paramName = chunks[i].getText();
                        if (!parameters.containsKey(paramName)) {
                            throw new IllegalArgumentException("The parameter '" + paramName + "' is not defined.");
                        }
                        Object defValue = parameters.get(paramName);
                        if (defValue == null) {
                            throw new IllegalArgumentException("Please set a default value for the parameter '" + paramName + "'");
                        }
                        queryBuf.append(defValue.toString());
                        continue block25;
                    }
                    case 2: {
                        String paramName = chunks[i].getText();
                        if (!parameters.containsKey(paramName)) {
                            throw new IllegalArgumentException("The parameter '" + paramName + "' is not defined.");
                        }
                        Object defValue = parameters.get(paramName);
                        queryBuf.append("?");
                        queryParams.add(defValue);
                        continue block25;
                    }
                    case 4: {
                        String[] tokens = chunks[i].getTokens();
                        if (tokens.length == 3) {
                            String clauseText = "";
                            clauseText = tokens[1].trim() + " " + tokens[0].trim() + " (";
                            String paramName = tokens[2].trim();
                            if (parameters.containsKey(paramName)) {
                                Object defValue = parameters.get(paramName);
                                if (defValue == null) {
                                    clauseText = "0 = 0";
                                } else {
                                    List<Object> items = new ArrayList();
                                    if (defValue.getClass().isArray()) {
                                        items = Arrays.asList((Object[])defValue);
                                    } else if (defValue instanceof Collection) {
                                        items.addAll((Collection)defValue);
                                    } else {
                                        items.add(defValue);
                                    }
                                    Iterator<Object> iter = items.iterator();
                                    if (iter.hasNext()) {
                                        Object itemVal = iter.next();
                                        queryBuf.append("?");
                                        queryParams.add(itemVal);
                                        while (iter.hasNext()) {
                                            itemVal = iter.next();
                                            clauseText = clauseText + ",?";
                                            queryParams.add(itemVal);
                                        }
                                        clauseText = clauseText + ")";
                                    } else {
                                        clauseText = "0 = 0";
                                    }
                                }
                                queryBuf.append(clauseText);
                                continue block25;
                            }
                            throw new IllegalArgumentException("The parameter '" + paramName + "' is not defined.");
                        }
                        throw new IllegalArgumentException("Invalid $X{} clause");
                    }
                }
            }
            query = queryBuf.toString();
            con = irConn.getConnection();
            System.out.println("Connection: " + con + "  Query: " + query);
            System.out.flush();
            ps = con.prepareStatement(query);
            for (int pc = 0; pc < queryParams.size(); ++pc) {
                if (queryParams.get(pc) == null) {
                    ps.setNull(pc + 1, -7);
                    continue;
                }
                Class<?> parameterType = queryParams.get(pc).getClass();
                if (Boolean.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, -7);
                        continue;
                    }
                    ps.setBoolean(pc + 1, (Boolean)queryParams.get(pc));
                    continue;
                }
                if (Byte.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, -6);
                        continue;
                    }
                    ps.setByte(pc + 1, (Byte)queryParams.get(pc));
                    continue;
                }
                if (Double.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 8);
                        continue;
                    }
                    ps.setDouble(pc + 1, (Double)queryParams.get(pc));
                    continue;
                }
                if (Float.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 6);
                        continue;
                    }
                    ps.setFloat(pc + 1, ((Float)queryParams.get(pc)).floatValue());
                    continue;
                }
                if (Integer.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 4);
                        continue;
                    }
                    ps.setInt(pc + 1, (Integer)queryParams.get(pc));
                    continue;
                }
                if (Long.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, -5);
                        continue;
                    }
                    ps.setLong(pc + 1, (Long)queryParams.get(pc));
                    continue;
                }
                if (Short.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 5);
                        continue;
                    }
                    ps.setShort(pc + 1, (Short)queryParams.get(pc));
                    continue;
                }
                if (BigDecimal.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 3);
                        continue;
                    }
                    ps.setBigDecimal(pc + 1, (BigDecimal)queryParams.get(pc));
                    continue;
                }
                if (String.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 12);
                        continue;
                    }
                    ps.setString(pc + 1, queryParams.get(pc).toString());
                    continue;
                }
                if (Timestamp.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 93);
                        continue;
                    }
                    ps.setTimestamp(pc + 1, (Timestamp)queryParams.get(pc));
                    continue;
                }
                if (Time.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 92);
                        continue;
                    }
                    ps.setTime(pc + 1, (Time)queryParams.get(pc));
                    continue;
                }
                if (java.util.Date.class.isAssignableFrom(parameterType)) {
                    if (queryParams.get(pc) == null) {
                        ps.setNull(pc + 1, 91);
                        continue;
                    }
                    ps.setDate(pc + 1, new Date(((java.util.Date)queryParams.get(pc)).getTime()));
                    continue;
                }
                if (queryParams.get(pc) == null) {
                    ps.setNull(pc + 1, 2000);
                    continue;
                }
                ps.setObject(pc + 1, queryParams.get(pc));
            }
            try {
                ps.setFetchSize(0);
            }
            catch (Exception e) {
                // empty catch block
            }
            ResultSet rs = ps.executeQuery();
            ResultSetMetaData rsmd = rs.getMetaData();
            ArrayList<JRDesignField> columns = new ArrayList<JRDesignField>();
            for (int i = 1; i <= rsmd.getColumnCount(); ++i) {
                JRDesignField field = new JRDesignField();
                field.setName(rsmd.getColumnLabel(i));
                field.setValueClassName(Misc.getJdbcTypeClass(rsmd, i));
                field.setDescription("");
                columns.add(field);
            }
            JRField[] final_fields = new JRField[columns.size()];
            for (int i = 0; i < final_fields.length; ++i) {
                final_fields[i] = (JRField)columns.get(i);
            }
            JRField[] jRFieldArray = final_fields;
            return jRFieldArray;
        }
        catch (IllegalArgumentException ie) {
            throw new JRException(ie.getMessage());
        }
        catch (NoClassDefFoundError ex) {
            ex.printStackTrace();
            error_msg = "NoClassDefFoundError!!\nCheck your classpath!";
            throw new JRException(error_msg);
        }
        catch (SQLException ex) {
            error_msg = "SQL problems:\n" + ex.getMessage();
            throw new JRException(error_msg);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            error_msg = "General problem:\n" + ex.getMessage() + "\n\nCheck username and password; is the DBMS active ?!";
            throw new JRException(error_msg);
        }
        catch (Throwable t) {
            t.printStackTrace();
            throw new JRException(t.getMessage());
        }
        finally {
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (Exception e) {}
            }
            if (con != null && !(irConn instanceof JDBCNBConnection)) {
                try {
                    con.close();
                }
                catch (Exception e) {}
            }
        }
    }

    public boolean supportsAutomaticQueryExecution() {
        return true;
    }

    public boolean hasQueryDesigner() {
        return useVisualDesigner;
    }

    public boolean hasEditorComponent() {
        return false;
    }

    public String designQuery(IReportConnection con, String query, ReportQueryDialog reportQueryDialog) throws JRException, UnsupportedOperationException {
        QueryBuilderDialog qbd = new QueryBuilderDialog((Dialog)(reportQueryDialog != null ? reportQueryDialog : new JDialog()), true);
        if (con.isJDBCConnection()) {
            qbd.setConnection(con.getConnection());
        }
        try {
            if (query != null && query.length() > 0) {
                qbd.setQuery(query);
            }
        }
        catch (Throwable ex) {
            if (reportQueryDialog != null) {
                reportQueryDialog.getJLabelStatusSQL().setText("I'm sorry, I'm unable to parse the query...");
                ex.printStackTrace();
            }
            ex.printStackTrace();
            return null;
        }
        qbd.setVisible(true);
        if (qbd.getDialogResult() == 0) {
            return qbd.getQuery();
        }
        return null;
    }

    public FieldsProviderEditor getEditorComponent(ReportQueryDialog reportQueryDialog) {
        return null;
    }
}

