/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.toolbars;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ReportClassLoader;
import com.jaspersoft.ireport.designer.outline.nodes.ElementNode;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.toolbars.FontListCellRenderer;
import com.jaspersoft.ireport.designer.toolbars.WideComboBox;
import com.jaspersoft.ireport.designer.tools.JNumberComboBox;
import com.jaspersoft.ireport.designer.tools.ValueChangedEvent;
import com.jaspersoft.ireport.designer.tools.ValueChangedListener;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import net.sf.jasperreports.engine.design.JRDesignTextElement;
import net.sf.jasperreports.engine.util.JRFontUtil;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextElementsToolbar
extends JPanel
implements LookupListener,
PropertyChangeListener,
PreferenceChangeListener {
    private final Lookup.Result<ElementNode> result;
    private List<JRDesignTextElement> selectedTextElements = new ArrayList<JRDesignTextElement>();
    private boolean init = false;
    private boolean changing = false;
    Integer[] predefinedFontSizes = new Integer[]{3, 5, 8, 10, 12, 14, 24, 36, 48};
    private ButtonGroup buttonGroupHorizontalAlign;
    private ButtonGroup buttonGroupVerticalAlign;
    private JButton jButtonDecreaseFont;
    private JButton jButtonIncreaseFont;
    private JComboBox jComboBoxFontName;
    private JComboBox jComboBoxFontSize;
    private JPanel jPanelFiller;
    private JToolBar.Separator jSeparator1;
    private JToggleButton jToggleButtonAlignBottom;
    private JToggleButton jToggleButtonAlignCenter;
    private JToggleButton jToggleButtonAlignJustify;
    private JToggleButton jToggleButtonAlignLeft;
    private JToggleButton jToggleButtonAlignMiddle;
    private JToggleButton jToggleButtonAlignRight;
    private JToggleButton jToggleButtonAlignTop;
    private JToggleButton jToggleButtonBold;
    private JToggleButton jToggleButtonItalic;
    private JToggleButton jToggleButtonStriketrought;
    private JToggleButton jToggleButtonUnderline;
    private JToolBar jToolBar1;

    public TextElementsToolbar() {
        this.setInit(true);
        this.initComponents();
        this.updateFonts();
        ((JNumberComboBox)this.jComboBoxFontSize).addValueChangedListener(new ValueChangedListener(){

            public void valueChanged(ValueChangedEvent evt) {
                if (TextElementsToolbar.this.isInit()) {
                    return;
                }
                TextElementsToolbar.this.fontSizeSelected();
            }
        });
        this.jComboBoxFontName.setRenderer(new FontListCellRenderer());
        this.setInit(false);
        IReportManager.getPreferences().addPreferenceChangeListener(this);
        this.result = Utilities.actionsGlobalContext().lookup(new Lookup.Template(ElementNode.class));
        this.result.addLookupListener((LookupListener)this);
        this.result.allItems();
        this.resultChanged(null);
    }

    public void updateFonts() {
        this.init = true;
        String selectedFont = null;
        if (this.jComboBoxFontName.getSelectedItem() != null) {
            selectedFont = this.jComboBoxFontName.getSelectedItem() instanceof Tag ? (String)((Tag)this.jComboBoxFontName.getSelectedItem()).getValue() : "" + this.jComboBoxFontName.getSelectedItem();
        }
        this.jComboBoxFontName.removeAllItems();
        ArrayList<Tag> classes = new ArrayList<Tag>();
        ClassLoader oldCL = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(new ReportClassLoader(IReportManager.getReportClassLoader()));
        Collection extensionFonts = JRFontUtil.getFontFamilyNames();
        for (String fname : extensionFonts) {
            classes.add(new Tag(fname));
        }
        Thread.currentThread().setContextClassLoader(oldCL);
        classes.add(new Tag(null, "--"));
        if (IReportManager.getPreferences().getBoolean("showSystemFonts", true)) {
            String[] names = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
            for (int i = 0; i < names.length; ++i) {
                String name = names[i];
                classes.add(new Tag(name));
            }
        }
        this.jComboBoxFontName.setModel(new DefaultComboBoxModel<Object>(classes.toArray()));
        if (selectedFont != null) {
            Misc.setComboboxSelectedTagValue(this.jComboBoxFontName, selectedFont);
        }
        this.init = false;
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt == null || evt.getKey() == null || evt.getKey().equals("IREPORT_CLASSPATH")) {
            this.updateFonts();
        }
    }

    private void initComponents() {
        this.buttonGroupHorizontalAlign = new ButtonGroup();
        this.buttonGroupVerticalAlign = new ButtonGroup();
        this.jToolBar1 = new JToolBar();
        this.jComboBoxFontName = new WideComboBox();
        this.jComboBoxFontSize = new JNumberComboBox();
        this.jButtonIncreaseFont = new JButton();
        this.jButtonDecreaseFont = new JButton();
        this.jSeparator1 = new JToolBar.Separator();
        this.jToggleButtonBold = new JToggleButton();
        this.jToggleButtonItalic = new JToggleButton();
        this.jToggleButtonUnderline = new JToggleButton();
        this.jToggleButtonStriketrought = new JToggleButton();
        this.jToggleButtonAlignLeft = new JToggleButton();
        this.jToggleButtonAlignJustify = new JToggleButton();
        this.jToggleButtonAlignCenter = new JToggleButton();
        this.jToggleButtonAlignRight = new JToggleButton();
        this.jToggleButtonAlignTop = new JToggleButton();
        this.jToggleButtonAlignMiddle = new JToggleButton();
        this.jToggleButtonAlignBottom = new JToggleButton();
        this.jPanelFiller = new JPanel();
        this.setMaximumSize(new Dimension(700, 23));
        this.setMinimumSize(new Dimension(610, 23));
        this.setPreferredSize(new Dimension(710, 23));
        this.setLayout(new GridBagLayout());
        this.jToolBar1.setFloatable(false);
        this.jToolBar1.setRollover(true);
        this.jToolBar1.setMaximumSize(new Dimension(700, 32769));
        this.jToolBar1.setMinimumSize(new Dimension(600, 25));
        this.jToolBar1.setOpaque(false);
        this.jToolBar1.setPreferredSize(new Dimension(700, 25));
        this.jComboBoxFontName.setEditable(true);
        this.jComboBoxFontName.setMaximumRowCount(20);
        this.jComboBoxFontName.setMaximumSize(new Dimension(140, 22));
        this.jComboBoxFontName.setMinimumSize(new Dimension(140, 22));
        this.jComboBoxFontName.setPreferredSize(new Dimension(170, 22));
        this.jComboBoxFontName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextElementsToolbar.this.jComboBoxFontNameActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxFontName);
        this.jComboBoxFontSize.setEditable(true);
        this.jComboBoxFontSize.setMaximumSize(new Dimension(50, 22));
        this.jComboBoxFontSize.setMinimumSize(new Dimension(51, 22));
        this.jComboBoxFontSize.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextElementsToolbar.this.jComboBoxFontSizeActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jComboBoxFontSize);
        this.jButtonIncreaseFont.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/increase_font_size.png")));
        this.jButtonIncreaseFont.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jButtonIncreaseFont.text"));
        this.jButtonIncreaseFont.setBorderPainted(false);
        this.jButtonIncreaseFont.setFocusable(false);
        this.jButtonIncreaseFont.setHorizontalTextPosition(0);
        this.jButtonIncreaseFont.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonIncreaseFont.setMaximumSize(new Dimension(23, 23));
        this.jButtonIncreaseFont.setMinimumSize(new Dimension(23, 23));
        this.jButtonIncreaseFont.setPreferredSize(new Dimension(23, 23));
        this.jButtonIncreaseFont.setVerticalTextPosition(3);
        this.jButtonIncreaseFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextElementsToolbar.this.jButtonIncreaseFontActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonIncreaseFont);
        this.jButtonDecreaseFont.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/decrease_font_size.png")));
        this.jButtonDecreaseFont.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jButtonDecreaseFont.text"));
        this.jButtonDecreaseFont.setBorderPainted(false);
        this.jButtonDecreaseFont.setFocusable(false);
        this.jButtonDecreaseFont.setHorizontalTextPosition(0);
        this.jButtonDecreaseFont.setMargin(new Insets(0, 0, 0, 0));
        this.jButtonDecreaseFont.setMaximumSize(new Dimension(23, 23));
        this.jButtonDecreaseFont.setMinimumSize(new Dimension(23, 23));
        this.jButtonDecreaseFont.setPreferredSize(new Dimension(23, 23));
        this.jButtonDecreaseFont.setVerticalTextPosition(3);
        this.jButtonDecreaseFont.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextElementsToolbar.this.jButtonDecreaseFontActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jButtonDecreaseFont);
        this.jToolBar1.add(this.jSeparator1);
        this.jToggleButtonBold.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/bold.png")));
        this.jToggleButtonBold.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonBold.text"));
        this.jToggleButtonBold.setActionCommand(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonBold.actionCommand"));
        this.jToggleButtonBold.setFocusable(false);
        this.jToggleButtonBold.setHorizontalTextPosition(0);
        this.jToggleButtonBold.setVerticalTextPosition(3);
        this.jToggleButtonBold.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonBoldItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonBold);
        this.jToggleButtonItalic.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/italic.png")));
        this.jToggleButtonItalic.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonItalic.text"));
        this.jToggleButtonItalic.setBorderPainted(false);
        this.jToggleButtonItalic.setFocusable(false);
        this.jToggleButtonItalic.setHorizontalTextPosition(0);
        this.jToggleButtonItalic.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonItalic.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonItalic.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonItalic.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonItalic.setVerticalTextPosition(3);
        this.jToggleButtonItalic.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonItalicItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonItalic);
        this.jToggleButtonUnderline.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/underline.png")));
        this.jToggleButtonUnderline.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonUnderline.setBorderPainted(false);
        this.jToggleButtonUnderline.setFocusable(false);
        this.jToggleButtonUnderline.setHorizontalTextPosition(0);
        this.jToggleButtonUnderline.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonUnderline.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonUnderline.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonUnderline.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonUnderline.setVerticalTextPosition(3);
        this.jToggleButtonUnderline.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonUnderlineItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonUnderline);
        this.jToggleButtonStriketrought.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/strikethrought.png")));
        this.jToggleButtonStriketrought.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonStriketrought.setBorderPainted(false);
        this.jToggleButtonStriketrought.setFocusable(false);
        this.jToggleButtonStriketrought.setHorizontalTextPosition(0);
        this.jToggleButtonStriketrought.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonStriketrought.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonStriketrought.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonStriketrought.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonStriketrought.setVerticalTextPosition(3);
        this.jToggleButtonStriketrought.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TextElementsToolbar.this.jToggleButtonStriketroughtActionPerformed(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonStriketrought);
        this.buttonGroupHorizontalAlign.add(this.jToggleButtonAlignLeft);
        this.jToggleButtonAlignLeft.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/align_left.png")));
        this.jToggleButtonAlignLeft.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonAlignLeft.setBorderPainted(false);
        this.jToggleButtonAlignLeft.setFocusable(false);
        this.jToggleButtonAlignLeft.setHorizontalTextPosition(0);
        this.jToggleButtonAlignLeft.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonAlignLeft.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonAlignLeft.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonAlignLeft.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonAlignLeft.setVerticalTextPosition(3);
        this.jToggleButtonAlignLeft.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonAlignLeftItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAlignLeft);
        this.buttonGroupHorizontalAlign.add(this.jToggleButtonAlignJustify);
        this.jToggleButtonAlignJustify.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/align_justified.png")));
        this.jToggleButtonAlignJustify.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonAlignJustify.setBorderPainted(false);
        this.jToggleButtonAlignJustify.setFocusable(false);
        this.jToggleButtonAlignJustify.setHorizontalTextPosition(0);
        this.jToggleButtonAlignJustify.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonAlignJustify.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonAlignJustify.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonAlignJustify.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonAlignJustify.setVerticalTextPosition(3);
        this.jToggleButtonAlignJustify.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonAlignJustifyItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAlignJustify);
        this.buttonGroupHorizontalAlign.add(this.jToggleButtonAlignCenter);
        this.jToggleButtonAlignCenter.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/align_center.png")));
        this.jToggleButtonAlignCenter.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonAlignCenter.setBorderPainted(false);
        this.jToggleButtonAlignCenter.setFocusable(false);
        this.jToggleButtonAlignCenter.setHorizontalTextPosition(0);
        this.jToggleButtonAlignCenter.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonAlignCenter.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonAlignCenter.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonAlignCenter.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonAlignCenter.setVerticalTextPosition(3);
        this.jToggleButtonAlignCenter.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonAlignCenterItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAlignCenter);
        this.buttonGroupHorizontalAlign.add(this.jToggleButtonAlignRight);
        this.jToggleButtonAlignRight.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/align_right.png")));
        this.jToggleButtonAlignRight.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonAlignRight.setBorderPainted(false);
        this.jToggleButtonAlignRight.setFocusable(false);
        this.jToggleButtonAlignRight.setHorizontalTextPosition(0);
        this.jToggleButtonAlignRight.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonAlignRight.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonAlignRight.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonAlignRight.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonAlignRight.setVerticalTextPosition(3);
        this.jToggleButtonAlignRight.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonAlignRightItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAlignRight);
        this.buttonGroupVerticalAlign.add(this.jToggleButtonAlignTop);
        this.jToggleButtonAlignTop.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/align_top.png")));
        this.jToggleButtonAlignTop.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonAlignTop.setBorderPainted(false);
        this.jToggleButtonAlignTop.setFocusable(false);
        this.jToggleButtonAlignTop.setHorizontalTextPosition(0);
        this.jToggleButtonAlignTop.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonAlignTop.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonAlignTop.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonAlignTop.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonAlignTop.setVerticalTextPosition(3);
        this.jToggleButtonAlignTop.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonAlignTopItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAlignTop);
        this.buttonGroupVerticalAlign.add(this.jToggleButtonAlignMiddle);
        this.jToggleButtonAlignMiddle.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/align_middle.png")));
        this.jToggleButtonAlignMiddle.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonAlignMiddle.setBorderPainted(false);
        this.jToggleButtonAlignMiddle.setFocusable(false);
        this.jToggleButtonAlignMiddle.setHorizontalTextPosition(0);
        this.jToggleButtonAlignMiddle.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonAlignMiddle.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonAlignMiddle.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonAlignMiddle.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonAlignMiddle.setVerticalTextPosition(3);
        this.jToggleButtonAlignMiddle.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonAlignMiddleItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAlignMiddle);
        this.buttonGroupVerticalAlign.add(this.jToggleButtonAlignBottom);
        this.jToggleButtonAlignBottom.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/align_bottom.png")));
        this.jToggleButtonAlignBottom.setText(NbBundle.getMessage(TextElementsToolbar.class, (String)"TextElementsToolbar.jToggleButtonUnderline.text"));
        this.jToggleButtonAlignBottom.setBorderPainted(false);
        this.jToggleButtonAlignBottom.setFocusable(false);
        this.jToggleButtonAlignBottom.setHorizontalTextPosition(0);
        this.jToggleButtonAlignBottom.setMargin(new Insets(0, 0, 0, 0));
        this.jToggleButtonAlignBottom.setMaximumSize(new Dimension(23, 23));
        this.jToggleButtonAlignBottom.setMinimumSize(new Dimension(23, 23));
        this.jToggleButtonAlignBottom.setPreferredSize(new Dimension(23, 23));
        this.jToggleButtonAlignBottom.setVerticalTextPosition(3);
        this.jToggleButtonAlignBottom.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                TextElementsToolbar.this.jToggleButtonAlignBottomItemStateChanged(evt);
            }
        });
        this.jToolBar1.add(this.jToggleButtonAlignBottom);
        this.add((Component)this.jToolBar1, new GridBagConstraints());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.jPanelFiller, gridBagConstraints);
    }

    private void jComboBoxFontNameActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        boolean isFirstUndo = true;
        if (this.getSelectedTextElements().size() > 0) {
            String newFontName = null;
            if (this.jComboBoxFontName.getSelectedItem() instanceof Tag) {
                newFontName = (String)((Tag)this.jComboBoxFontName.getSelectedItem()).getValue();
                if (((Tag)this.jComboBoxFontName.getSelectedItem()).getName().equals("--")) {
                    this.resultChanged(null);
                    return;
                }
            } else {
                newFontName = "" + this.jComboBoxFontName.getSelectedItem();
            }
            if (newFontName != null && newFontName.length() > 0) {
                for (JRDesignTextElement element : this.getSelectedTextElements()) {
                    String oldFontName = element.getOwnFontName();
                    element.setFontName(newFontName);
                    ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "FontName", String.class, oldFontName, newFontName);
                    IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                    isFirstUndo = false;
                }
                if (this.jComboBoxFontName.getItemAt(0).equals("")) {
                    this.jComboBoxFontName.removeItemAt(0);
                }
            }
        }
        this.setChanging(oldChanging);
    }

    private void jComboBoxFontSizeActionPerformed(ActionEvent evt) {
    }

    private void jToggleButtonIncreaseFontActionPerformed(ActionEvent evt) {
    }

    private void jToggleButtonDecreaseFontActionPerformed(ActionEvent evt) {
    }

    private void jButtonIncreaseFontActionPerformed(ActionEvent evt) {
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                int newFontSize = element.getFontSize() + 2;
                Integer oldFontSize = element.getOwnFontSize();
                element.setFontSize(newFontSize);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "FontSize", Integer.class, oldFontSize, new Integer(newFontSize));
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
    }

    private void jButtonDecreaseFontActionPerformed(ActionEvent evt) {
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                int newFontSize = element.getFontSize() - 2;
                if (newFontSize < 3) continue;
                Integer oldFontSize = element.getOwnFontSize();
                element.setFontSize(newFontSize);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "FontSize", Integer.class, oldFontSize, new Integer(newFontSize));
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
    }

    private void jToggleButtonBoldItemStateChanged(ItemEvent evt) {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            boolean newValue = this.jToggleButtonBold.isSelected();
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                if (newValue == element.isBold()) continue;
                Boolean oldValue = element.isOwnBold();
                element.setBold(newValue);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "Bold", Boolean.class, oldValue, new Boolean(newValue));
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
        this.setChanging(oldChanging);
    }

    private void jToggleButtonItalicItemStateChanged(ItemEvent evt) {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            boolean newValue = this.jToggleButtonItalic.isSelected();
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                if (newValue == element.isItalic()) continue;
                Boolean oldValue = element.isOwnItalic();
                element.setItalic(newValue);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "Italic", Boolean.class, oldValue, new Boolean(newValue));
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
        this.setChanging(oldChanging);
    }

    private void jToggleButtonUnderlineItemStateChanged(ItemEvent evt) {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            boolean newValue = this.jToggleButtonUnderline.isSelected();
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                if (newValue == element.isUnderline()) continue;
                Boolean oldValue = element.isOwnUnderline();
                element.setUnderline(newValue);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "Underline", Boolean.class, oldValue, new Boolean(newValue));
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
        this.setChanging(oldChanging);
    }

    private void jToggleButtonStriketroughtActionPerformed(ActionEvent evt) {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            boolean newValue = this.jToggleButtonStriketrought.isSelected();
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                if (newValue == element.isStrikeThrough()) continue;
                Boolean oldValue = element.isOwnStrikeThrough();
                element.setStrikeThrough(newValue);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "StrikeThrough", Boolean.class, oldValue, new Boolean(newValue));
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
        this.setChanging(oldChanging);
    }

    private void jToggleButtonAlignLeftItemStateChanged(ItemEvent evt) {
        this.modifyHorizontalAlignment();
    }

    private void jToggleButtonAlignJustifyItemStateChanged(ItemEvent evt) {
        this.modifyHorizontalAlignment();
    }

    private void jToggleButtonAlignCenterItemStateChanged(ItemEvent evt) {
        this.modifyHorizontalAlignment();
    }

    private void jToggleButtonAlignRightItemStateChanged(ItemEvent evt) {
        this.modifyHorizontalAlignment();
    }

    private void jToggleButtonAlignTopItemStateChanged(ItemEvent evt) {
        this.modifyVerticalAlignment();
    }

    private void jToggleButtonAlignMiddleItemStateChanged(ItemEvent evt) {
        this.modifyVerticalAlignment();
    }

    private void jToggleButtonAlignBottomItemStateChanged(ItemEvent evt) {
        this.modifyVerticalAlignment();
    }

    private void modifyHorizontalAlignment() {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            Byte newValue = this.getSelectedHorizontalAlignment();
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                if ((newValue != null || element.getOwnHorizontalAlignment() == null) && (newValue == null || newValue.byteValue() == element.getHorizontalAlignment())) continue;
                Byte oldValue = element.getOwnHorizontalAlignment();
                element.setHorizontalAlignment(newValue);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "HorizontalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
        this.setChanging(oldChanging);
    }

    private void modifyVerticalAlignment() {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        if (this.getSelectedTextElements().size() > 0) {
            boolean isFirstUndo = true;
            Byte newValue = this.getSelectedVerticalAlignment();
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                if (newValue == null || newValue.byteValue() == element.getVerticalAlignment()) continue;
                Byte oldValue = element.getOwnVerticalAlignment();
                element.setVerticalAlignment(newValue);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "VerticalAlignment", Byte.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
        this.setChanging(oldChanging);
    }

    private void fontSizeSelected() {
        if (this.isInit()) {
            return;
        }
        boolean oldChanging = this.isChanging();
        this.setChanging(true);
        boolean isFirstUndo = true;
        if (this.getSelectedTextElements().size() > 0) {
            int newFontSize = (int)((JNumberComboBox)this.jComboBoxFontSize).getValue();
            for (JRDesignTextElement element : this.getSelectedTextElements()) {
                if (element.getFontSize() == newFontSize) continue;
                Integer oldFontSize = element.getOwnFontSize();
                element.setFontSize(newFontSize);
                ObjectPropertyUndoableEdit opUndo = new ObjectPropertyUndoableEdit(element, "FontSize", Integer.class, oldFontSize, new Integer(newFontSize));
                IReportManager.getInstance().addUndoableEdit(opUndo, !isFirstUndo);
                isFirstUndo = false;
            }
        }
        this.setChanging(oldChanging);
    }

    public List<JRDesignTextElement> getSelectedTextElements() {
        return this.selectedTextElements;
    }

    public void resultChanged(LookupEvent arg0) {
        this.setInit(true);
        for (JRDesignTextElement element : this.getSelectedTextElements()) {
            element.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        }
        this.selectedTextElements.clear();
        Collection nodes = this.result.allInstances();
        for (ElementNode en : nodes) {
            if (!(en.getElement() instanceof JRDesignTextElement)) continue;
            this.selectedTextElements.add((JRDesignTextElement)en.getElement());
        }
        for (JRDesignTextElement element : this.getSelectedTextElements()) {
            element.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
        this.updateButtons();
        this.setInit(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateButtons() {
        boolean oldInit = this.isInit();
        this.setInit(true);
        try {
            boolean enabled = this.getSelectedTextElements().size() > 0;
            this.jComboBoxFontName.setEnabled(enabled);
            this.jComboBoxFontSize.setEnabled(enabled);
            this.jToggleButtonAlignBottom.setEnabled(enabled);
            this.jToggleButtonAlignTop.setEnabled(enabled);
            this.jToggleButtonAlignMiddle.setEnabled(enabled);
            this.jToggleButtonAlignLeft.setEnabled(enabled);
            this.jToggleButtonAlignRight.setEnabled(enabled);
            this.jToggleButtonAlignCenter.setEnabled(enabled);
            this.jToggleButtonAlignJustify.setEnabled(enabled);
            this.jButtonDecreaseFont.setEnabled(enabled);
            this.jButtonIncreaseFont.setEnabled(enabled);
            this.jToggleButtonBold.setEnabled(enabled);
            this.jToggleButtonItalic.setEnabled(enabled);
            this.jToggleButtonStriketrought.setEnabled(enabled);
            this.jToggleButtonUnderline.setEnabled(enabled);
            if (this.jComboBoxFontName.getItemCount() == 0 || !this.jComboBoxFontName.getItemAt(0).equals("")) {
                this.jComboBoxFontName.insertItemAt("", 0);
            }
            if (enabled) {
                boolean sameFontName = true;
                boolean sameFontSize = true;
                boolean sameBold = true;
                boolean sameItalic = true;
                boolean sameStriketrough = true;
                boolean sameUnderline = true;
                boolean sameHorizontalAlignment = true;
                boolean sameVerticalAlignment = true;
                boolean isFirstElement = true;
                for (JRDesignTextElement element : this.getSelectedTextElements()) {
                    if (sameFontName) {
                        sameFontName = Misc.setComboBoxTag(isFirstElement, element.getFontName(), this.jComboBoxFontName);
                    }
                    if (sameFontSize) {
                        sameFontSize = Misc.setElementComboNumber(isFirstElement, element.getFontSize(), (JNumberComboBox)this.jComboBoxFontSize);
                    }
                    if (sameBold) {
                        sameBold = this.setToggleButton(isFirstElement, element.isBold(), this.jToggleButtonBold);
                    }
                    if (sameItalic) {
                        sameItalic = this.setToggleButton(isFirstElement, element.isItalic(), this.jToggleButtonItalic);
                    }
                    if (sameUnderline) {
                        sameUnderline = this.setToggleButton(isFirstElement, element.isUnderline(), this.jToggleButtonUnderline);
                    }
                    if (sameStriketrough) {
                        sameStriketrough = this.setToggleButton(isFirstElement, element.isStrikeThrough(), this.jToggleButtonStriketrought);
                    }
                    if (sameHorizontalAlignment) {
                        sameHorizontalAlignment = this.setHorizontalAlignment(isFirstElement, element.getHorizontalAlignment());
                    }
                    if (sameVerticalAlignment) {
                        sameVerticalAlignment = this.setVerticalAlignment(isFirstElement, element.getVerticalAlignment());
                    }
                    isFirstElement = false;
                }
            }
        }
        finally {
            this.setInit(oldInit);
        }
    }

    public boolean isInit() {
        return this.init;
    }

    public void setInit(boolean init) {
        this.init = init;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (!this.isChanging() && (evt.getPropertyName().equals("fontName") || evt.getPropertyName().equals("fontSize") || evt.getPropertyName().equals("bold") || evt.getPropertyName().equals("italic") || evt.getPropertyName().equals("strikeThrough") || evt.getPropertyName().equals("underline") || evt.getPropertyName().equals("horizontalAlignment") || evt.getPropertyName().equals("verticalAlignment"))) {
            this.updateButtons();
        }
    }

    private Byte getSelectedHorizontalAlignment() {
        if (this.jToggleButtonAlignLeft.isSelected()) {
            return (byte)1;
        }
        if (this.jToggleButtonAlignRight.isSelected()) {
            return (byte)3;
        }
        if (this.jToggleButtonAlignJustify.isSelected()) {
            return (byte)4;
        }
        if (this.jToggleButtonAlignCenter.isSelected()) {
            return (byte)2;
        }
        return null;
    }

    private void setSelectedHorizontalAlignment(Byte b) {
        this.jToggleButtonAlignLeft.setSelected(b != null && b == 1);
        this.jToggleButtonAlignRight.setSelected(b != null && b == 3);
        this.jToggleButtonAlignJustify.setSelected(b != null && b == 4);
        this.jToggleButtonAlignCenter.setSelected(b != null && b == 2);
    }

    private Byte getSelectedVerticalAlignment() {
        if (this.jToggleButtonAlignTop.isSelected()) {
            return (byte)1;
        }
        if (this.jToggleButtonAlignMiddle.isSelected()) {
            return (byte)2;
        }
        if (this.jToggleButtonAlignBottom.isSelected()) {
            return (byte)3;
        }
        return null;
    }

    private void setSelectedVerticalAlignment(Byte b) {
        this.jToggleButtonAlignTop.setSelected(b != null && b == 1);
        this.jToggleButtonAlignMiddle.setSelected(b != null && b == 2);
        this.jToggleButtonAlignBottom.setSelected(b != null && b == 3);
    }

    private boolean setHorizontalAlignment(boolean firstElement, byte horizontalAlignment) {
        Byte selectedValue;
        if (!firstElement && (selectedValue = this.getSelectedHorizontalAlignment()) != null && selectedValue != horizontalAlignment) {
            this.setSelectedHorizontalAlignment(null);
        }
        this.setSelectedHorizontalAlignment(horizontalAlignment);
        return true;
    }

    private boolean setVerticalAlignment(boolean firstElement, byte verticalAlignment) {
        Byte selectedValue;
        if (!firstElement && (selectedValue = this.getSelectedVerticalAlignment()) != null && selectedValue != verticalAlignment) {
            this.setSelectedVerticalAlignment(null);
        }
        this.setSelectedVerticalAlignment(verticalAlignment);
        return true;
    }

    private boolean setToggleButton(boolean firstElement, boolean val, JToggleButton button) {
        if (!firstElement && button.isSelected() != val) {
            button.setSelected(false);
            return false;
        }
        button.setSelected(val);
        return true;
    }

    public boolean isChanging() {
        return this.changing;
    }

    public void setChanging(boolean changing) {
        this.changing = changing;
    }
}

